/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.dataflow;

import java.util.BitSet;
import java.util.List;
import org.jruby.compiler.ir.dataflow.DataFlowProblem;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.representations.BasicBlock;
import org.jruby.compiler.ir.representations.CFG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FlowGraphNode {
    protected DataFlowProblem _prob;
    protected BasicBlock _bb;

    public FlowGraphNode(DataFlowProblem p2, BasicBlock n) {
        this._prob = p2;
        this._bb = n;
    }

    public abstract void initSolnForNode();

    public abstract void compute_MEET(CFG.CFG_Edge var1, FlowGraphNode var2);

    public abstract boolean applyTransferFunction();

    public abstract void buildDataFlowVars(IR_Instr var1);

    public void init() {
    }

    public void finalizeSolnForNode() {
    }

    public BasicBlock getBB() {
        return this._bb;
    }

    public void buildDataFlowVars() {
        for (IR_Instr i : this._bb.getInstrs()) {
            this.buildDataFlowVars(i);
        }
    }

    private void processDestBB(List<FlowGraphNode> workList, BitSet bbSet, BasicBlock d) {
        int id2 = d.getID();
        if (!bbSet.get(id2)) {
            bbSet.set(id2);
            workList.add(this._prob.getFlowGraphNode(d));
        }
    }

    public void computeDataFlowInfo(List<FlowGraphNode> workList, BitSet bbSet) {
        block8: {
            block9: {
                bbSet.clear(this._bb.getID());
                this.initSolnForNode();
                if (this._prob.getFlowDirection() == DataFlowProblem.DF_Direction.FORWARD) {
                    for (CFG.CFG_Edge e : this._prob.incomingEdgesOf(this._bb)) {
                        this.compute_MEET(e, this._prob.getFlowGraphNode(e._src));
                    }
                } else if (this._prob.getFlowDirection() == DataFlowProblem.DF_Direction.BACKWARD) {
                    for (CFG.CFG_Edge e : this._prob.outgoingEdgesOf(this._bb)) {
                        this.compute_MEET(e, this._prob.getFlowGraphNode(e._dst));
                    }
                } else {
                    throw new RuntimeException("Bidirectional data flow computation not implemented yet!");
                }
                this.finalizeSolnForNode();
                boolean changed = this.applyTransferFunction();
                if (!changed) break block8;
                if (this._prob.getFlowDirection() != DataFlowProblem.DF_Direction.FORWARD) break block9;
                for (CFG.CFG_Edge e : this._prob.outgoingEdgesOf(this._bb)) {
                    this.processDestBB(workList, bbSet, e._dst);
                }
                break block8;
            }
            if (this._prob.getFlowDirection() != DataFlowProblem.DF_Direction.BACKWARD) break block8;
            for (CFG.CFG_Edge e : this._prob.incomingEdgesOf(this._bb)) {
                this.processDestBB(workList, bbSet, e._src);
            }
        }
    }
}

