/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNode
extends Node {
    private transient DynamicScope scope;
    private StaticScope staticScope;
    private Node bodyNode;

    public RootNode(ISourcePosition position, DynamicScope scope, Node bodyNode) {
        super(position);
        assert (bodyNode != null) : "bodyNode is not null";
        this.scope = scope;
        this.staticScope = scope.getStaticScope();
        this.bodyNode = bodyNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ROOTNODE;
    }

    public DynamicScope getScope() {
        return this.scope;
    }

    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRootNode(this);
    }

    @Override
    public List<Node> childNodes() {
        return RootNode.createList(this.bodyNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.scope == null) {
            this.scope = DynamicScope.newDynamicScope(this.staticScope);
        }
        StaticScope theStaticScope = this.scope.getStaticScope();
        context.preScopedBody(this.scope);
        if (theStaticScope.getModule() == null) {
            theStaticScope.setModule(runtime2.getObject());
        }
        try {
            IRubyObject iRubyObject = this.bodyNode.interpret(runtime2, context, self, aBlock);
            return iRubyObject;
        }
        finally {
            context.postScopedBody();
        }
    }
}

