/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.nailgun;

import com.martiansoftware.nailgun.Alias;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class AliasManager {
    private Map aliases = new HashMap();

    public AliasManager() {
        try {
            Properties properties = new Properties();
            properties.load(this.getClass().getClassLoader().getResourceAsStream("com/martiansoftware/nailgun/builtins/builtins.properties"));
            this.loadFromProperties(properties);
        }
        catch (IOException iOException) {
            System.err.println("Unable to load builtins.properties: " + iOException.getMessage());
        }
    }

    public void loadFromProperties(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string2.endsWith(".desc")) continue;
            try {
                Class<?> clazz = Class.forName(properties.getProperty(string2));
                String string3 = properties.getProperty(string2 + ".desc", "");
                this.addAlias(new Alias(string2, string3, clazz));
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Unable to locate class " + properties.getProperty(string2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAlias(Alias alias) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.put(alias.getName(), alias);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAliases() {
        TreeSet treeSet = new TreeSet();
        Map map = this.aliases;
        synchronized (map) {
            treeSet.addAll(this.aliases.values());
        }
        return treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAlias(String string2) {
        Map map = this.aliases;
        synchronized (map) {
            this.aliases.remove(string2);
        }
    }

    public Alias getAlias(String string2) {
        return (Alias)this.aliases.get(string2);
    }
}

