/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.util.BufferUtil;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class StringIO {
    private static final ThreadLocal<SoftReference<StringIO>> localData = new ThreadLocal<SoftReference<StringIO>>(){

        @Override
        protected synchronized SoftReference<StringIO> initialValue() {
            return new SoftReference<StringIO>(new StringIO());
        }
    };
    private static final Charset defaultCharset = Charset.defaultCharset();
    public final CharsetEncoder encoder = defaultCharset.newEncoder();
    public final CharsetDecoder decoder = defaultCharset.newDecoder();
    public final int nulByteCount = Math.round(this.encoder.maxBytesPerChar());

    public static final StringIO getStringIO() {
        StringIO io2 = localData.get().get();
        if (io2 == null) {
            io2 = new StringIO();
            localData.set(new SoftReference<StringIO>(io2));
        }
        return io2;
    }

    public StringIO() {
        this.encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public final ByteBuffer toNative(CharSequence value2, int minSize, boolean copyIn) {
        int len = (int)(((float)Math.max(minSize, value2.length()) + 1.0f) * this.encoder.maxBytesPerChar());
        ByteBuffer buf = ByteBuffer.allocate(len);
        if (copyIn) {
            this.toNative(value2, buf);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ByteBuffer toNative(CharSequence value2, ByteBuffer buf) {
        buf.mark();
        try {
            this.encoder.reset();
            this.encoder.encode(CharBuffer.wrap(value2), buf, true);
            this.encoder.flush(buf);
            this.nulTerminate(buf);
        }
        finally {
            buf.reset();
        }
        return buf;
    }

    public final CharSequence fromNative(ByteBuffer buf, int maxSize) {
        int end2 = BufferUtil.positionOf(buf, (byte)0);
        if (end2 < 0 || end2 > maxSize) {
            end2 = maxSize;
        }
        int limit2 = buf.limit();
        buf.limit(end2);
        try {
            CharBuffer charBuffer = this.decoder.reset().decode(buf);
            return charBuffer;
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
        finally {
            buf.limit(limit2);
        }
    }

    public final CharSequence fromNative(ByteBuffer buf) {
        try {
            return this.decoder.reset().decode(buf);
        }
        catch (CharacterCodingException ex) {
            throw new Error("Illegal character data in native string", ex);
        }
    }

    public final void nulTerminate(ByteBuffer buf) {
        int nulSize;
        for (nulSize = this.nulByteCount; nulSize >= 4; nulSize -= 4) {
            buf.putInt(0);
        }
        if (nulSize >= 2) {
            buf.putShort((short)0);
            nulSize -= 2;
        }
        if (nulSize >= 1) {
            buf.put((byte)0);
        }
    }
}

