/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;

public final class NbClipboard
extends ExClipboard
implements LookupListener,
Runnable,
FlavorListener,
AWTEventListener {
    private Logger log;
    private Clipboard systemClipboard;
    private ExClipboard.Convertor[] convertors;
    private Lookup.Result<ExClipboard.Convertor> result;
    final boolean slowSystemClipboard;
    private Transferable last;
    private long lastWindowActivated;
    private long lastWindowDeactivated;
    private Reference<Object> lastWindowDeactivatedSource = new WeakReference<Object>(null);
    private RequestProcessor.Task syncTask = new RequestProcessor("System clipboard synchronizer").create((Runnable)this, true);
    private Transferable data;
    private ClipboardOwner dataOwner;

    public NbClipboard() {
        this(Toolkit.getDefaultToolkit().getSystemClipboard());
    }

    NbClipboard(Clipboard systemClipboard) {
        super("NBClipboard");
        this.systemClipboard = systemClipboard;
        this.log = Logger.getLogger("org.netbeans.core.NbClipboard");
        this.result = Lookup.getDefault().lookupResult(ExClipboard.Convertor.class);
        this.result.addLookupListener((LookupListener)this);
        systemClipboard.addFlavorListener(this);
        this.resultChanged(null);
        this.slowSystemClipboard = System.getProperty("netbeans.slow.system.clipboard.hack") != null ? Boolean.getBoolean("netbeans.slow.system.clipboard.hack") : !Utilities.isMac();
        if (!this.slowSystemClipboard) {
            if (System.getProperty("sun.awt.datatransfer.timeout") == null) {
                System.setProperty("sun.awt.datatransfer.timeout", "1000");
            }
        } else {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    protected synchronized ExClipboard.Convertor[] getConvertors() {
        return this.convertors;
    }

    public synchronized void resultChanged(LookupEvent ev) {
        Collection c = this.result.allInstances();
        ExClipboard.Convertor[] temp = new ExClipboard.Convertor[c.size()];
        this.convertors = c.toArray(temp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContents(Transferable contents, ClipboardOwner owner) {
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "setContents called with: ");
                this.logFlavors(contents, Level.FINER, this.log.isLoggable(Level.FINEST));
            }
            contents = this.convert(contents);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "After conversion:");
                this.logFlavors(contents, Level.FINER, this.log.isLoggable(Level.FINEST));
            }
            if (this.slowSystemClipboard) {
                super.setContents(contents, owner);
            } else {
                if (this.last != null) {
                    NbClipboard.transferableOwnershipLost((Transferable)this.last);
                }
                this.last = contents;
            }
            this.data = contents;
            this.dataOwner = owner;
            this.syncTask.schedule(0);
        }
        this.fireClipboardChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transferable getContents(Object requestor) {
        try {
            Transferable prev;
            this.log.log(Level.FINE, "getContents, slowSystemClipboard: {0}", this.slowSystemClipboard);
            if (this.slowSystemClipboard) {
                long curr = System.currentTimeMillis();
                if (this.lastWindowActivated != 0L && this.lastWindowActivated + 100L < curr) {
                    this.lastWindowActivated = 0L;
                    this.syncTask.schedule(0);
                    boolean finished = this.syncTask.waitFinished(100L);
                    this.log.log(Level.FINE, "after syncTask wait, finished {0}", finished);
                } else if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("no wait, last: " + this.lastWindowActivated + " now: " + curr);
                }
                prev = super.getContents(requestor);
            } else {
                this.syncTask.waitFinished();
                this.log.log(Level.FINE, "after syncTask clipboard wait");
                try {
                    prev = this.systemClipboard.getContents(requestor);
                }
                catch (IllegalStateException isE) {
                    this.log.log(Level.INFO, "System clipboard not available.", isE);
                    prev = null;
                }
            }
            NbClipboard isE = this;
            synchronized (isE) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "getContents by " + requestor);
                    this.logFlavors(prev, Level.FINE, this.log.isLoggable(Level.FINEST));
                }
                if (prev == null) {
                    return null;
                }
                Transferable res = this.convert(prev);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "getContents by " + requestor);
                    this.logFlavors(res, Level.FINE, this.log.isLoggable(Level.FINEST));
                    res = new LoggableTransferable(res);
                }
                return res;
            }
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (InterruptedException ex) {
            Logger.getLogger(NbClipboard.class.getName()).log(Level.WARNING, null, ex);
            return null;
        }
        catch (Throwable ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Transferable cnts = null;
        ClipboardOwner ownr = null;
        this.log.fine("Running update");
        NbClipboard nbClipboard = this;
        synchronized (nbClipboard) {
            if (this.data != null) {
                cnts = this.data;
                ownr = this.dataOwner;
            }
            this.data = null;
            this.dataOwner = null;
        }
        if (cnts != null) {
            try {
                this.systemClipboard.setContents(cnts, ownr);
            }
            catch (IllegalStateException e) {
                this.log.log(Level.FINE, "systemClipboard not available", e);
                this.data = cnts;
                this.dataOwner = ownr;
                this.syncTask.schedule(100);
                return;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "systemClipboard updated:");
                this.logFlavors(cnts, Level.FINE, this.log.isLoggable(Level.FINEST));
            }
            return;
        }
        try {
            Transferable transferable = this.systemClipboard.getContents(this);
            super.setContents(transferable, null);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "internal clipboard updated:");
                this.logFlavors(transferable, Level.FINE, this.log.isLoggable(Level.FINEST));
            }
            this.fireClipboardChange();
        }
        catch (ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    final void waitFinished() {
        this.syncTask.waitFinished();
    }

    final void activateWindowHack(boolean reschedule) {
        this.lastWindowActivated = System.currentTimeMillis();
        if (reschedule) {
            this.syncTask.schedule(0);
        }
    }

    private void logFlavors(Transferable trans, Level level, boolean content) {
        if (trans == null) {
            this.log.log(level, "  no clipboard contents");
        } else {
            DataFlavor[] arr = trans.getTransferDataFlavors();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < arr.length; ++i) {
                sb.append("  ").append(i).append(" = ").append(arr[i]);
                if (content) {
                    try {
                        sb.append(" contains: ").append(trans.getTransferData(arr[i]));
                    }
                    catch (UnsupportedFlavorException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                sb.append("\n");
            }
            this.log.log(level, sb.toString());
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent e) {
        this.fireClipboardChange();
    }

    @Override
    public void eventDispatched(AWTEvent ev) {
        if (!(ev instanceof WindowEvent)) {
            return;
        }
        if (ev.getID() == 206) {
            this.lastWindowDeactivated = System.currentTimeMillis();
            this.lastWindowDeactivatedSource = new WeakReference<Object>(ev.getSource());
        }
        if (ev.getID() == 205) {
            if (System.currentTimeMillis() - this.lastWindowDeactivated < 100L && ev.getSource() == this.lastWindowDeactivatedSource.get()) {
                this.activateWindowHack(false);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "window activated scheduling update");
            }
            this.syncTask.schedule(0);
        }
    }

    private final class LoggableTransferable
    implements Transferable {
        private Transferable delegate;

        public LoggableTransferable(Transferable delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            NbClipboard.this.log.log(Level.FINE, "Request for flavor: " + flavor);
            Object res = this.delegate.getTransferData(flavor);
            NbClipboard.this.log.log(Level.FINE, "Returning value: " + res);
            return res;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.delegate.getTransferDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            boolean res = this.delegate.isDataFlavorSupported(flavor);
            NbClipboard.this.log.log(Level.FINE, "isDataFlavorSupported: " + flavor + " result: " + res);
            return res;
        }
    }
}

