/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class DwarfSource
implements SourceFileProperties {
    private static final boolean FULL_TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.source");
    private static final boolean CUT_LOCALHOST_NET_ADRESS = Boolean.getBoolean("cnd.dwarfdiscovery.cut.localhost.net.adress");
    private static boolean ourGatherMacros = true;
    private static boolean ourGatherIncludes = true;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private static final String CYG_DRIVE_WIN = "\\cygdrive\\";
    private static final String CYGWIN_PATH = ":/cygwin";
    private String cygwinPath;
    private String compilePath;
    private String sourceName;
    private String fullName;
    private ItemProperties.LanguageKind language;
    private List<String> userIncludes;
    private List<String> systemIncludes;
    private boolean haveSystemIncludes;
    private Map<String, String> userMacros;
    private Map<String, String> systemMacros;
    private boolean haveSystemMacros;
    private Set<String> includedFiles;
    private BaseDwarfProvider.CompilerSettings normilizeProvider;
    private Map<String, BaseDwarfProvider.GrepEntry> grepBase;
    private String compilerName;

    DwarfSource(CompilationUnit compilationUnit, boolean bl, BaseDwarfProvider.CompilerSettings compilerSettings, Map<String, BaseDwarfProvider.GrepEntry> map) throws IOException {
        this.initCompilerSettings(compilerSettings, bl);
        this.grepBase = map;
        this.initSourceSettings(compilationUnit, bl);
    }

    private void countFileName(CompilationUnit compilationUnit) throws IOException {
        this.fullName = compilationUnit.getSourceFileAbsolutePath();
        this.fullName = this.fixFileName(this.fullName);
        File file = new File(this.fullName);
        this.fullName = CndFileUtils.normalizeAbsolutePath((String)file.getAbsolutePath());
        this.fullName = this.linkSupport(this.fullName);
        if (this.fullName != null && this.normilizeProvider.isWindows()) {
            this.fullName = this.fullName.replace('/', '\\');
        }
        this.fullName = PathCache.getString(this.fullName);
        if (FULL_TRACE) {
            System.out.println("Compilation unit full name:" + this.fullName);
        }
    }

    private void initCompilerSettings(BaseDwarfProvider.CompilerSettings compilerSettings, boolean bl) {
        List<String> list = compilerSettings.getSystemIncludePaths(bl);
        if (list != null) {
            this.systemIncludes = new ArrayList<String>(list);
            if (compilerSettings.isWindows()) {
                if (FULL_TRACE) {
                    System.out.println("CompileFlavor:" + compilerSettings.getCompileFlavor());
                }
                if ("Cygwin".equals(compilerSettings.getCompileFlavor())) {
                    this.cygwinPath = compilerSettings.getCygwinDrive();
                    if (this.cygwinPath == null) {
                        for (String string : list) {
                            char c;
                            int n = string.toLowerCase().indexOf(CYGWIN_PATH);
                            if (n <= 0 || this.cygwinPath != null) continue;
                            this.cygwinPath = "" + Character.toUpperCase(string.charAt(0)) + CYGWIN_PATH;
                            n += CYGWIN_PATH.length();
                            while (n < string.length() && (c = string.charAt(n)) != '\\') {
                                this.cygwinPath = this.cygwinPath + "" + c;
                                ++n;
                            }
                            if (FULL_TRACE) {
                                System.out.println("Detect cygwinPath:" + this.cygwinPath);
                            }
                            break;
                        }
                    }
                }
            }
        } else {
            this.systemIncludes = new ArrayList<String>();
        }
        this.haveSystemIncludes = this.systemIncludes.size() > 0;
        Map<String, String> map = compilerSettings.getSystemMacroDefinitions(bl);
        this.systemMacros = map != null ? new HashMap<String, String>(map) : new HashMap<String, String>();
        this.haveSystemMacros = this.systemMacros.size() > 0;
        this.normilizeProvider = compilerSettings;
    }

    public String getCompilePath() {
        return this.compilePath;
    }

    public String getItemPath() {
        return this.fullName;
    }

    public String getItemName() {
        return this.sourceName;
    }

    public List<String> getUserInludePaths() {
        return this.userIncludes;
    }

    public List<String> getSystemInludePaths() {
        return this.systemIncludes;
    }

    public Set<String> getIncludedFiles() {
        return this.includedFiles;
    }

    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    public Map<String, String> getSystemMacros() {
        return this.systemMacros;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }

    public String getCompilerName() {
        return this.compilerName;
    }

    private String fixFileName(String string) {
        if (string == null) {
            return string;
        }
        if (this.normilizeProvider.isWindows()) {
            if (FULL_TRACE) {
                System.out.println("Try to fix win name:" + string);
            }
            if (string.startsWith(CYG_DRIVE_UNIX)) {
                string = string.substring(CYG_DRIVE_UNIX.length());
                string = "" + Character.toUpperCase(string.charAt(0)) + ':' + string.substring(1);
                string = string.replace('\\', '/');
                if (this.cygwinPath == null) {
                    this.cygwinPath = "" + Character.toUpperCase(string.charAt(0)) + CYGWIN_PATH;
                    if (FULL_TRACE) {
                        System.out.println("Set cygwinPath:" + this.cygwinPath);
                    }
                }
            } else {
                int n = string.indexOf(CYG_DRIVE_WIN);
                if (n > 0) {
                    if (this.cygwinPath == null) {
                        this.cygwinPath = "" + Character.toUpperCase(string.charAt(0)) + CYGWIN_PATH;
                        if (FULL_TRACE) {
                            System.out.println("Set cygwinPath:" + this.cygwinPath);
                        }
                    }
                    string = string.substring(n + CYG_DRIVE_UNIX.length());
                    string = "" + Character.toUpperCase(string.charAt(0)) + ':' + string.substring(1);
                    string = string.replace('\\', '/');
                }
            }
            if (FULL_TRACE) {
                System.out.println("\t" + string);
            }
        } else if (CUT_LOCALHOST_NET_ADRESS && Utilities.isUnix() && string.startsWith("/net/")) {
            try {
                String string2;
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string3 = inetAddress.getHostName();
                if (string3 != null && string3.length() > 0 && string.startsWith(string2 = "/net/" + string3 + "/")) {
                    string = string.substring(string2.length() - 1);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return string;
    }

    private String linkSupport(String string) {
        if (this.normilizeProvider.isWindows() && !new File(string).exists()) {
            String string2 = string + ".lnk";
            if (new File(string2).exists()) {
                String string3 = LinkSupport.getOriginalFile((String)string2);
                if (string3 != null) {
                    string = string3;
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\\/");
                StringBuilder stringBuilder = new StringBuilder();
                while (stringTokenizer.hasMoreTokens()) {
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(string5);
                    if (string5.length() <= 0 || string5.charAt(string5.length() - 1) == ':' || new File(string4 = stringBuilder.toString()).exists()) continue;
                    string2 = string4 + ".lnk";
                    if (new File(string2).exists()) {
                        String string6 = LinkSupport.getOriginalFile((String)string2);
                        if (string6 != null) {
                            stringBuilder = new StringBuilder(string6);
                            continue;
                        }
                        return string;
                    }
                    return string;
                }
                string = stringBuilder.toString();
            }
        }
        return string;
    }

    static String extractCompilerName(CompilationUnit compilationUnit, boolean bl) throws IOException {
        String string = null;
        if (compilationUnit.getCompileOptions() == null) {
            string = compilationUnit.getProducer();
        } else {
            int n;
            String string2 = compilationUnit.getCompileOptions();
            int n2 = string2.indexOf("R=");
            if (n2 >= 0 && (n = string2.indexOf(";", n2)) >= 0) {
                string = PathCache.getString(string2.substring(n2 + 2, n));
            }
            if (string == null) {
                string = bl ? PathCache.getString("CC") : PathCache.getString("cc");
            }
        }
        return string;
    }

    static boolean isSunStudioCompiler(CompilationUnit compilationUnit) throws IOException {
        return compilationUnit.getCompileOptions() != null;
    }

    private void initSourceSettings(CompilationUnit compilationUnit, boolean bl) throws IOException {
        this.userIncludes = new ArrayList<String>();
        this.userMacros = new HashMap<String, String>();
        this.includedFiles = new HashSet<String>();
        this.countFileName(compilationUnit);
        this.compilerName = PathCache.getString(DwarfSource.extractCompilerName(compilationUnit, bl));
        this.compilePath = PathCache.getString(this.fixFileName(compilationUnit.getCompilationDir()));
        this.sourceName = PathCache.getString(compilationUnit.getSourceFileName());
        if (this.compilePath == null && this.sourceName.lastIndexOf(47) > 0) {
            int n = this.sourceName.lastIndexOf(47);
            this.compilePath = this.sourceName.substring(0, n);
            this.sourceName = this.sourceName.substring(n + 1);
        } else {
            if (this.sourceName.startsWith("/")) {
                this.sourceName = DiscoveryUtils.getRelativePath((String)this.compilePath, (String)this.sourceName);
            }
            if (this.compilePath == null) {
                if (this.fullName != null && this.fullName.lastIndexOf(47) > 0) {
                    int n = this.fullName.lastIndexOf(47);
                    this.compilePath = this.fullName.substring(0, n);
                } else {
                    this.compilePath = "";
                }
            }
        }
        this.language = bl ? ItemProperties.LanguageKind.CPP : ItemProperties.LanguageKind.C;
    }

    public void process(CompilationUnit compilationUnit) throws IOException {
        String string = compilationUnit.getCommandLine();
        if (string != null && string.length() > 0) {
            this.gatherLine(string);
            this.gatherIncludedFiles(compilationUnit);
        } else {
            this.gatherMacros(compilationUnit);
            this.gatherIncludes(compilationUnit);
        }
    }

    private void addUserIncludePath(String string) {
        if (!this.userIncludes.contains(string)) {
            this.userIncludes.add(string);
        }
    }

    private void gatherLine(String string) {
        if (FULL_TRACE) {
            System.out.println("Process command line " + string);
        }
        Iterator iterator = DiscoveryUtils.scanCommandLine((String)string).iterator();
        while (iterator.hasNext()) {
            String string2;
            String string3 = (String)iterator.next();
            if (string3.startsWith("-D")) {
                string2 = string3.substring(2);
                int n = string2.indexOf(61);
                if (n > 0) {
                    String string4 = string2.substring(n + 1).trim();
                    if (string4.length() >= 2 && (string4.charAt(0) == '\'' && string4.charAt(string4.length() - 1) == '\'' || string4.charAt(0) == '\"' && string4.charAt(string4.length() - 1) == '\"')) {
                        string4 = string4.substring(1, string4.length() - 1);
                    }
                    this.userMacros.put(PathCache.getString(string2.substring(0, n)), PathCache.getString(string4));
                    continue;
                }
                this.userMacros.put(PathCache.getString(string2), null);
                continue;
            }
            if (string3.startsWith("-I")) {
                string2 = string3.substring(2);
                if (string2.length() == 0 && iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
                String string5 = PathCache.getString(string2);
                this.addUserIncludePath(string5);
                continue;
            }
            if (string3.startsWith("-Y")) {
                string2 = string3.substring(2);
                if (string2.length() == 0 && iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
                if (!string2.startsWith("I,")) continue;
                string2 = string2.substring(2);
                String string6 = PathCache.getString(string2);
                this.addUserIncludePath(string6);
                continue;
            }
            if (string3.startsWith("-isystem")) {
                string2 = string3.substring(8);
                if (string2.length() == 0 && iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
                String string7 = PathCache.getString(string2);
                this.addUserIncludePath(string7);
                continue;
            }
            if (string3.startsWith("-include")) {
                string2 = string3.substring(8);
                if (string2.length() == 0 && iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
                String string8 = PathCache.getString(string2);
                this.addUserIncludePath(string8);
                continue;
            }
            if (string3.startsWith("-imacros")) {
                string2 = string3.substring(8);
                if (string2.length() == 0 && iterator.hasNext()) {
                    string2 = (String)iterator.next();
                }
                String string9 = PathCache.getString(string2);
                this.addUserIncludePath(string9);
                continue;
            }
            if (string3.equals("-fopenmp")) {
                this.userMacros.put("_OPENMP", "200505");
                continue;
            }
            if (!string3.equals("-xopenmp") && !string3.equals("-xopenmp=parallel") && !string3.equals("-xopenmp=noopt")) continue;
            this.userMacros.put("_OPENMP", null);
        }
    }

    private String fixCygwinPath(String string) {
        if (this.cygwinPath != null) {
            if (string.startsWith("/usr/lib/")) {
                string = this.cygwinPath + string.substring(4);
            } else if (string.startsWith("/usr")) {
                string = this.cygwinPath + string;
            }
        }
        if (string.startsWith(CYG_DRIVE_UNIX)) {
            string = this.fixFileName(string);
        }
        if (this.normilizeProvider.isWindows()) {
            string = string.replace('\\', '/');
        }
        return string;
    }

    private boolean isSystemPath(String string) {
        string = this.fixCygwinPath(string);
        if ((string = this.normalizePath(string)).startsWith("/") || string.length() > 2 && string.charAt(1) == ':') {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string2 : this.systemIncludes) {
                if (string.equals(string2)) {
                    return true;
                }
                for (String string3 : this.grepSystemFolder((String)string2).includes) {
                    hashSet.add(string3);
                }
            }
            for (String string2 : this.systemIncludes) {
                for (String string3 : hashSet) {
                    if (!string.startsWith(string2) || !string.substring(string2.length()).startsWith(string3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void addpath(String string) {
        if (this.haveSystemIncludes) {
            if (!this.isSystemPath(string)) {
                string = this.fixCygwinPath(string);
                string = this.normalizePath(string);
                this.addUserIncludePath(PathCache.getString(string));
                if (FULL_TRACE) {
                    System.out.println("\tuser:" + string);
                }
            }
        } else if (string.startsWith("/usr")) {
            string = this.fixCygwinPath(string);
            string = this.normalizePath(string);
            if (!this.systemIncludes.contains(string = PathCache.getString(string))) {
                this.systemIncludes.add(string);
            }
            if (FULL_TRACE) {
                System.out.println("\tsystem:" + string);
            }
        } else {
            string = this.fixCygwinPath(string);
            string = this.normalizePath(string);
            this.addUserIncludePath(PathCache.getString(string));
            if (FULL_TRACE) {
                System.out.println("\tuser:" + string);
            }
        }
    }

    private String normalizePath(String string) {
        if (string.startsWith("/") || string.length() > 2 && string.charAt(1) == ':') {
            return this.normilizeProvider.getNormalizedPath(string);
        }
        return string;
    }

    private void gatherIncludes(CompilationUnit compilationUnit) throws IOException {
        Object object;
        Object object2;
        String string;
        if (!ourGatherIncludes) {
            return;
        }
        DwarfStatementList dwarfStatementList = compilationUnit.getStatementList();
        if (dwarfStatementList == null) {
            if (FULL_TRACE) {
                System.out.println("Include paths not found");
            }
            return;
        }
        Object object3 = dwarfStatementList.getIncludeDirectories().iterator();
        while (object3.hasNext()) {
            this.addpath((String)object3.next());
        }
        object3 = this.grepSourceFile((String)this.fullName).includes;
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            string = (String)object4.next();
            this.cutFolderPrefix(string, dwarfStatementList);
        }
        object4 = dwarfStatementList.getFilePaths();
        string = compilationUnit.getMacrosTable();
        if (string != null) {
            object2 = string.getCommandLineIncludedFiles();
            object = object2.iterator();
            while (object.hasNext()) {
                int n = (Integer)object.next();
                this.processPath(dwarfStatementList.getFilePath(n), (List<String>)object3, dwarfStatementList, false);
            }
        }
        object2 = object4.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.processPath((String)object, (List<String>)object3, dwarfStatementList, true);
        }
        if (FULL_TRACE) {
            System.out.println("Include paths:" + this.userIncludes);
        }
    }

    private void processPath(String string, List<String> list, DwarfStatementList dwarfStatementList, boolean bl) {
        String string2 = string = string.replace('\\', '/');
        if (FULL_TRACE) {
            System.out.println("Included file original:" + string);
        }
        if (string.startsWith("./")) {
            string2 = this.compilePath + string.substring(1);
        } else if (string.startsWith("../")) {
            string2 = this.compilePath + File.separator + string;
        } else if (!string.startsWith("/")) {
            string2 = this.compilePath + File.separator + string;
        } else {
            string2 = this.fixCygwinPath(string);
            string2 = this.normalizePath(string2);
        }
        if (this.normilizeProvider.isWindows()) {
            string2 = string2.replace('\\', '/');
        }
        if (bl) {
            String string3 = null;
            int n = string2.lastIndexOf(47);
            if (n > 0 && !this.isSystemPath(string3 = string2.substring(0, n))) {
                list = this.grepSourceFile((String)string2).includes;
                for (String string4 : list) {
                    this.cutFolderPrefix(string4, dwarfStatementList);
                }
                this.addpath(string3);
            }
        } else {
            this.addpath(string2);
        }
        this.includedFiles.add(PathCache.getString(string2));
        if (FULL_TRACE) {
            System.out.println("Included file:" + string2);
        }
    }

    private void cutFolderPrefix(String string, DwarfStatementList dwarfStatementList) {
        if (this.normilizeProvider.isWindows()) {
            string = string.replace('\\', '/');
        }
        if (string.indexOf(47) > 0) {
            int n = string.lastIndexOf(47);
            String string2 = string.substring(n + 1);
            String string3 = string.substring(0, n);
            String string4 = "/" + string3;
            List list = dwarfStatementList.getPathsForFile(string2);
            if (FULL_TRACE) {
                System.out.println("Try to find new include paths for:" + string2 + " in folder " + string4);
            }
            for (String string5 : list) {
                if (FULL_TRACE) {
                    System.out.println("    candidate:" + string5);
                }
                if (string5.endsWith(string4)) {
                    String string6 = string5.substring(0, string5.length() - string4.length());
                    string6 = this.fixCygwinPath(string6);
                    if (this.userIncludes.contains(string6 = this.normalizePath(string6))) break;
                    if (this.haveSystemIncludes) {
                        boolean bl = false;
                        if (string6.startsWith("/") || string6.length() > 2 && string6.charAt(1) == ':') {
                            bl = this.systemIncludes.contains(string6);
                        }
                        if (bl) break;
                        if (FULL_TRACE) {
                            System.out.println("    Find new include path:" + string6);
                        }
                        this.addUserIncludePath(PathCache.getString(string6));
                        break;
                    }
                    if (string5.startsWith("/usr")) break;
                    if (FULL_TRACE) {
                        System.out.println("    Find new include path:" + string6);
                    }
                    this.addUserIncludePath(PathCache.getString(string6));
                    break;
                }
                if (!string5.equals(string3)) continue;
                String string7 = ".";
                if (this.userIncludes.contains(string7)) break;
                if (FULL_TRACE) {
                    System.out.println("    Find new include path:" + string7);
                }
                this.addUserIncludePath(PathCache.getString(string7));
                break;
            }
        }
    }

    private void gatherIncludedFiles(CompilationUnit compilationUnit) throws IOException {
        if (!ourGatherIncludes) {
            return;
        }
        DwarfStatementList dwarfStatementList = compilationUnit.getStatementList();
        if (dwarfStatementList == null) {
            return;
        }
        Iterator iterator = dwarfStatementList.getFilePaths().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = string = (String)iterator.next();
            if (string.startsWith("./")) {
                string2 = this.compilePath + string.substring(1);
            } else if (string.startsWith("../")) {
                string2 = this.compilePath + File.separator + string;
            }
            string2 = this.normalizePath(string2);
            this.includedFiles.add(PathCache.getString(string2));
        }
    }

    private void gatherMacros(CompilationUnit compilationUnit) throws IOException {
        if (!ourGatherMacros) {
            return;
        }
        DwarfMacinfoTable dwarfMacinfoTable = compilationUnit.getMacrosTable();
        if (dwarfMacinfoTable == null) {
            if (FULL_TRACE) {
                System.out.println("Macros not found");
            }
            return;
        }
        int n = this.grepSourceFile((String)this.fullName).firstMacroLine;
        ArrayList arrayList = dwarfMacinfoTable.getCommandLineMarcos();
        for (DwarfMacinfoEntry dwarfMacinfoEntry : arrayList) {
            String string;
            String string2;
            String string3 = dwarfMacinfoEntry.definition;
            int n2 = string3.indexOf(32);
            String string4 = null;
            if (n2 > 0) {
                string2 = PathCache.getString(string3.substring(0, n2));
                string4 = PathCache.getString(string3.substring(n2 + 1).trim());
            } else {
                string2 = PathCache.getString(string3);
            }
            if (n == dwarfMacinfoEntry.lineNum && string2.equals(this.grepSourceFile((String)this.fullName).firstMacro)) break;
            if (this.haveSystemMacros && this.systemMacros.containsKey(string2) && this.equalValues(string = this.systemMacros.get(string2), string4)) continue;
            this.userMacros.put(string2, string4);
        }
        if (FULL_TRACE) {
            System.out.println("Macros:" + this.userMacros);
        }
    }

    private boolean equalValues(String string, String string2) {
        if (string2 == null || "1".equals(string2)) {
            return string == null || "1".equals(string);
        }
        return string2.equals(string);
    }

    /*
     * WARNING - void declaration
     */
    private BaseDwarfProvider.GrepEntry grepSystemFolder(String string) {
        File file;
        File[] fileArray;
        BaseDwarfProvider.GrepEntry grepEntry = this.grepBase.get(string);
        if (grepEntry != null) {
            return grepEntry;
        }
        grepEntry = new BaseDwarfProvider.GrepEntry();
        File file2 = new File(string);
        if (file2.exists() && file2.canRead() && file2.isDirectory()) {
            void string5;
            fileArray = file2.listFiles();
            int n = fileArray.length;
            boolean bl = false;
            while (string5 < n) {
                file = fileArray[string5];
                if (file.exists() && file.canRead() && !file.isDirectory()) {
                    List<String> iOException = this.grepSourceFile((String)file.getAbsolutePath()).includes;
                    Iterator<String> iterator = iOException.iterator();
                    while (iterator.hasNext()) {
                        String string2 = iterator.next();
                        if (string2.indexOf("..") > 0 || string2.startsWith("/") || string2.indexOf(":") > 0 || string2.indexOf(47) <= 0) continue;
                        int n2 = string2.lastIndexOf(47);
                        String string3 = string2.substring(0, n2);
                        String string4 = "/" + string3;
                        if (grepEntry.includes.contains(string4)) continue;
                        grepEntry.includes.add(PathCache.getString(string4));
                    }
                }
                ++string5;
            }
        }
        fileArray = new ArrayList();
        for (String string6 : grepEntry.includes) {
            file = new File(string + string6);
            try {
                if (!file.getCanonicalFile().getAbsolutePath().startsWith(string + string6)) continue;
                for (String string5 : this.grepSystemFolder((String)new StringBuilder().append((String)string).append((String)string6).toString()).includes) {
                    fileArray.add(string5);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        for (String string6 : fileArray) {
            if (grepEntry.includes.contains(string6)) continue;
            grepEntry.includes.add(PathCache.getString(string6));
        }
        this.grepBase.put(PathCache.getString(string), grepEntry);
        return grepEntry;
    }

    private BaseDwarfProvider.GrepEntry grepSourceFile(String string) {
        BaseDwarfProvider.GrepEntry grepEntry = this.grepBase.get(string);
        if (grepEntry != null) {
            return grepEntry;
        }
        grepEntry = new BaseDwarfProvider.GrepEntry();
        File file = new File(string);
        if (file.exists() && file.canRead() && !file.isDirectory()) {
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                block11: while ((string2 = bufferedReader.readLine()) != null) {
                    StringTokenizer stringTokenizer;
                    int n2;
                    int n3;
                    ++n;
                    int n4 = string2.length();
                    if (n4 == 0) continue;
                    block12: for (n3 = 0; n3 < n4; ++n3) {
                        switch (string2.charAt(n3)) {
                            case '\t': 
                            case ' ': {
                                continue block12;
                            }
                            case '#': {
                                break block12;
                            }
                            default: {
                                continue block11;
                            }
                        }
                    }
                    if (++n3 >= n4) continue;
                    block13: while (n3 < n4) {
                        switch (string2.charAt(n3)) {
                            case '\t': 
                            case ' ': {
                                break;
                            }
                            case 'i': {
                                if (n3 + 1 >= n4 || string2.charAt(n3 + 1) == 'n') break block13;
                                continue block11;
                            }
                            case 'd': {
                                break block13;
                            }
                            default: {
                                continue block11;
                            }
                        }
                        ++n3;
                    }
                    if (n3 >= n4) continue;
                    if ((string2 = string2.substring(n3)).startsWith("include")) {
                        int n5;
                        if ((string2 = string2.substring(7).trim()).length() <= 2) continue;
                        if (string2.startsWith("/*") && (n5 = string2.indexOf("*/")) > 0) {
                            string2 = string2.substring(n5 + 2).trim();
                        }
                        if ((n5 = (int)string2.charAt(0)) == 34) {
                            if (string2.indexOf(34, 1) <= 0) continue;
                            grepEntry.includes.add(PathCache.getString(string2.substring(1, string2.indexOf(34, 1))));
                            if (!FULL_TRACE) continue;
                            System.out.println("find in source:" + string2.substring(1, string2.indexOf(34, 1)));
                            continue;
                        }
                        if (n5 != 60 || string2.indexOf(62) <= 0) continue;
                        grepEntry.includes.add(PathCache.getString(string2.substring(1, string2.indexOf(62))));
                        if (!FULL_TRACE) continue;
                        System.out.println("find in source:" + string2.substring(1, string2.indexOf(62)));
                        continue;
                    }
                    if (!string2.startsWith("define") || grepEntry.firstMacroLine != -1 || (string2 = string2.substring(6).trim()).length() <= 0) continue;
                    if (string2.startsWith("/*") && (n2 = string2.indexOf("*/")) > 0) {
                        string2 = string2.substring(n2 + 2).trim();
                    }
                    if (!(stringTokenizer = new StringTokenizer(string2, "\t (")).hasMoreTokens()) continue;
                    grepEntry.firstMacroLine = n;
                    grepEntry.firstMacro = PathCache.getString(stringTokenizer.nextToken());
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (FULL_TRACE) {
            System.out.println("Cannot grep file:" + string);
        }
        this.grepBase.put(string, grepEntry);
        return grepEntry;
    }
}

