/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.text.Line;
import org.openide.util.WeakListeners;
import org.rubyforge.debugcommons.RubyDebuggerException;

public final class RubyBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(RubyBreakpointActionProvider.class.getName());
    private static final Set<Object> ACTIONS = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public RubyBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, false);
        PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorContextDispatcher.getDefault());
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-ruby", l);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("application/x-httpd-eruby", l);
    }

    public Set<Object> getActions() {
        return ACTIONS;
    }

    public void doAction(Object action) {
        RubyBreakpoint breakpoint = RubyBreakpointManager.getCurrentLineBreakpoint();
        if (breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)breakpoint);
        } else {
            try {
                Line line = EditorUtil.getCurrentLine();
                if (line != null) {
                    RubyBreakpointManager.addLineBreakpoint(line);
                }
            }
            catch (RubyDebuggerException e) {
                LOGGER.log(Level.WARNING, "Unable to add breakpoint: " + e.getLocalizedMessage(), e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = EditorUtil.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, enabled);
    }
}

