/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.support;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMHelper {
    private static final int TIME_TO_WAIT = 300;
    private static final String IDENT = "    ";
    private FileObject fobj;
    private Document document;

    public DOMHelper(FileObject fobj) {
        this.fobj = fobj;
        this.document = this.getDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument() {
        if (this.document == null) {
            DocumentBuilder builder = this.getDocumentBuilder();
            if (builder == null) {
                Logger.getLogger(DOMHelper.class.getName()).log(Level.INFO, "Cannot get XML parser for " + this.fobj);
                return null;
            }
            FileLock lock = null;
            InputStream is = null;
            try {
                lock = this.fobj.lock();
                is = this.fobj.getInputStream();
                this.document = builder.parse(is);
            }
            catch (SAXParseException ex) {
                Logger.getLogger(DOMHelper.class.getName()).log(Level.INFO, "Cannot parse " + this.fobj, ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(DOMHelper.class.getName()).log(Level.INFO, "Cannot parse " + this.fobj, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(DOMHelper.class.getName()).log(Level.INFO, "Cannot parse " + this.fobj, ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (lock != null) {
                    lock.releaseLock();
                }
            }
        }
        return this.document;
    }

    public Element findElement(String tag, String value) {
        if (this.document != null) {
            NodeList nodeList = this.document.getElementsByTagName(tag);
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                Element element = (Element)nodeList.item(i);
                if (!this.containsValue(element, value)) continue;
                return element;
            }
        }
        return null;
    }

    public Element findElement(String tag) {
        NodeList nodeList;
        if (this.document != null && (nodeList = this.document.getElementsByTagName(tag)).getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    public NodeList findElements(String tag) {
        if (this.document != null) {
            return this.document.getElementsByTagName(tag);
        }
        return null;
    }

    public Element findElementById(String id) {
        if (this.document != null) {
            return this.document.getElementById(id);
        }
        return null;
    }

    public void appendChild(Element child) {
        if (this.document != null) {
            this.document.getDocumentElement().appendChild(child);
        }
    }

    public Element createElement(String tag) {
        if (this.document != null) {
            return this.document.createElement(tag);
        }
        return null;
    }

    public Element createElement(String tag, String value) {
        if (this.document != null) {
            Element element = this.document.createElement(tag);
            Text text = this.document.createTextNode(value);
            element.appendChild(text);
            return element;
        }
        return null;
    }

    public boolean containsValue(Element element, String value) {
        Node child = element.getFirstChild();
        if (child instanceof Text) {
            return ((Text)child).getWholeText().equals(value);
        }
        return false;
    }

    public String getValue(Element element) {
        Node child = element.getFirstChild();
        if (child instanceof Text) {
            return ((Text)child).getWholeText();
        }
        return "";
    }

    public void setValue(Element element, String value) {
        Node child = element.getFirstChild();
        if (child instanceof Text) {
            ((Text)child).setData(value);
        }
    }

    public void save() {
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileLock lock = null;
                OutputStream os = null;
                try {
                    DocumentType docType = DOMHelper.this.document.getDoctype();
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer transformer = factory.newTransformer();
                    DOMSource source = new DOMSource(DOMHelper.this.document);
                    lock = DOMHelper.this.fobj.lock();
                    os = DOMHelper.this.fobj.getOutputStream(lock);
                    StreamResult result = new StreamResult(os);
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.transform(source, result);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    if (lock != null) {
                        lock.releaseLock();
                    }
                }
            }
        }, 300);
    }

    private DocumentBuilder getDocumentBuilder() {
        DocumentBuilder builder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setIgnoringComments(false);
        factory.setIgnoringElementContentWhitespace(false);
        factory.setCoalescing(false);
        factory.setExpandEntityReferences(false);
        factory.setValidating(false);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return builder;
    }
}

