/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.project.SourceGroup;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class BrowseFolders
extends JPanel
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private SourceGroup[] folders;
    private static JScrollPane SAMPLE_SCROLL_PANE = new JScrollPane();
    private JPanel folderPanel;
    private JLabel jLabel1;

    public BrowseFolders(SourceGroup[] sourceGroupArray) {
        this.initComponents();
        this.folders = sourceGroupArray;
        this.manager = new ExplorerManager();
        AbstractNode abstractNode = new AbstractNode((Children)new SourceGroupsChildren(sourceGroupArray));
        this.manager.setRootContext((Node)abstractNode);
        BeanTreeView beanTreeView = new BeanTreeView();
        beanTreeView.setRootVisible(false);
        beanTreeView.setSelectionMode(1);
        beanTreeView.setBorder(SAMPLE_SCROLL_PANE.getBorder());
        beanTreeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_SelectFile"));
        this.folderPanel.add((Component)beanTreeView, "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.folderPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        this.jLabel1.setText(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Folders"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.folderPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.folderPanel, gridBagConstraints);
    }

    public static FileObject showDialog(SourceGroup[] sourceGroupArray) {
        BrowseFolders browseFolders = new BrowseFolders(sourceGroupArray);
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_SelectFile")), new JButton(NbBundle.getMessage(BrowseFolders.class, (String)"LBL_Cancel"))};
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_SelectFile"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_Cancel"));
        OptionsListener optionsListener = new OptionsListener(browseFolders);
        objectArray[0].setActionCommand("SELECT");
        objectArray[0].addActionListener(optionsListener);
        objectArray[1].setActionCommand("CANCEL");
        objectArray[1].addActionListener(optionsListener);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)browseFolders, NbBundle.getMessage(BrowseFolders.class, (String)"LBL_BrowseFiles"), true, objectArray, (Object)objectArray[0], 0, null, null);
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowseFolders.class, (String)"ACSD_BrowseFoldersDialog"));
        dialog.setVisible(true);
        return optionsListener.getResult();
    }

    class SimpleFilterNode
    extends FilterNode {
        public SimpleFilterNode(Node node, Children children) {
            super(node, children);
        }

        public SystemAction[] getActions() {
            return new SystemAction[0];
        }

        public SystemAction getDefaultAction() {
            return null;
        }
    }

    private static final class OptionsListener
    implements ActionListener {
        public static final String COMMAND_SELECT = "SELECT";
        public static final String COMMAND_CANCEL = "CANCEL";
        private BrowseFolders browsePanel;
        private FileObject result;

        public OptionsListener(BrowseFolders browseFolders) {
            this.browsePanel = browseFolders;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray;
            String string = actionEvent.getActionCommand();
            if (COMMAND_SELECT.equals(string) && (nodeArray = this.browsePanel.getExplorerManager().getSelectedNodes()) != null && nodeArray.length > 0) {
                DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                this.result = dataObject.getPrimaryFile();
            }
        }

        public FileObject getResult() {
            return this.result;
        }
    }

    private class FileObjectComparator
    implements Comparator {
        private FileObjectComparator() {
        }

        public int compare(Object object, Object object2) {
            FileObject fileObject = (FileObject)object;
            FileObject fileObject2 = (FileObject)object2;
            return fileObject.getName().compareTo(fileObject2.getName());
        }
    }

    private final class SourceGroupsChildren
    extends Children.Keys {
        private SourceGroup[] groups;
        private SourceGroup group;
        private FileObject fo;

        public SourceGroupsChildren(SourceGroup[] sourceGroupArray) {
            this.groups = sourceGroupArray;
        }

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup) {
            this.fo = fileObject;
            this.group = sourceGroup;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = null;
            boolean bl = false;
            if (object instanceof SourceGroup) {
                fileObject = ((SourceGroup)object).getRootFolder();
                sourceGroup = (SourceGroup)object;
            } else if (object instanceof Key) {
                fileObject = ((Key)object).folder;
                sourceGroup = ((Key)object).group;
                if (!fileObject.isFolder()) {
                    bl = true;
                }
            }
            try {
                SimpleFilterNode simpleFilterNode;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                SimpleFilterNode simpleFilterNode2 = simpleFilterNode = bl ? new SimpleFilterNode(dataObject.getNodeDelegate(), Children.LEAF) : new SimpleFilterNode(dataObject.getNodeDelegate(), (Children)new SourceGroupsChildren(fileObject, sourceGroup));
                if (object instanceof SourceGroup) {
                    simpleFilterNode.setDisplayName(sourceGroup.getDisplayName());
                }
                return new Node[]{simpleFilterNode};
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }

        private Collection getKeys() {
            int n;
            if (this.groups != null) {
                return Arrays.asList(this.groups);
            }
            FileObject[] fileObjectArray = this.fo.getChildren();
            Arrays.sort(fileObjectArray, new FileObjectComparator());
            ArrayList<Key> arrayList = new ArrayList<Key>(fileObjectArray.length);
            for (n = 0; n < fileObjectArray.length; ++n) {
                if (!this.group.contains(fileObjectArray[n]) || !fileObjectArray[n].isFolder()) continue;
                arrayList.add(new Key(fileObjectArray[n], this.group));
            }
            for (n = 0; n < fileObjectArray.length; ++n) {
                if (!this.group.contains(fileObjectArray[n]) || fileObjectArray[n].isFolder()) continue;
                arrayList.add(new Key(fileObjectArray[n], this.group));
            }
            return arrayList;
        }

        private class Key {
            private FileObject folder;
            private SourceGroup group;

            private Key(FileObject fileObject, SourceGroup sourceGroup) {
                this.folder = fileObject;
                this.group = sourceGroup;
            }
        }
    }
}

