/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;

public class SynchronousXYItemPainter
extends XYItemPainter.Abstract {
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Stroke lineStroke;
    protected final int type;
    protected final int maxValueOffset;

    public static SynchronousXYItemPainter absolutePainter(float lineWidth, Color lineColor, Color fillColor) {
        return new SynchronousXYItemPainter(lineWidth, lineColor, fillColor, 0, 0);
    }

    public static SynchronousXYItemPainter relativePainter(float lineWidth, Color lineColor, Color fillColor, int maxOffset) {
        return new SynchronousXYItemPainter(lineWidth, lineColor, fillColor, 1, maxOffset);
    }

    public SynchronousXYItemPainter(float lineWidth, Color lineColor, Color fillColor, int type, int maxValueOffset) {
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("No parameters defined");
        }
        this.lineWidth = (int)Math.ceil(lineWidth);
        this.lineColor = Utils.checkedColor(lineColor);
        this.fillColor = Utils.checkedColor(fillColor);
        this.lineStroke = new BasicStroke(lineWidth, 1, 1);
        this.type = type;
        this.maxValueOffset = maxValueOffset;
    }

    @Override
    public LongRect getItemBounds(ChartItem item) {
        XYItem xyItem = (XYItem)item;
        if (this.type == 0) {
            return this.getDataBounds(xyItem.getBounds());
        }
        LongRect itemBounds1 = new LongRect(xyItem.getBounds());
        itemBounds1.y = 0L;
        itemBounds1.height = 0L;
        return itemBounds1;
    }

    @Override
    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        XYItem xyItem = (XYItem)item;
        if (this.type == 0) {
            return this.getViewBounds(xyItem.getBounds(), context);
        }
        return this.getViewBoundsRelative(xyItem.getBounds(), xyItem, context);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        return !LongRect.equals(change.getOldValuesBounds(), change.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange itemChange) {
        XYItemChange change = (XYItemChange)itemChange;
        LongRect dirtyBounds = change.getDirtyValuesBounds();
        return dirtyBounds.width != 0L || dirtyBounds.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        XYItemChange change = (XYItemChange)itemChange;
        if (this.type == 0) {
            return this.getViewBounds(change.getDirtyValuesBounds(), context);
        }
        LongRect oldValuesBounds = change.getOldValuesBounds();
        LongRect newValuesBounds = change.getNewValuesBounds();
        if (oldValuesBounds.y != newValuesBounds.y || oldValuesBounds.height != newValuesBounds.height) {
            return this.getItemBounds(change.getItem(), context);
        }
        return this.getViewBoundsRelative(change.getDirtyValuesBounds(), change.getItem(), context);
    }

    @Override
    public double getItemView(double dataY, XYItem item, ChartContext context) {
        if (this.type == 0) {
            return super.getItemView(dataY, item, context);
        }
        double itemValueFactor = SynchronousXYItemPainter.getItemValueFactor(context, this.maxValueOffset, item.getBounds().height);
        return context.getViewY((double)context.getDataOffsetY() + itemValueFactor * dataY);
    }

    @Override
    public double getItemValue(double viewY, XYItem item, ChartContext context) {
        if (this.type == 0) {
            return super.getItemValue(viewY, item, context);
        }
        double itemValueFactor = SynchronousXYItemPainter.getItemValueFactor(context, this.maxValueOffset, item.getBounds().height);
        return context.getDataY(viewY) / itemValueFactor;
    }

    @Override
    public double getItemValueScale(XYItem item, ChartContext context) {
        if (this.type == 0) {
            return super.getItemValueScale(item, context);
        }
        long itemHeight = item.getBounds().height;
        if (itemHeight == 0L) {
            return 1.0;
        }
        double itemValueFactor = SynchronousXYItemPainter.getItemValueFactor(context, this.maxValueOffset, itemHeight);
        return itemValueFactor / context.getDataHeight(1.0);
    }

    @Override
    public boolean supportsHovering(ChartItem item) {
        return false;
    }

    @Override
    public boolean supportsSelecting(ChartItem item) {
        return false;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        throw new UnsupportedOperationException("getSelectionBounds() not supported");
    }

    @Override
    public ItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        return null;
    }

    @Override
    public void paintItem(ChartItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        this.paint((XYItem)item, highlighted, selected, g, dirtyArea, (SynchronousXYChartContext)context);
    }

    private LongRect getDataBounds(LongRect itemBounds) {
        LongRect bounds = new LongRect(itemBounds);
        if (this.fillColor != null) {
            bounds.height += bounds.y;
            bounds.y = 0L;
        }
        return bounds;
    }

    private LongRect getViewBounds(LongRect itemBounds, ChartContext context) {
        LongRect dataBounds = this.getDataBounds(itemBounds);
        LongRect viewBounds = context.getViewRect(dataBounds);
        LongRect.addBorder(viewBounds, this.lineWidth);
        return viewBounds;
    }

    private LongRect getViewBoundsRelative(LongRect dataBounds, XYItem item, ChartContext context) {
        long viewHeight;
        LongRect itemBounds = item.getBounds();
        double itemValueFactor = SynchronousXYItemPainter.getItemValueFactor(context, this.maxValueOffset, itemBounds.height);
        double value1 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y - itemBounds.y);
        double value2 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y + dataBounds.height - itemBounds.y);
        long viewX = (long)Math.ceil(context.getViewX(dataBounds.x));
        long viewWidth = (long)Math.ceil(context.getViewWidth(dataBounds.width));
        if (context.isRightBased()) {
            viewX -= viewWidth;
        }
        long viewY1 = (long)Math.ceil(context.getViewY(value1));
        long viewY2 = (long)Math.ceil(context.getViewY(value2));
        long l = viewHeight = context.isBottomBased() ? viewY1 - viewY2 : viewY2 - viewY1;
        if (!context.isBottomBased()) {
            viewY2 -= viewHeight;
        }
        LongRect viewBounds = new LongRect(viewX, viewY2, viewWidth, viewHeight);
        LongRect.addBorder(viewBounds, this.lineWidth);
        return viewBounds;
    }

    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        if (item.getValuesCount() < 2) {
            return;
        }
        if (context.getViewWidth() == 0L || context.getViewHeight() == 0L) {
            return;
        }
        int[][] points = SynchronousXYItemPainter.createPoints(item, dirtyArea, context, this.type, this.maxValueOffset);
        if (points == null) {
            return;
        }
        int[] xPoints = points[0];
        int[] yPoints = points[1];
        int npoints = xPoints.length;
        if (this.fillColor != null) {
            int zeroY = Utils.checkedInt(context.getViewY(context.getDataOffsetY()));
            zeroY = Math.max(Utils.checkedInt(context.getViewportOffsetY()), zeroY);
            zeroY = Math.min(Utils.checkedInt(context.getViewportOffsetY() + (long)context.getViewportHeight()), zeroY);
            Polygon polygon = new Polygon();
            polygon.xpoints = xPoints;
            polygon.ypoints = yPoints;
            polygon.npoints = npoints;
            polygon.xpoints[npoints - 2] = xPoints[npoints - 3];
            polygon.ypoints[npoints - 2] = zeroY;
            polygon.xpoints[npoints - 1] = xPoints[0];
            polygon.ypoints[npoints - 1] = zeroY;
            g.setPaint(this.fillColor);
            g.fill(polygon);
        }
        if (this.lineColor != null) {
            g.setPaint(this.lineColor);
            g.setStroke(this.lineStroke);
            g.drawPolyline(xPoints, yPoints, npoints - 2);
        }
    }

    private static int[][] createPoints(XYItem item, Rectangle dirtyArea, SynchronousXYChartContext context, int type, int maxValueOffset) {
        int itemsStep;
        int lastFirst;
        int lastIndex;
        int valuesCount = item.getValuesCount();
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        int firstFirst = visibleBounds[0][0];
        int firstIndex = firstFirst;
        if (firstIndex == -1) {
            firstIndex = visibleBounds[0][1];
        }
        if (firstIndex == -1) {
            return null;
        }
        if (firstFirst != -1 && firstIndex > 0) {
            --firstIndex;
        }
        if ((lastIndex = (lastFirst = visibleBounds[1][0])) == -1) {
            lastIndex = visibleBounds[1][1];
        }
        if (lastIndex == -1) {
            lastIndex = valuesCount - 1;
        }
        if (lastFirst != -1 && lastIndex < valuesCount - 1) {
            ++lastIndex;
        }
        if ((itemsStep = (int)Math.ceil((long)valuesCount / context.getViewWidth())) == 0) {
            itemsStep = 1;
        }
        int visibleCount = lastIndex - firstIndex + 1;
        if (itemsStep > 1) {
            int firstMod = firstIndex % itemsStep;
            int lastMod = lastIndex % itemsStep;
            lastIndex = lastIndex - lastMod + itemsStep;
            visibleCount = (lastIndex - (firstIndex -= firstMod)) / itemsStep + 1;
            lastIndex = Math.min(lastIndex, valuesCount - 1);
        }
        int[] xPoints = new int[visibleCount + 2];
        int[] yPoints = new int[visibleCount + 2];
        double itemValueFactor = type == 1 ? SynchronousXYItemPainter.getItemValueFactor(context, maxValueOffset, item.getBounds().height) : 0.0;
        for (int i = 0; i < visibleCount; ++i) {
            int dataIndex = i == visibleCount - 1 ? lastIndex : firstIndex + i * itemsStep;
            xPoints[i] = Utils.checkedInt(Math.ceil(context.getViewX(item.getXValue(dataIndex))));
            yPoints[i] = Utils.checkedInt(Math.ceil(SynchronousXYItemPainter.getYValue(item, dataIndex, type, context, itemValueFactor)));
        }
        return new int[][]{xPoints, yPoints};
    }

    private static double getYValue(XYItem item, int valueIndex, int type, ChartContext context, double itemValueFactor) {
        if (type == 0) {
            return context.getViewY(item.getYValue(valueIndex));
        }
        return context.getViewY((double)context.getDataOffsetY() + itemValueFactor * (double)(item.getYValue(valueIndex) - item.getBounds().y));
    }

    private static double getItemValueFactor(ChartContext context, double maxValueOffset, double itemHeight) {
        return ((double)context.getDataHeight() - context.getDataHeight(maxValueOffset)) / itemHeight;
    }
}

