/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.PaintersListener;

public interface PaintersModel {
    public ItemPainter getPainter(ChartItem var1);

    public void addPaintersListener(PaintersListener var1);

    public void removePaintersListener(PaintersListener var1);

    public static class Default
    extends Abstract {
        private final Map<ChartItem, ItemPainter> painters = new HashMap<ChartItem, ItemPainter>();

        public Default() {
        }

        public Default(ChartItem[] items, ItemPainter[] painters) {
            this();
            if (items == null) {
                throw new IllegalArgumentException("Items cannot be null");
            }
            if (painters == null) {
                throw new IllegalArgumentException("Painters cannot be null");
            }
            if (items.length != painters.length) {
                throw new IllegalArgumentException("Items don't match painters");
            }
            this.addPainters(items, painters);
        }

        public void addPainters(ChartItem[] addedItems, ItemPainter[] addedPainters) {
            for (int i = 0; i < addedItems.length; ++i) {
                this.painters.put(addedItems[i], addedPainters[i]);
            }
        }

        public void removePainters(ChartItem[] removedItems) {
            for (int i = 0; i < removedItems.length; ++i) {
                this.painters.remove(removedItems[i]);
            }
        }

        @Override
        public ItemPainter getPainter(ChartItem item) {
            return this.painters.get(item);
        }
    }

    public static abstract class Abstract
    implements PaintersModel {
        private List<PaintersListener> listeners;

        @Override
        public void addPaintersListener(PaintersListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<PaintersListener>();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removePaintersListener(PaintersListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }

        protected void firePaintersChanged() {
            if (this.listeners != null) {
                for (PaintersListener listener : this.listeners) {
                    listener.paintersChanged();
                }
            }
        }

        protected void firePaintersChanged(List<ItemPainter> changedPainters) {
            if (this.listeners != null) {
                for (PaintersListener listener : this.listeners) {
                    listener.paintersChanged(changedPainters);
                }
            }
        }
    }
}

