/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemsListener;

public interface ItemsModel {
    public int getItemsCount();

    public ChartItem getItem(int var1);

    public void addItemsListener(ItemsListener var1);

    public void removeItemsListener(ItemsListener var1);

    public static abstract class Abstract
    implements ItemsModel {
        private List<ItemsListener> listeners;

        @Override
        public void addItemsListener(ItemsListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ItemsListener>();
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @Override
        public void removeItemsListener(ItemsListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }

        protected void fireItemsAdded(List<ChartItem> addedItems) {
            if (this.listeners != null) {
                for (ItemsListener listener : this.listeners) {
                    listener.itemsAdded(addedItems);
                }
            }
        }

        protected void fireItemsRemoved(List<ChartItem> removedItems) {
            if (this.listeners != null) {
                for (ItemsListener listener : this.listeners) {
                    listener.itemsRemoved(removedItems);
                }
            }
        }

        protected void fireItemsChanged(List<ChartItemChange> itemChanges) {
            if (this.listeners != null) {
                for (ItemsListener listener : this.listeners) {
                    listener.itemsChanged(itemChanges);
                }
            }
        }
    }
}

