/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.jumpto.file.FileDescription;
import org.netbeans.modules.jumpto.file.FileProviderAccessor;
import org.netbeans.modules.jumpto.file.FileSearchOptions;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.netbeans.modules.jumpto.type.GoToTypeAction;
import org.netbeans.modules.jumpto.type.Models;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.jumpto.file.FileDescriptor;
import org.netbeans.spi.jumpto.file.FileProvider;
import org.netbeans.spi.jumpto.file.FileProviderFactory;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfoFactory;

public class FileSearchAction
extends AbstractAction
implements FileSearchPanel.ContentProvider {
    static final Logger LOGGER = Logger.getLogger(FileSearchAction.class.getName());
    private static ListModel EMPTY_LIST_MODEL = new DefaultListModel();
    private static final RequestProcessor rp = new RequestProcessor("FileSearchAction-RequestProcessor", 1);
    private Worker running;
    private RequestProcessor.Task task;
    private Dialog dialog;
    private JButton openBtn;
    private FileSearchPanel panel;
    private Dimension initialDimension;
    private Iterable<? extends FileProvider> providers;

    public FileSearchAction() {
        super(NbBundle.getMessage(FileSearchAction.class, (String)"CTL_FileSearchAction"));
        this.putValue("PopupMenuText", NbBundle.getBundle(FileSearchAction.class).getString("editor-popup-CTL_FileSearchAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return OpenProjects.getDefault().getOpenProjects().length > 0;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        FileDescriptor[] typeDescriptors = this.getSelectedFiles();
        if (typeDescriptors != null) {
            for (FileDescriptor td : typeDescriptors) {
                td.open();
            }
        }
    }

    @Override
    public ListCellRenderer getListCellRenderer(JList list) {
        return new Renderer(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListModel(FileSearchPanel panel, String text) {
        QuerySupport.Kind nameKind;
        if (this.openBtn != null) {
            this.openBtn.setEnabled(false);
        }
        if (this.running != null) {
            this.running.cancel();
            this.task.cancel();
            this.running = null;
        }
        if (text == null) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        boolean exact = text.endsWith(" ");
        if ((text = text.trim()).length() == 0) {
            panel.setModel(EMPTY_LIST_MODEL);
            return;
        }
        int wildcard = GoToTypeAction.containsWildCard(text);
        if (exact) {
            nameKind = QuerySupport.Kind.EXACT;
        } else if (wildcard != -1) {
            nameKind = panel.isCaseSensitive() ? QuerySupport.Kind.REGEXP : QuerySupport.Kind.CASE_INSENSITIVE_REGEXP;
            text = FileSearchAction.wildcards2regexp(text);
        } else {
            nameKind = GoToTypeAction.isAllUpper(text) && text.length() > 1 || GoToTypeAction.isCamelCase(text) ? QuerySupport.Kind.CAMEL_CASE : (panel.isCaseSensitive() ? QuerySupport.Kind.PREFIX : QuerySupport.Kind.CASE_INSENSITIVE_PREFIX);
        }
        FileSearchAction fileSearchAction = this;
        synchronized (fileSearchAction) {
            this.running = new Worker(text, nameKind, panel.getCurrentProject());
            this.task = rp.post((Runnable)this.running, 220);
            if (panel.time != -1L) {
                LOGGER.fine("Worker posted after " + (System.currentTimeMillis() - panel.time) + " ms.");
            }
        }
    }

    @Override
    public void closeDialog() {
        this.dialog.setVisible(false);
        this.cleanup();
    }

    @Override
    public boolean hasValidContent() {
        return this.openBtn != null && this.openBtn.isEnabled();
    }

    private FileDescriptor[] getSelectedFiles() {
        FileDescriptor[] result = null;
        this.panel = new FileSearchPanel(this, FileSearchAction.findCurrentProject());
        this.dialog = this.createDialog(this.panel);
        this.dialog.setVisible(true);
        result = this.panel.getSelectedFiles();
        return result;
    }

    private Dialog createDialog(FileSearchPanel panel) {
        this.openBtn = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.openBtn, (String)NbBundle.getMessage(FileSearchAction.class, (String)"CTL_Open"));
        this.openBtn.getAccessibleContext().setAccessibleDescription(this.openBtn.getText());
        this.openBtn.setEnabled(false);
        Object[] buttons = new Object[]{this.openBtn, DialogDescriptor.CANCEL_OPTION};
        String title = NbBundle.getMessage(FileSearchAction.class, (String)"MSG_FileSearchDlgTitle");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, title, true, buttons, (Object)this.openBtn, 0, HelpCtx.DEFAULT_HELP, (ActionListener)new DialogButtonListener(panel));
        dialogDescriptor.setClosingOptions(buttons);
        Dialog d = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        d.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FileSearchAction.class, (String)"AN_FileSearchDialog"));
        d.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FileSearchAction.class, (String)"AD_FileSearchDialog"));
        d.setPreferredSize(new Dimension(FileSearchOptions.getWidth(), FileSearchOptions.getHeight()));
        Rectangle r = Utilities.getUsableScreenBounds();
        int maxW = r.width * 9 / 10;
        int maxH = r.height * 9 / 10;
        Dimension dim = d.getPreferredSize();
        dim.width = Math.min(dim.width, maxW);
        dim.height = Math.min(dim.height, maxH);
        this.initialDimension = dim;
        d.setBounds(Utilities.findCenterBounds((Dimension)dim));
        d.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                FileSearchAction.this.cleanup();
            }
        });
        return d;
    }

    private static Project findCurrentProject() {
        Lookup lookup = Utilities.actionsGlobalContext();
        Iterator i$ = lookup.lookupAll(Project.class).iterator();
        if (i$.hasNext()) {
            Project p = (Project)i$.next();
            return p;
        }
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            Project p = FileOwnerQuery.getOwner((FileObject)fObj);
            if (p == null) continue;
            return p;
        }
        return OpenProjects.getDefault().getMainProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        if (this.dialog != null) {
            FileSearchAction fileSearchAction = this;
            synchronized (fileSearchAction) {
                this.providers = null;
            }
            int currentWidth = this.dialog.getWidth();
            int currentHeight = this.dialog.getHeight();
            if (this.initialDimension != null && (this.initialDimension.width != currentWidth || this.initialDimension.height != currentHeight)) {
                FileSearchOptions.setHeight(currentHeight);
                FileSearchOptions.setWidth(currentWidth);
            }
            this.initialDimension = null;
            this.dialog.dispose();
            this.dialog = null;
            FileSearchOptions.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<? extends FileProvider> getProviders() {
        FileSearchAction fileSearchAction = this;
        synchronized (fileSearchAction) {
            if (this.providers != null) {
                return this.providers;
            }
        }
        LinkedList<FileProvider> result = new LinkedList<FileProvider>();
        for (FileProviderFactory fpf : Lookup.getDefault().lookupAll(FileProviderFactory.class)) {
            result.add(fpf.createFileProvider());
        }
        FileSearchAction fileSearchAction2 = this;
        synchronized (fileSearchAction2) {
            if (this.providers == null) {
                this.providers = Collections.unmodifiableList(result);
            }
            return this.providers;
        }
    }

    private static String wildcards2regexp(String pattern) {
        return pattern.replace(".", "\\.").replace("*", ".*").replace('?', '.').concat(".*");
    }

    private Collection<FileObject> searchSources(FileObject root, Collection<FileObject> result, Collection<? extends FileObject> exclude, FileObjectFilter[] filters) {
        if (root.getChildren().length == 0 || exclude.contains(root) || !this.checkAgainstFilters(root, filters)) {
            return result;
        }
        result.add(root);
        Enumeration subFolders = root.getFolders(false);
        while (subFolders.hasMoreElements()) {
            this.searchSources((FileObject)subFolders.nextElement(), result, exclude, filters);
        }
        return result;
    }

    private boolean checkAgainstFilters(FileObject folder, FileObjectFilter[] filters) {
        assert (folder.isFolder());
        for (FileObjectFilter filter : filters) {
            if (filter.traverseFolder(folder) != 0) continue;
            return false;
        }
        return true;
    }

    public static class Renderer
    extends DefaultListCellRenderer
    implements ChangeListener {
        public static Icon WAIT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/jumpto/resources/wait.gif", (boolean)false);
        private RendererComponent rendererComponent;
        private JLabel jlName = new JLabel();
        private JLabel jlPath = new JLabel();
        private JLabel jlPrj = new JLabel();
        private int DARKER_COLOR_COMPONENT = 5;
        private int LIGHTER_COLOR_COMPONENT = 80;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgColorDarker;
        private Color bgSelectionColor;
        private Color fgSelectionColor;
        private Color bgColorGreener;
        private Color bgColorDarkerGreener;
        private JList jList;
        private boolean colorPrefered;

        public Renderer(JList list) {
            this.jList = list;
            Container container = list.getParent();
            if (container instanceof JViewport) {
                ((JViewport)container).addChangeListener(this);
                this.stateChanged(new ChangeEvent(container));
            }
            this.rendererComponent = new RendererComponent();
            this.rendererComponent.setLayout(new BorderLayout());
            this.rendererComponent.add((Component)this.jlName, "West");
            this.rendererComponent.add((Component)this.jlPath, "Center");
            this.rendererComponent.add((Component)this.jlPrj, "East");
            this.jlName.setOpaque(false);
            this.jlPath.setOpaque(false);
            this.jlPrj.setOpaque(false);
            this.jlName.setFont(list.getFont());
            this.jlPath.setFont(list.getFont());
            this.jlPrj.setFont(list.getFont());
            this.jlPrj.setHorizontalAlignment(4);
            this.jlPrj.setHorizontalTextPosition(2);
            this.fgColor = list.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getGreen() + this.LIGHTER_COLOR_COMPONENT), Math.min(255, this.fgColor.getBlue() + this.LIGHTER_COLOR_COMPONENT));
            this.bgColor = list.getBackground();
            this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getGreen() - this.DARKER_COLOR_COMPONENT), Math.abs(this.bgColor.getBlue() - this.DARKER_COLOR_COMPONENT));
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
            this.bgColorGreener = new Color(Math.abs(this.bgColor.getRed() - 20), Math.min(255, this.bgColor.getGreen() + 10), Math.abs(this.bgColor.getBlue() - 20));
            this.bgColorDarkerGreener = new Color(Math.abs(this.bgColorDarker.getRed() - 35), Math.min(255, this.bgColorDarker.getGreen() + 5), Math.abs(this.bgColorDarker.getBlue() - 35));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            int height = list.getFixedCellHeight();
            int width = list.getFixedCellWidth() - 1;
            width = width < 200 ? 200 : width;
            Dimension size = new Dimension(width, height);
            this.rendererComponent.setMaximumSize(size);
            this.rendererComponent.setPreferredSize(size);
            if (isSelected) {
                this.jlName.setForeground(this.fgSelectionColor);
                this.jlPath.setForeground(this.fgSelectionColor);
                this.jlPrj.setForeground(this.fgSelectionColor);
                this.rendererComponent.setBackground(this.bgSelectionColor);
            } else {
                this.jlName.setForeground(this.fgColor);
                this.jlPath.setForeground(this.fgColorLighter);
                this.jlPrj.setForeground(this.fgColor);
                this.rendererComponent.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
            }
            if (value instanceof FileDescriptor) {
                FileDescriptor fd = (FileDescriptor)value;
                this.jlName.setIcon(fd.getIcon());
                this.jlName.setText(fd.getFileName());
                this.jlPath.setIcon(null);
                this.jlPath.setHorizontalAlignment(2);
                this.jlPath.setText(fd.getOwnerPath().length() > 0 ? " (" + fd.getOwnerPath() + ")" : " ()");
                this.jlPrj.setText(fd.getProjectName());
                this.jlPrj.setIcon(fd.getProjectIcon());
                if (!isSelected) {
                    this.rendererComponent.setBackground(index % 2 == 0 ? (FileProviderAccessor.getInstance().isFromCurrentProject(fd) && this.colorPrefered ? this.bgColorGreener : this.bgColor) : (FileProviderAccessor.getInstance().isFromCurrentProject(fd) && this.colorPrefered ? this.bgColorDarkerGreener : this.bgColorDarker));
                }
                this.rendererComponent.setDescription(fd);
            } else {
                this.jlName.setText("");
                this.jlName.setIcon(null);
                this.jlPath.setIcon(WAIT_ICON);
                this.jlPath.setHorizontalAlignment(0);
                this.jlPath.setText(value.toString());
                this.jlPrj.setIcon(null);
                this.jlPrj.setText("");
            }
            return this.rendererComponent;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            JViewport jv = (JViewport)event.getSource();
            this.jlName.setText("Sample");
            this.jlName.setIcon(new ImageIcon());
            this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
            this.jList.setFixedCellWidth(jv.getExtentSize().width);
        }

        public void setColorPrefered(boolean colorPrefered) {
            this.colorPrefered = colorPrefered;
        }
    }

    private static class RendererComponent
    extends JPanel {
        private FileDescriptor fd;

        private RendererComponent() {
        }

        void setDescription(FileDescriptor fd) {
            this.fd = fd;
            this.putClientProperty("ToolTipText", null);
        }

        @Override
        public String getToolTipText() {
            String text = (String)this.getClientProperty("ToolTipText");
            if (text == null) {
                if (this.fd != null) {
                    text = FileUtil.getFileDisplayName((FileObject)this.fd.getFileObject());
                }
                this.putClientProperty("ToolTipText", text);
            }
            return text;
        }
    }

    public static class FDComarator
    implements Comparator<FileDescriptor> {
        private boolean usePrefered;
        private boolean caseSensitive;

        public FDComarator(boolean usePrefered, boolean caseSensitive) {
            this.usePrefered = usePrefered;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public int compare(FileDescriptor o1, FileDescriptor o2) {
            int cmpr;
            if (this.usePrefered) {
                if (FileProviderAccessor.getInstance().isFromCurrentProject(o1) && !FileProviderAccessor.getInstance().isFromCurrentProject(o2)) {
                    return -1;
                }
                if (!FileProviderAccessor.getInstance().isFromCurrentProject(o1) && FileProviderAccessor.getInstance().isFromCurrentProject(o2)) {
                    return 1;
                }
            }
            if ((cmpr = this.compareStrings(o1.getFileName(), o2.getFileName(), this.caseSensitive)) != 0) {
                return cmpr;
            }
            cmpr = this.compareStrings(o1.getProjectName(), o2.getProjectName(), this.caseSensitive);
            if (cmpr != 0) {
                return cmpr;
            }
            cmpr = this.compareStrings(o1.getOwnerPath(), o2.getOwnerPath(), this.caseSensitive);
            return cmpr;
        }

        private int compareStrings(String s1, String s2, boolean caseSensitive) {
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return caseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        }
    }

    private class DialogButtonListener
    implements ActionListener {
        private FileSearchPanel panel;

        public DialogButtonListener(FileSearchPanel panel) {
            this.panel = panel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FileSearchAction.this.openBtn) {
                this.panel.setSelectedFile();
            }
        }
    }

    private class Worker
    implements Runnable {
        private volatile boolean isCanceled = false;
        private volatile FileProvider currentProvider;
        private final String text;
        private final QuerySupport.Kind searchType;
        private final Project currentProject;
        private final long createTime;

        public Worker(String text, QuerySupport.Kind searchType, Project currentProject) {
            this.text = text;
            this.searchType = searchType;
            this.currentProject = currentProject;
            this.createTime = System.currentTimeMillis();
            LOGGER.fine("Worker for " + text + ", " + searchType + " - created after " + (System.currentTimeMillis() - ((FileSearchAction)FileSearchAction.this).panel.time) + " ms.");
        }

        @Override
        public void run() {
            LOGGER.fine("Worker for " + this.text + " - started " + (System.currentTimeMillis() - this.createTime) + " ms.");
            final List<? extends FileDescriptor> files = this.getFileNames(this.text);
            if (this.isCanceled) {
                LOGGER.fine("Worker for " + this.text + " exited after cancel " + (System.currentTimeMillis() - this.createTime) + " ms.");
                return;
            }
            final ListModel model = Models.fromList(files);
            if (!this.isCanceled && model != null) {
                LOGGER.fine("Worker for text " + this.text + " finished after " + (System.currentTimeMillis() - this.createTime) + " ms.");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FileSearchAction.this.panel.setModel(model);
                        if (FileSearchAction.this.openBtn != null && !files.isEmpty()) {
                            FileSearchAction.this.openBtn.setEnabled(true);
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            FileProvider provider;
            if (((FileSearchAction)FileSearchAction.this).panel.time != -1L) {
                LOGGER.fine("Worker for text " + this.text + " canceled after " + (System.currentTimeMillis() - this.createTime) + " ms.");
            }
            Worker worker = this;
            synchronized (worker) {
                this.isCanceled = true;
                provider = this.currentProvider;
            }
            if (provider != null) {
                provider.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<? extends FileDescriptor> getFileNames(String text) {
            String searchField;
            switch (this.searchType) {
                case CASE_INSENSITIVE_PREFIX: 
                case CASE_INSENSITIVE_REGEXP: {
                    searchField = "ci-file-name";
                    break;
                }
                default: {
                    searchField = "file-name";
                }
            }
            ArrayList roots = new ArrayList(QuerySupport.findRoots((Project)null, null, Collections.emptyList(), Collections.emptyList()));
            try {
                QuerySupport q = QuerySupport.forRoots((String)"org-netbeans-modules-jumpto-file-FileIndexer", (int)1, (FileObject[])roots.toArray(new FileObject[roots.size()]));
                Collection results = q.query(searchField, text, this.searchType, new String[0]);
                ArrayList<FileDescription> files = new ArrayList<FileDescription>();
                for (IndexResult r : results) {
                    FileObject file = r.getFile();
                    if (file == null || !file.isValid()) continue;
                    Project project = FileOwnerQuery.getOwner((FileObject)file);
                    boolean preferred = project != null && this.currentProject != null ? project.getProjectDirectory() == this.currentProject.getProjectDirectory() : false;
                    FileDescription fd = new FileDescription(file, r.getRelativePath().substring(0, Math.max(r.getRelativePath().length() - file.getNameExt().length() - 1, 0)), project);
                    FileProviderAccessor.getInstance().setFromCurrentProject(fd, preferred);
                    files.add(fd);
                    LOGGER.finer("Found: " + file.getPath() + ", project=" + project + ", currentProject=" + this.currentProject + ", preferred=" + preferred);
                }
                if (this.isCanceled) {
                    return files;
                }
                HashSet<FileObject> excludes = new HashSet<FileObject>(roots);
                Project[] projects = OpenProjects.getDefault().getOpenProjects();
                LinkedList<FileObject> sgRoots = new LinkedList<FileObject>();
                for (Project p : projects) {
                    for (SourceGroup group : ProjectUtils.getSources((Project)p).getSourceGroups("generic")) {
                        sgRoots.add(group.getRootFolder());
                    }
                }
                SearchType jumpToSearchType = this.toJumpToSearchType(this.searchType);
                FileProvider.Context ctx = FileProviderAccessor.getInstance().createContext(text, jumpToSearchType, this.currentProject);
                FileProvider.Result fpR = FileProviderAccessor.getInstance().createResult(files, new String[1], ctx);
                Iterator i$ = FileSearchAction.this.getProviders().iterator();
                while (i$.hasNext()) {
                    FileProvider provider;
                    this.currentProvider = provider = (FileProvider)i$.next();
                    try {
                        for (FileObject root : sgRoots) {
                            if (excludes.contains(root)) continue;
                            FileProviderAccessor.getInstance().setRoot(ctx, root);
                            boolean recognized = provider.computeFiles(ctx, fpR);
                            if (!recognized) continue;
                            excludes.add(root);
                        }
                    }
                    finally {
                        this.currentProvider = null;
                        if (!this.isCanceled) continue;
                        return files;
                    }
                }
                Collection allFolders = new ArrayList();
                FileObjectFilter[] filters = new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER};
                for (FileObject root : sgRoots) {
                    allFolders = FileSearchAction.this.searchSources(root, allFolders, excludes, filters);
                }
                NameMatcher matcher = NameMatcherFactory.createNameMatcher(text, jumpToSearchType);
                for (FileObject folder : allFolders) {
                    assert (folder.isFolder());
                    Enumeration filesInFolder = folder.getData(false);
                    while (filesInFolder.hasMoreElements()) {
                        FileObject file = (FileObject)filesInFolder.nextElement();
                        if (file.isFolder() || !matcher.accept(file.getNameExt())) continue;
                        Project project = FileOwnerQuery.getOwner((FileObject)file);
                        boolean preferred = project != null && this.currentProject != null ? project.getProjectDirectory() == this.currentProject.getProjectDirectory() : false;
                        String relativePath = FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)file);
                        if (relativePath == null) {
                            relativePath = "";
                        }
                        FileDescription fd = new FileDescription(file, relativePath, project);
                        FileProviderAccessor.getInstance().setFromCurrentProject(fd, preferred);
                        files.add(fd);
                    }
                }
                Collections.sort(files, new FDComarator(FileSearchAction.this.panel.isPreferedProject(), FileSearchAction.this.panel.isCaseSensitive()));
                return files;
            }
            catch (PatternSyntaxException pse) {
                return Collections.emptyList();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
                return Collections.emptyList();
            }
        }

        private SearchType toJumpToSearchType(QuerySupport.Kind searchType) {
            switch (searchType) {
                case CAMEL_CASE: 
                case CASE_INSENSITIVE_CAMEL_CASE: {
                    return SearchType.CAMEL_CASE;
                }
                case CASE_INSENSITIVE_PREFIX: {
                    return SearchType.CASE_INSENSITIVE_PREFIX;
                }
                case CASE_INSENSITIVE_REGEXP: {
                    return SearchType.CASE_INSENSITIVE_REGEXP;
                }
                case EXACT: {
                    return SearchType.EXACT_NAME;
                }
                case PREFIX: {
                    return SearchType.PREFIX;
                }
                case REGEXP: {
                    return SearchType.REGEXP;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

