/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.packets;

import java.util.Collection;
import java.util.LinkedList;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.packets.ContextGetCommand;
import org.netbeans.modules.php.dbgp.packets.ContextNamesCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpCommand;
import org.netbeans.modules.php.dbgp.packets.DbgpResponse;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContextNamesResponse
extends DbgpResponse {
    static final String CONTEXT = "context";
    private static final String NAME = "name";
    private static final String ID = "id";

    ContextNamesResponse(Node node) {
        super(node);
    }

    Collection<Context> getContexts() {
        LinkedList<Context> result = new LinkedList<Context>();
        NodeList list = this.getNode().getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!CONTEXT.equals(node.getNodeName())) continue;
            String name = ContextNamesResponse.getAttribute(node, NAME);
            String idString = ContextNamesResponse.getAttribute(node, ID);
            try {
                int id = Integer.parseInt(idString);
                result.add(new Context(name, id));
                continue;
            }
            catch (NumberFormatException e) {
                assert (false);
                continue;
            }
        }
        return result;
    }

    @Override
    public void process(DebugSession session, DbgpCommand command) {
        if (!(command instanceof ContextNamesCommand)) {
            return;
        }
        ContextNamesCommand namesCommand = (ContextNamesCommand)command;
        int depth = namesCommand.getDepth();
        for (Context context : this.getContexts()) {
            ContextGetCommand getCommand = new ContextGetCommand(session.getTransactionId());
            getCommand.setContext(context);
            if (depth != -1) {
                getCommand.setDepth(depth);
            }
            session.sendCommandLater(getCommand);
        }
    }

    public static class Context {
        private String myContext;
        private int myId;

        private Context(String contextName, int id) {
            this.myContext = contextName;
            this.myId = id;
        }

        public String getContext() {
            return this.myContext;
        }

        public int getId() {
            return this.myId;
        }
    }
}

