/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.source.ElementHandleAccessor;
import org.netbeans.modules.java.source.JavaSourceTaskFactoryManager;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.JavaFileFilterListener;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.indexing.MultiPassCompileWorker;
import org.netbeans.modules.java.source.indexing.OnePassCompileWorker;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.tasklist.TasklistSettings;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.Pair;
import org.netbeans.modules.java.source.usages.VirtualSourceProviderQuery;
import org.netbeans.modules.parsing.api.indexing.IndexingManager;
import org.netbeans.modules.parsing.impl.indexing.FileObjectIndexable;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.netbeans.modules.parsing.impl.indexing.SPIAccessor;
import org.netbeans.modules.parsing.impl.indexing.friendapi.IndexingController;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class JavaCustomIndexer
extends CustomIndexer {
    private static final String SOURCE_LEVEL_ROOT = "sourceLevel";
    private static final String DIRTY_ROOT = "dirty";
    private static final Pattern ANONYMOUS = Pattern.compile("\\$[0-9]");
    private static final ClassPath EMPTY = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static final CompileWorker[] WORKERS = new CompileWorker[]{new OnePassCompileWorker(), new MultiPassCompileWorker()};
    static final ErrorsCache.Convertor<Diagnostic<?>> ERROR_CONVERTOR = new ErrorsCache.Convertor<Diagnostic<?>>(){

        public ErrorsCache.ErrorKind getKind(Diagnostic<?> t) {
            return t.getKind() == Diagnostic.Kind.ERROR ? ErrorsCache.ErrorKind.ERROR : ErrorsCache.ErrorKind.WARNING;
        }

        public int getLineNumber(Diagnostic<?> t) {
            return (int)t.getLineNumber();
        }

        public String getMessage(Diagnostic<?> t) {
            return t.getMessage(null);
        }
    };

    protected void index(Iterable<? extends Indexable> files, final Context context) {
        JavaIndex.LOG.log(Level.FINE, context.isSupplementaryFilesIndexing() ? "index suplementary({0})" : "index({0})", context.isAllFilesIndexing() ? context.getRootURI() : files);
        try {
            FileObject root = context.getRoot();
            if (root == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)root);
            if (JavaIndex.ensureAttributeValue(context.getRootURI(), SOURCE_LEVEL_ROOT, sourceLevel) && !context.isAllFilesIndexing()) {
                JavaIndex.LOG.fine("forcing reindex due to source level change");
                IndexingManager.getDefault().refreshIndex(context.getRootURI(), null);
                return;
            }
            if (JavaIndex.ensureAttributeValue(context.getRootURI(), DIRTY_ROOT, null) && !context.isAllFilesIndexing()) {
                JavaIndex.LOG.fine("forcing reindex due to dirty root");
                IndexingManager.getDefault().refreshIndex(context.getRootURI(), null);
                return;
            }
            APTUtils.sourceRootRegistered(context.getRoot(), context.getRootURI());
            APTUtils aptUtils = APTUtils.get(root);
            if (aptUtils != null && aptUtils.verifyAttributes(root, context.isAllFilesIndexing())) {
                return;
            }
            final ClassPath sourcePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/source");
            final ClassPath bootPath = ClassPath.getClassPath((FileObject)root, (String)"classpath/boot");
            final ClassPath compilePath = ClassPath.getClassPath((FileObject)root, (String)"classpath/compile");
            if (sourcePath == null || bootPath == null || compilePath == null) {
                JavaIndex.LOG.warning("Ignoring root with no ClassPath: " + FileUtil.getFileDisplayName((FileObject)root));
                return;
            }
            if (!Arrays.asList(sourcePath.getRoots()).contains(root)) {
                JavaIndex.LOG.warning("Source root: " + FileUtil.getFileDisplayName((FileObject)root) + " is not on its sourcepath");
                return;
            }
            if (!JavaFileFilterListener.getDefault().startListeningOn(root)) {
                JavaIndex.LOG.fine("Forcing reindex dou to changed JavaFileFilter");
                return;
            }
            final ArrayList javaSources = new ArrayList();
            final Collection<? extends CompileTuple> virtualSourceTuples = JavaCustomIndexer.translateVirtualSources(JavaCustomIndexer.splitSources(files, javaSources), context.getRootURI());
            ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void run() throws IOException, InterruptedException {
                    try {
                        JavaIndex.setAttribute(context.getRootURI(), JavaCustomIndexer.DIRTY_ROOT, Boolean.TRUE.toString());
                        boolean finished = false;
                        JavaParsingContext javaContext = new JavaParsingContext(context, bootPath, compilePath, sourcePath, virtualSourceTuples);
                        HashSet removedTypes = new HashSet();
                        HashSet<File> removedFiles = new HashSet<File>();
                        ArrayList<CompileTuple> toCompile = new ArrayList<CompileTuple>(javaSources.size() + virtualSourceTuples.size());
                        CompileWorker.ParsingOutput compileResult = null;
                        try {
                            if (context.isAllFilesIndexing()) {
                                JavaCustomIndexer.cleanUpResources(context.getRootURI());
                            }
                            if (javaContext.uq == null) {
                                Void void_ = null;
                                return void_;
                            }
                            javaContext.uq.setDirty(null);
                            for (Indexable i : javaSources) {
                                CompileTuple tuple = JavaCustomIndexer.createTuple(context, javaContext, i);
                                if (tuple != null) {
                                    toCompile.add(tuple);
                                }
                                JavaCustomIndexer.clear(context, javaContext, i.getRelativePath(), removedTypes, removedFiles);
                            }
                            for (CompileTuple tuple : virtualSourceTuples) {
                                JavaCustomIndexer.clear(context, javaContext, tuple.indexable.getRelativePath(), removedTypes, removedFiles);
                            }
                            toCompile.addAll(virtualSourceTuples);
                            ArrayList<CompileTuple> toCompileRound = toCompile;
                            int round = 0;
                            while (round++ < 2) {
                                for (CompileWorker w : WORKERS) {
                                    if ((compileResult = w.compile(compileResult, context, javaContext, toCompileRound)) == null || context.isCancelled()) {
                                        Void void_ = null;
                                        return void_;
                                    }
                                    if (compileResult.success) break;
                                }
                                if (compileResult.aptGenerated.isEmpty()) {
                                    ++round;
                                    continue;
                                }
                                toCompileRound = new ArrayList(compileResult.aptGenerated.size());
                                for (CompileTuple ct : compileResult.aptGenerated) {
                                    toCompileRound.add(ct);
                                    toCompile.add(ct);
                                }
                                compileResult.aptGenerated.clear();
                            }
                            finished = true;
                        }
                        finally {
                            if (finished) {
                                JavaIndex.setAttribute(context.getRootURI(), JavaCustomIndexer.DIRTY_ROOT, null);
                            }
                        }
                        assert (compileResult != null);
                        HashSet<ElementHandle<TypeElement>> _at = new HashSet<ElementHandle<TypeElement>>(compileResult.addedTypes);
                        HashSet _rt = new HashSet(removedTypes);
                        _at.removeAll(removedTypes);
                        _rt.removeAll(compileResult.addedTypes);
                        compileResult.addedTypes.retainAll(removedTypes);
                        if (!context.isSupplementaryFilesIndexing() && !context.isCancelled()) {
                            compileResult.modifiedTypes.addAll(_rt);
                            Map root2Rebuild = JavaCustomIndexer.findDependent(context.getRootURI(), compileResult.modifiedTypes, !_at.isEmpty());
                            Set urls = (Set)root2Rebuild.get(context.getRootURI());
                            if (urls != null) {
                                if (context.isAllFilesIndexing()) {
                                    root2Rebuild.remove(context.getRootURI());
                                } else {
                                    for (CompileTuple ct : toCompile) {
                                        urls.remove(ct.indexable.getURL());
                                    }
                                    if (urls.isEmpty()) {
                                        root2Rebuild.remove(context.getRootURI());
                                    }
                                }
                            }
                            for (Map.Entry entry : root2Rebuild.entrySet()) {
                                context.addSupplementaryFiles((URL)entry.getKey(), (Collection)entry.getValue());
                            }
                        }
                        javaContext.checkSums.store();
                        javaContext.sa.store();
                        javaContext.uq.typesEvent(_at, _rt, compileResult.addedTypes);
                        if (!context.checkForEditorModifications()) {
                            BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), removedFiles, compileResult.createdFiles, false);
                        }
                        return null;
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw new IOException(ex);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static List<? extends Indexable> splitSources(Iterable<? extends Indexable> indexables, List<? super Indexable> javaSources) {
        LinkedList<Indexable> virtualSources = new LinkedList<Indexable>();
        for (Indexable indexable : indexables) {
            if (indexable.getURL() == null) continue;
            if (VirtualSourceProviderQuery.hasVirtualSource(indexable)) {
                virtualSources.add(indexable);
                continue;
            }
            javaSources.add((Indexable)indexable);
        }
        return virtualSources;
    }

    private static Collection<? extends CompileTuple> translateVirtualSources(Collection<? extends Indexable> virtualSources, URL rootURL) throws IOException {
        if (virtualSources.isEmpty()) {
            return Collections.emptySet();
        }
        try {
            File root = new File(URI.create(rootURL.toString()));
            return VirtualSourceProviderQuery.translate(virtualSources, root);
        }
        catch (IllegalArgumentException e) {
            JavaIndex.LOG.warning("Virtual sources in the root: " + rootURL + " are ignored due to: " + e.getMessage());
            return Collections.emptySet();
        }
    }

    private static CompileTuple createTuple(Context context, JavaParsingContext javaContext, Indexable indexable) {
        FileObject fo;
        File root = null;
        if (!context.checkForEditorModifications() && "file".equals(indexable.getURL().getProtocol()) && (root = FileUtil.toFile((FileObject)context.getRoot())) != null) {
            try {
                File file = new File(indexable.getURL().toURI().getPath());
                return new CompileTuple(FileObjects.fileFileObject(file, root, javaContext.filter, javaContext.encoding), indexable);
            }
            catch (Exception ex) {
            }
            catch (AssertionError ae) {
                throw (AssertionError)((Object)Exceptions.attachMessage((Throwable)((Object)ae), (String)("Root FileObject: " + FileUtil.getFileDisplayName((FileObject)context.getRoot()) + " Indexable URL: " + indexable.getURL() + " Normalized root: " + FileUtil.normalizeFile((File)root).getAbsolutePath())));
            }
        }
        return (fo = URLMapper.findFileObject((URL)indexable.getURL())) != null ? new CompileTuple(SourceFileObject.create(fo, context.getRoot()), indexable) : null;
    }

    private static void clearFiles(final Context context, final Iterable<? extends Indexable> files) {
        try {
            if (context.getRoot() == null) {
                JavaIndex.LOG.fine("Ignoring request with no root");
                return;
            }
            ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                @Override
                public Void run() throws IOException, InterruptedException {
                    try {
                        JavaParsingContext javaContext = new JavaParsingContext(context);
                        if (javaContext.uq == null) {
                            return null;
                        }
                        HashSet removedTypes = new HashSet();
                        HashSet<File> removedFiles = new HashSet<File>();
                        for (Indexable indexable : files) {
                            JavaCustomIndexer.clear(context, javaContext, indexable.getRelativePath(), removedTypes, removedFiles);
                            ErrorsCache.setErrors((URL)context.getRootURI(), (Indexable)indexable, Collections.emptyList(), ERROR_CONVERTOR);
                            javaContext.checkSums.remove(indexable.getURL());
                        }
                        for (Map.Entry entry : JavaCustomIndexer.findDependent(context.getRootURI(), removedTypes, false).entrySet()) {
                            context.addSupplementaryFiles((URL)entry.getKey(), (Collection)entry.getValue());
                        }
                        javaContext.checkSums.store();
                        javaContext.sa.store();
                        BuildArtifactMapperImpl.classCacheUpdated(context.getRootURI(), JavaIndex.getClassFolder(context.getRootURI()), removedFiles, Collections.<File>emptySet(), false);
                        javaContext.uq.typesEvent(null, removedTypes, null);
                        return null;
                    }
                    catch (NoSuchAlgorithmException ex) {
                        throw (IOException)new IOException().initCause(ex);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void clear(Context context, JavaParsingContext javaContext, String sourceRelative, Set<ElementHandle<TypeElement>> removedTypes, Set<File> removedFiles) throws IOException {
        File file;
        ArrayList<Pair<String, String>> toDelete = new ArrayList<Pair<String, String>>();
        File classFolder = JavaIndex.getClassFolder(context);
        File aptFolder = JavaIndex.getAptFolder(context.getRootURI(), false);
        LinkedList<String> sourceRelatives = new LinkedList<String>();
        sourceRelatives.add(sourceRelative);
        if (aptFolder.exists() && (file = new File(classFolder, FileObjects.stripExtension(sourceRelative) + '.' + "rapt")).exists()) {
            try {
                for (String string : JavaCustomIndexer.readRSFile(file)) {
                    File f = new File(aptFolder, string);
                    if (f.exists() && "java".equals(FileObjects.getExtension(f.getName()))) {
                        sourceRelatives.add(string);
                    }
                    f.delete();
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            file.delete();
        }
        for (String string : sourceRelatives) {
            boolean cont;
            String ext = FileObjects.getExtension(string);
            String withoutExt = FileObjects.stripExtension(string);
            boolean dieIfNoRefFile = VirtualSourceProviderQuery.hasVirtualSource(ext);
            file = dieIfNoRefFile ? new File(classFolder, string + '.' + "rx") : new File(classFolder, withoutExt + '.' + "rs");
            boolean bl = cont = !dieIfNoRefFile;
            if (file.exists()) {
                cont = false;
                try {
                    String binaryName = FileObjects.getBinaryName(file, classFolder);
                    for (String className : JavaCustomIndexer.readRSFile(file)) {
                        File f = new File(classFolder, FileObjects.convertPackage2Folder(className) + '.' + "sig");
                        if (!binaryName.equals(className)) {
                            toDelete.add(Pair.of(className, string));
                            removedTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                            removedFiles.add(f);
                            f.delete();
                            continue;
                        }
                        cont = !dieIfNoRefFile;
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                file.delete();
            }
            if (!cont || !(file = new File(classFolder, withoutExt + '.' + "sig")).exists()) continue;
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            final String[] patterns = new String[]{fileName + '.', fileName + '$'};
            File parent = file.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    for (int i = 0; i < patterns.length; ++i) {
                        if (!name.startsWith(patterns[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File f : parent.listFiles(filter)) {
                String className = FileObjects.getBinaryName(f, classFolder);
                toDelete.add(Pair.of(className, null));
                removedTypes.add(ElementHandleAccessor.INSTANCE.create(ElementKind.OTHER, className));
                removedFiles.add(f);
                f.delete();
            }
        }
        for (Pair pair : toDelete) {
            javaContext.sa.delete(pair);
        }
    }

    private static void markDirtyFiles(Context context, Iterable<? extends Indexable> files) {
        ClassIndexImpl indexImpl = ClassIndexManager.getDefault().getUsagesQuery(context.getRootURI());
        if (indexImpl != null) {
            for (Indexable indexable : files) {
                indexImpl.setDirty(indexable.getURL());
            }
        }
    }

    public static void verifySourceLevel(@NonNull FileObject root, @NonNull FileObject file, @NonNull String sourceLevel) throws IOException {
        URL rootURL = root.getURL();
        if (!sourceLevel.equals(JavaIndex.getAttribute(rootURL, SOURCE_LEVEL_ROOT, sourceLevel))) {
            String rootSourceLevel = SourceLevelQuery.getSourceLevel((FileObject)root);
            if (!sourceLevel.equals(rootSourceLevel)) {
                JavaIndex.LOG.log(Level.WARNING, "Source level for file and for its root differ (file={0}, root={1})", new Object[]{sourceLevel, rootSourceLevel});
                return;
            }
            JavaIndex.LOG.fine("forcing reindex due to source level change");
            IndexingManager.getDefault().refreshIndex(rootURL, null);
        }
    }

    public static Collection<? extends ElementHandle<TypeElement>> getRelatedTypes(File source, File root) throws IOException {
        boolean cont;
        LinkedList<ElementHandle> result = new LinkedList<ElementHandle>();
        File classFolder = JavaIndex.getClassFolder(root);
        String path = FileObjects.getRelativePath(root, source);
        String ext = FileObjects.getExtension(path);
        String pathNoExt = FileObjects.stripExtension(path);
        boolean dieIfNoRefFile = VirtualSourceProviderQuery.hasVirtualSource(ext);
        File file = dieIfNoRefFile ? new File(classFolder, path + '.' + "rx") : new File(classFolder, pathNoExt + '.' + "rs");
        boolean bl = cont = !dieIfNoRefFile;
        if (file.exists()) {
            cont = false;
            try {
                String binaryName = FileObjects.getBinaryName(file, classFolder);
                for (String className : JavaCustomIndexer.readRSFile(file)) {
                    if (!binaryName.equals(className)) {
                        result.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, className));
                        continue;
                    }
                    cont = !dieIfNoRefFile;
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        if (cont && (file = new File(classFolder, pathNoExt + '.' + "sig")).exists()) {
            String fileName = file.getName();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            final String[] patterns = new String[]{fileName + '.', fileName + '$'};
            File parent = file.getParentFile();
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    if (!name.endsWith("sig")) {
                        return false;
                    }
                    for (int i = 0; i < patterns.length; ++i) {
                        if (!name.startsWith(patterns[i])) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (File f : parent.listFiles(filter)) {
                String className = FileObjects.getBinaryName(f, classFolder);
                result.add(ElementHandleAccessor.INSTANCE.create(ElementKind.CLASS, className));
            }
        }
        return result;
    }

    static void addAptGenerated(Context context, JavaParsingContext javaContext, String sourceRelative, Set<CompileTuple> aptGenerated) throws IOException {
        File aptFolder = JavaIndex.getAptFolder(context.getRootURI(), false);
        if (aptFolder.exists()) {
            FileObject root = FileUtil.toFileObject((File)aptFolder);
            File classFolder = JavaIndex.getClassFolder(context.getRootURI());
            String withoutExt = FileObjects.stripExtension(sourceRelative);
            SPIAccessor accessor = SPIAccessor.getInstance();
            File file = new File(classFolder, withoutExt + '.' + "rapt");
            if (file.exists()) {
                try {
                    for (String fileName : JavaCustomIndexer.readRSFile(file)) {
                        File f = new File(aptFolder, fileName);
                        if (!f.exists() || !"java".equals(FileObjects.getExtension(f.getName()))) continue;
                        Indexable i = accessor.create((IndexableImpl)new FileObjectIndexable(root, fileName));
                        InferableJavaFileObject ffo = FileObjects.fileFileObject(f, aptFolder, null, javaContext.encoding);
                        aptGenerated.add(new CompileTuple(ffo, i));
                    }
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readRSFile(File file) throws IOException {
        LinkedList<String> binaryNames = new LinkedList<String>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String binaryName;
            while ((binaryName = in.readLine()) != null) {
                binaryNames.add(binaryName);
            }
        }
        finally {
            in.close();
        }
        return binaryNames;
    }

    private static Map<URL, Set<URL>> findDependent(URL root, Collection<ElementHandle<TypeElement>> classes, boolean includeFilesInError) throws IOException {
        Map deps = IndexingController.getDefault().getRootDependencies();
        HashMap<URL, List<URL>> inverseDeps = new HashMap<URL, List<URL>>();
        for (Map.Entry entry : deps.entrySet()) {
            URL u1 = (URL)entry.getKey();
            List l1 = (List)entry.getValue();
            for (URL u2 : l1) {
                ArrayList<URL> l2 = (ArrayList<URL>)inverseDeps.get(u2);
                if (l2 == null) {
                    l2 = new ArrayList<URL>();
                    inverseDeps.put(u2, l2);
                }
                l2.add(u1);
            }
        }
        return JavaCustomIndexer.findDependent(root, deps, inverseDeps, classes, includeFilesInError, true);
    }

    public static Map<URL, Set<URL>> findDependent(URL root, Map<URL, List<URL>> sourceDeps, Map<URL, List<URL>> inverseDeps, Collection<ElementHandle<TypeElement>> classes, boolean includeFilesInError, boolean includeCurrentSourceRoot) throws IOException {
        LinkedHashMap<URL, Set<URL>> ret = new LinkedHashMap<URL, Set<URL>>();
        Iterator<ElementHandle<TypeElement>> i = classes.iterator();
        while (i.hasNext()) {
            if (!ANONYMOUS.matcher(i.next().getBinaryName()).find()) continue;
            i.remove();
        }
        if (classes.isEmpty() && !includeFilesInError) {
            return ret;
        }
        List depRoots = inverseDeps.get(root);
        try {
            switch (TasklistSettings.getDependencyTracking()) {
                case DISABLED: {
                    if (depRoots == null) {
                        JavaIndex.setAttribute(root, DIRTY_ROOT, Boolean.TRUE.toString());
                    } else {
                        for (URL url : depRoots) {
                            JavaIndex.setAttribute(url, DIRTY_ROOT, Boolean.TRUE.toString());
                        }
                    }
                    return ret;
                }
                case ENABLED_WITHIN_ROOT: {
                    if (depRoots == null) {
                        depRoots = Collections.singletonList(root);
                        break;
                    }
                    for (URL url : depRoots) {
                        JavaIndex.setAttribute(url, DIRTY_ROOT, Boolean.TRUE.toString());
                    }
                    break;
                }
                case ENABLED_WITHIN_PROJECT: {
                    if (depRoots == null) {
                        depRoots = Collections.singletonList(root);
                        break;
                    }
                    Project rootPrj = FileOwnerQuery.getOwner((URI)root.toURI());
                    if (rootPrj == null) {
                        for (URL url : depRoots) {
                            JavaIndex.setAttribute(url, DIRTY_ROOT, Boolean.TRUE.toString());
                        }
                        depRoots = Collections.singletonList(root);
                        break;
                    }
                    ArrayList<URL> l = new ArrayList<URL>(depRoots.size());
                    for (URL url : depRoots) {
                        if (FileOwnerQuery.getOwner((URI)url.toURI()) == rootPrj) {
                            l.add(url);
                            continue;
                        }
                        JavaIndex.setAttribute(url, DIRTY_ROOT, Boolean.TRUE.toString());
                    }
                    l.add(root);
                    depRoots = Utilities.topologicalSort(l, inverseDeps);
                    break;
                }
                case ENABLED: {
                    if (depRoots == null) {
                        depRoots = Collections.singletonList(root);
                        break;
                    }
                    ArrayList<URL> l = new ArrayList<URL>(depRoots);
                    l.add(root);
                    depRoots = Utilities.topologicalSort(l, inverseDeps);
                }
            }
        }
        catch (TopologicalSortException ex) {
            JavaIndex.LOG.warning("Cycle in the source root dependencies detected: " + ex.unsortableSets());
            List part = ex.partialSort();
            part.retainAll(depRoots);
            depRoots = part;
        }
        catch (URISyntaxException urise) {
            depRoots = Collections.singletonList(root);
        }
        LinkedList<ElementHandle<TypeElement>> queue = new LinkedList<ElementHandle<TypeElement>>(classes);
        HashMap bases = new HashMap();
        for (URL depRoot : depRoots) {
            Collection errUrls;
            List<URL> dep;
            if (ClassIndexManager.getDefault().createUsagesQuery(depRoot, true).isEmpty()) continue;
            ClassIndex index = ClasspathInfo.create(EMPTY, EMPTY, ClassPathSupport.createClassPath((URL[])new URL[]{depRoot})).getClassIndex();
            List<URL> list = dep = sourceDeps != null ? sourceDeps.get(depRoot) : null;
            if (dep != null) {
                for (URL url : dep) {
                    Set b = (Set)bases.get(url);
                    if (b == null) continue;
                    queue.addAll(b);
                }
            }
            HashSet<ElementHandle> toHandle = new HashSet<ElementHandle>();
            while (!queue.isEmpty()) {
                ElementHandle e = (ElementHandle)queue.poll();
                if (!toHandle.add(e)) continue;
                queue.addAll(index.getElements(e, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            bases.put(depRoot, toHandle);
            if (!includeCurrentSourceRoot && depRoot.equals(root)) continue;
            HashSet<FileObject> files = new HashSet<FileObject>();
            for (ElementHandle e : toHandle) {
                files.addAll(index.getResources(e, EnumSet.complementOf(EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS)), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
            }
            HashSet<URL> urls = new HashSet<URL>();
            for (FileObject file : files) {
                urls.add(file.getURL());
            }
            if (includeFilesInError && !(errUrls = ErrorsCache.getAllFilesInError((URL)depRoot)).isEmpty()) {
                urls.addAll(errUrls);
            }
            if (urls.isEmpty()) continue;
            ret.put(depRoot, urls);
        }
        return ret;
    }

    private static void cleanUpResources(URL rootURL) throws IOException {
        File classFolder = JavaIndex.getClassFolder(rootURL);
        File resourcesFile = new File(classFolder, "resouces.res");
        try {
            for (String fileName : JavaCustomIndexer.readRSFile(resourcesFile)) {
                File f = new File(classFolder, fileName);
                f.delete();
            }
            resourcesFile.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static final class CompileTuple {
        public final InferableJavaFileObject jfo;
        public final Indexable indexable;
        public final boolean virtual;
        public final boolean index;

        public CompileTuple(InferableJavaFileObject jfo, Indexable indexable, boolean virtual, boolean index) {
            this.jfo = jfo;
            this.indexable = indexable;
            this.virtual = virtual;
            this.index = index;
        }

        public CompileTuple(InferableJavaFileObject jfo, Indexable indexable) {
            this(jfo, indexable, false, true);
        }
    }

    public static class Factory
    extends CustomIndexerFactory {
        private static AtomicBoolean javaTaskFactoriesInitialized = new AtomicBoolean(false);

        public Factory() {
            if (!javaTaskFactoriesInitialized.getAndSet(true)) {
                JavaSourceTaskFactoryManager.register();
            }
        }

        public boolean scanStarted(final Context context) {
            try {
                return ClassIndexManager.getDefault().prepareWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                    @Override
                    public Boolean run() throws IOException, InterruptedException {
                        return ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Boolean run() throws IOException, InterruptedException {
                                ClassIndexImpl uq = ClassIndexManager.getDefault().createUsagesQuery(context.getRootURI(), true);
                                if (uq == null) {
                                    return true;
                                }
                                if (uq.getState() != ClassIndexImpl.State.NEW) {
                                    return true;
                                }
                                try {
                                    Boolean bl = uq.getSourceAnalyser().isValid();
                                    return bl;
                                }
                                finally {
                                    uq.setState(ClassIndexImpl.State.INITIALIZED);
                                }
                            }
                        });
                    }
                });
            }
            catch (IOException ioe) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), ioe);
                return false;
            }
            catch (InterruptedException ie) {
                JavaIndex.LOG.log(Level.WARNING, "Exception while checking cache validity for root: " + context.getRootURI(), ie);
                return false;
            }
        }

        public void scanFinished(Context context) {
        }

        public CustomIndexer createIndexer() {
            return new JavaCustomIndexer();
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDeleted({0})", deleted);
            JavaCustomIndexer.clearFiles(context, deleted);
        }

        public void rootsRemoved(final Iterable<? extends URL> removedRoots) {
            assert (removedRoots != null);
            JavaIndex.LOG.log(Level.FINE, "roots removed: {0}", removedRoots);
            APTUtils.sourceRootUnregistered(removedRoots);
            final ClassIndexManager cim = ClassIndexManager.getDefault();
            final JavaFileFilterListener ffl = JavaFileFilterListener.getDefault();
            try {
                cim.prepareWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException, InterruptedException {
                        for (URL removedRoot : removedRoots) {
                            cim.removeRoot(removedRoot);
                            ffl.stopListeningOn(removedRoot);
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            catch (InterruptedException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            JavaIndex.LOG.log(Level.FINE, "filesDirty({0})", dirty);
            JavaCustomIndexer.markDirtyFiles(context, dirty);
        }

        public String getIndexerName() {
            return "java";
        }

        public boolean supportsEmbeddedIndexers() {
            return true;
        }

        public int getIndexVersion() {
            return 14;
        }
    }
}

