/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codeviation.commons.patterns.Filter;
import org.codeviation.commons.reflect.ClassUtils;
import org.codeviation.commons.reflect.FieldUtils;
import org.codeviation.pojson.Pojson;

public class StoreInfo {
    private Class<?> clazz;
    private Kind kind;
    private Map<String, Field> fields;
    private Map<Field, String> names;
    private String namePrefix;

    public StoreInfo(Class<?> clazz) {
        this.clazz = clazz;
        Pojson.NamePrefix np = clazz.getAnnotation(Pojson.NamePrefix.class);
        this.namePrefix = np == null ? null : np.value();
    }

    public synchronized Kind getKind() {
        if (this.kind == null) {
            this.kind = StoreInfo.isJsonValueType(this.clazz) ? Kind.VALUE : (this.clazz.isArray() || ClassUtils.isSuperinterface(this.clazz, Iterable.class) ? Kind.ARRAY : Kind.OBJECT);
        }
        return this.kind;
    }

    public boolean isSkipNullValues(Field field) {
        if (this.clazz.isAnnotationPresent(Pojson.SkipNullValues.class)) {
            return true;
        }
        return field.isAnnotationPresent(Pojson.SkipNullValues.class);
    }

    public synchronized String getPojsonFieldName(Field f) {
        String name;
        if (this.names == null) {
            this.names = new HashMap<Field, String>();
        }
        if ((name = this.names.get(f)) != null) {
            return name;
        }
        Pojson.Name na = f.getAnnotation(Pojson.Name.class);
        if (na == null) {
            name = f.getName();
        } else {
            name = na.value();
            String string = name = name == null ? f.getName() : name;
        }
        if (this.namePrefix != null) {
            name = this.namePrefix + name;
        }
        this.names.put(f, name);
        return name;
    }

    public synchronized Collection<Field> getFields() {
        if (this.fields == null) {
            Class<?> stopClass;
            Pojson.StopAt saa = this.clazz.getAnnotation(Pojson.StopAt.class);
            if (saa == null) {
                stopClass = this.clazz;
            } else {
                stopClass = saa.value();
                if (saa.value() == Pojson.StopAtCurrentClass.class) {
                    stopClass = this.clazz;
                }
            }
            this.fields = FieldUtils.getAll(this.clazz, stopClass, new FieldFilter());
        }
        return this.fields.values();
    }

    private static boolean isJsonValueType(Class type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isEnum()) {
            return true;
        }
        if (Boolean.class.equals((Object)type) || Byte.class.equals((Object)type) || Short.class.equals((Object)type) || Character.class.equals((Object)type) || Integer.class.equals((Object)type) || Long.class.equals((Object)type) || Float.class.equals((Object)type) || Double.class.equals((Object)type) || Void.class.equals((Object)type) || String.class.equals((Object)type)) {
            return true;
        }
        return Date.class.equals((Object)type) || ClassUtils.isSuperclass(type, Date.class);
    }

    private class FieldFilter
    implements Filter<Field> {
        private int[] positive;
        private int[] negative;

        public FieldFilter() {
            Pojson.ModifierNegative mn;
            Pojson.ModifierPositive mp = StoreInfo.this.clazz.getAnnotation(Pojson.ModifierPositive.class);
            if (mp != null) {
                this.positive = mp.value();
                if (this.positive.length == 0) {
                    this.positive = null;
                }
            }
            if ((mn = StoreInfo.this.clazz.getAnnotation(Pojson.ModifierNegative.class)) != null) {
                this.negative = mp.value();
                if (this.negative.length == 0) {
                    this.negative = null;
                }
            }
        }

        @Override
        public boolean accept(Field field) {
            if (field.isAnnotationPresent(Pojson.SuppressStoring.class)) {
                return false;
            }
            int m = field.getModifiers();
            if (this.positive != null) {
                for (int p : this.positive) {
                    if ((m & p) != 0) continue;
                    return false;
                }
            }
            if (this.negative != null) {
                for (int p : this.negative) {
                    if ((m & p) == 0) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static enum Kind {
        VALUE,
        OBJECT,
        ARRAY;

    }
}

