/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.openide.util.Exceptions;

public class Call {
    public static final Call LOCAL = new Call(null, null, false, false, 0);
    public static final Call NONE = new Call(null, null, false, false, 0);
    public static final Call UNKNOWN = new Call(null, null, false, false, 0);
    private final String type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;
    private int prevCallParenPos = -1;
    private int beginOffset;

    public Call(String type, String lhs, boolean isStatic, boolean methodExpected, int beginOffset) {
        this.type = type;
        this.lhs = lhs;
        this.methodExpected = methodExpected;
        if (lhs == null) {
            lhs = type;
        }
        this.isStatic = isStatic;
        this.beginOffset = beginOffset;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public String getType() {
        return this.type;
    }

    public String getLhs() {
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int getPrevCallParenPos() {
        return this.prevCallParenPos;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(" + this.type + "," + this.lhs + "," + this.isStatic + "," + this.prevCallParenPos + ")";
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    @NonNull
    public static Call getCallType(BaseDocument doc, TokenHierarchy<Document> th, int offset) {
        Token token;
        TokenSequence<? extends JsTokenId> ts = LexUtilities.getJsTokenSequence(th, offset);
        if (ts == null) {
            return NONE;
        }
        ts.move(offset);
        boolean methodExpected = false;
        if (!ts.moveNext() && !ts.movePrevious()) {
            return NONE;
        }
        if (ts.offset() == offset) {
            ts.movePrevious();
        }
        if ((token = ts.token()) != null) {
            int lastSeparatorOffset;
            JsTokenId id = (JsTokenId)token.id();
            if (id == JsTokenId.WHITESPACE) {
                return LOCAL;
            }
            if (id == JsTokenId.IDENTIFIER || id.primaryCategory().equals("keyword")) {
                String tokenText = ((Object)token.text()).toString();
                if (".".equals(tokenText)) {
                    methodExpected = true;
                } else if (!"::".equals(tokenText)) {
                    methodExpected = true;
                    if (Character.isUpperCase(tokenText.charAt(0))) {
                        methodExpected = false;
                    }
                    if (!ts.movePrevious()) {
                        return LOCAL;
                    }
                }
                token = ts.token();
                id = (JsTokenId)token.id();
            }
            if (id == JsTokenId.DOT) {
                methodExpected = true;
            } else if (id == JsTokenId.IDENTIFIER) {
                String t = ((Object)token.text()).toString();
                if (t.equals(".")) {
                    methodExpected = true;
                } else if (!t.equals("::")) {
                    return LOCAL;
                }
            } else {
                return LOCAL;
            }
            int beginOffset = lastSeparatorOffset = ts.offset();
            int lineStart = 0;
            try {
                if (offset > doc.getLength()) {
                    offset = doc.getLength();
                }
                lineStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            block16: while (ts.movePrevious() && ts.offset() >= lineStart) {
                token = ts.token();
                id = (JsTokenId)token.id();
                String tokenText = null;
                if (id == JsTokenId.ANY_KEYWORD) {
                    tokenText = ((Object)token.text()).toString();
                }
                switch (id) {
                    case WHITESPACE: {
                        break block16;
                    }
                    case STRING_LITERAL: 
                    case STRING_END: {
                        return new Call("String", null, false, methodExpected, beginOffset);
                    }
                    case REGEXP_LITERAL: 
                    case REGEXP_END: {
                        return new Call("RegExp", null, false, methodExpected, beginOffset);
                    }
                    case FLOAT_LITERAL: {
                        return new Call("Number", null, false, methodExpected, beginOffset);
                    }
                    case LPAREN: 
                    case LBRACE: 
                    case LBRACKET: {
                        break block16;
                    }
                    case RPAREN: {
                        Call call = new Call(null, null, false, false, beginOffset);
                        call.prevCallParenPos = ts.offset();
                        OffsetRange matching = LexUtilities.findBwd((Document)doc, ts, JsTokenId.LPAREN, JsTokenId.RPAREN);
                        if (matching != OffsetRange.NONE) {
                            call.prevCallParenPos = matching.getStart();
                        }
                        return call;
                    }
                    case RBRACKET: {
                        Call call = new Call(null, null, false, false, beginOffset);
                        call.prevCallParenPos = ts.offset();
                        OffsetRange matching = LexUtilities.findBwd((Document)doc, ts, JsTokenId.LBRACKET, JsTokenId.LBRACKET);
                        if (matching != OffsetRange.NONE) {
                            call.prevCallParenPos = matching.getStart();
                        }
                        return call;
                    }
                    case NONUNARY_OP: 
                    case ANY_OPERATOR: {
                        break block16;
                    }
                    case IDENTIFIER: 
                    case DOT: 
                    case THIS: {
                        beginOffset = ts.offset();
                        continue block16;
                    }
                    case ANY_KEYWORD: {
                        if ("true".equals(tokenText)) {
                            return new Call("Boolean", null, false, methodExpected, beginOffset);
                        }
                        if ("false".equals(tokenText)) {
                            return new Call("Boolean", null, false, methodExpected, beginOffset);
                        }
                    }
                    default: {
                        if (id.primaryCategory().equals("keyword")) {
                            beginOffset = ts.offset();
                            continue block16;
                        }
                        return UNKNOWN;
                    }
                }
            }
            if (beginOffset < lastSeparatorOffset) {
                try {
                    String lhs = doc.getText(beginOffset, lastSeparatorOffset - beginOffset);
                    if (lhs.equals("super") || lhs.equals("this")) {
                        return new Call(lhs, lhs, false, true, beginOffset);
                    }
                    if (Character.isUpperCase(lhs.charAt(0))) {
                        String type = null;
                        boolean valid = true;
                        String[] classParts = lhs.split("\\.");
                        for (int i = 0; i < classParts.length; ++i) {
                            String c = classParts[i];
                            if (JsUtils.isValidJsClassName(c)) continue;
                            if (i == classParts.length - 1 && "prototype".equals(c)) {
                                type = lhs.substring(0, lhs.length() - ".prototype".length());
                                continue;
                            }
                            valid = false;
                        }
                        if (valid && type == null) {
                            type = lhs;
                        }
                        return new Call(type, lhs, true, methodExpected, beginOffset);
                    }
                    return new Call(null, lhs, false, methodExpected, beginOffset);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                }
            } else {
                return UNKNOWN;
            }
        }
        return LOCAL;
    }

    public static String getCallExpression(BaseDocument doc, int offset) throws BadLocationException {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        Call call = Call.getCallType(doc, (TokenHierarchy<Document>)th, offset);
        if (call.getLhs() != null) {
            int end = Utilities.getWordEnd((BaseDocument)doc, (int)offset);
            int begin = call.getBeginOffset();
            return doc.getText(begin, end - begin);
        }
        return Utilities.getIdentifier((BaseDocument)doc, (int)offset);
    }
}

