/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.anno.JavaMethodDescriptor;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.nb.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.SafePropertyAccessor;

public abstract class MethodFactory {
    public static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
    private static final boolean reflection;
    private static final boolean dumping;
    private static final String dumpingPath;

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath, classLoader);
        }
        return new InvocationMethodFactory(classLoader);
    }

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getCompiledMethodLazily(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, List<JavaMethodDescriptor> var2);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, JavaMethodDescriptor var2);

    @Deprecated
    public abstract void defineIndexedAnnotatedMethods(RubyModule var1, Class var2, MethodDefiningCallback var3);

    static {
        boolean reflection_ = false;
        boolean dumping_ = false;
        String dumpingPath_ = null;
        if (Ruby.isSecurityRestricted()) {
            reflection_ = true;
        } else {
            if (SafePropertyAccessor.getProperty("jruby.reflection") != null && SafePropertyAccessor.getBoolean("jruby.reflection")) {
                reflection_ = true;
            }
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping_ = true;
                dumpingPath_ = SafePropertyAccessor.getProperty("jruby.dump_invocations");
            }
        }
        reflection = reflection_;
        dumping = dumping_;
        dumpingPath = dumpingPath_;
    }

    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, JavaMethodDescriptor var2, DynamicMethod var3);
    }
}

