/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.management.MethodCache;
import org.jruby.nb.util.collections.WeakHashSet;

public class CacheMap {
    private final AtomicInteger addCount = new AtomicInteger(0);
    private final AtomicInteger removeCount = new AtomicInteger(0);
    private final AtomicInteger moduleIncludeCount = new AtomicInteger(0);
    private final AtomicInteger moduleTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushTriggeredRemoveCount = new AtomicInteger(0);
    private final AtomicInteger flushCount = new AtomicInteger(0);
    private final Map<DynamicMethod, Set<CacheSite>> mappings = new WeakHashMap<DynamicMethod, Set<CacheSite>>();

    public CacheMap(Ruby ruby) {
        ruby.getBeanManager().register(new MethodCache(this));
    }

    public int getAddCount() {
        return this.addCount.get();
    }

    public int getRemoveCount() {
        return this.removeCount.get();
    }

    public int getModuleIncludeCount() {
        return this.moduleIncludeCount.get();
    }

    public int getModuleTriggeredRemoveCount() {
        return this.moduleTriggeredRemoveCount.get();
    }

    public int getFlushCount() {
        return this.flushCount.get();
    }

    public synchronized void flush() {
        int totalRemoved = 0;
        for (DynamicMethod method : this.mappings.keySet()) {
            Set<CacheSite> cacheSites = this.mappings.get(method);
            if (cacheSites == null) continue;
            for (CacheSite site : cacheSites) {
                ++totalRemoved;
                site.removeCachedMethod();
            }
        }
        this.mappings.clear();
        this.flushTriggeredRemoveCount.addAndGet(totalRemoved);
        this.removeCount.addAndGet(totalRemoved);
        this.flushCount.incrementAndGet();
    }

    public synchronized void add(DynamicMethod method, CacheSite site) {
        Set<CacheSite> siteList = this.mappings.get(method);
        if (siteList == null) {
            siteList = new WeakHashSet<CacheSite>();
            this.mappings.put(method, siteList);
        }
        siteList.add(site);
        this.addCount.incrementAndGet();
    }

    public synchronized void remove(DynamicMethod method) {
        Set<CacheSite> siteList = this.mappings.remove(method);
        if (siteList == null) {
            return;
        }
        for (CacheSite site : siteList) {
            if (site == null) continue;
            site.removeCachedMethod();
        }
        this.removeCount.incrementAndGet();
    }

    public synchronized void moduleIncluded(RubyModule targetModule, RubyModule includedModule) {
        int totalRemoved = 0;
        for (String methodName : includedModule.getMethods().keySet()) {
            for (RubyModule current = targetModule; current != null; current = current.getSuperClass()) {
                Set<CacheSite> adapters;
                DynamicMethod method;
                if (current == includedModule || (method = current.getMethods().get(methodName)) == null || (adapters = this.mappings.remove(method)) == null) continue;
                for (CacheSite adapter : adapters) {
                    ++totalRemoved;
                    adapter.removeCachedMethod();
                }
            }
        }
        this.moduleTriggeredRemoveCount.addAndGet(totalRemoved);
        this.removeCount.addAndGet(totalRemoved);
        this.moduleIncludeCount.incrementAndGet();
    }

    public static interface CacheSite {
        public void removeCachedMethod();
    }
}

