/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.libraries;

import java.io.IOException;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyDigest;
import org.jruby.nb.runtime.load.Library;

public class DigestLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap) throws IOException {
        RubyDigest.createDigest(runtime);
    }

    public static class SHA2
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyDigest.createDigestSHA2(runtime);
        }
    }

    public static class SHA1
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyDigest.createDigestSHA1(runtime);
        }
    }

    public static class RMD160
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyDigest.createDigestRMD160(runtime);
        }
    }

    public static class MD5
    implements Library {
        @Override
        public void load(Ruby runtime, boolean wrap) throws IOException {
            RubyDigest.createDigestMD5(runtime);
        }
    }
}

