/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaAccessibleObject;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaField"})
public class JavaField
extends JavaAccessibleObject {
    private Field field;

    public Object getValue() {
        return this.field;
    }

    public static RubyClass createJavaFieldClass(Ruby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaField", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        result.defineAnnotatedMethods(JavaField.class);
        return result;
    }

    public JavaField(Ruby runtime, Field field) {
        super(runtime, runtime.getJavaSupport().getJavaFieldClass());
        this.field = field;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaField && this.field == ((JavaField)other).field;
    }

    @Override
    public int hashCode() {
        return this.field.hashCode();
    }

    @JRubyMethod
    public RubyString value_type() {
        return this.getRuntime().newString(this.field.getType().getName());
    }

    @Override
    @JRubyMethod(name={"==", "==="})
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaField)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.field.equals(((JavaField)other).field));
    }

    @JRubyMethod(name={"public?"})
    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"static?"})
    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    @JRubyMethod(name={"enum_constant?"})
    public RubyBoolean enum_constant_p() {
        return this.getRuntime().newBoolean(this.field.isEnumConstant());
    }

    @JRubyMethod
    public RubyString to_generic_string() {
        return this.getRuntime().newString(this.field.toGenericString());
    }

    @JRubyMethod(name={"type"})
    public IRubyObject field_type() {
        return JavaClass.get(this.getRuntime(), this.field.getType());
    }

    @JRubyMethod
    public IRubyObject value(IRubyObject object) {
        Object javaObject = JavaUtil.unwrapJavaValue(this.getRuntime(), object, "not a java object");
        try {
            return JavaUtil.convertJavaToUsableRubyObject(this.getRuntime(), this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
    }

    @JRubyMethod
    public IRubyObject set_value(IRubyObject object, IRubyObject value) {
        Object javaObject = JavaUtil.unwrapJavaValue(this.getRuntime(), object, "not a java object: " + object);
        IRubyObject val = value;
        if (val.dataGetStruct() instanceof JavaObject) {
            val = (IRubyObject)val.dataGetStruct();
        }
        try {
            Object convertedValue = JavaUtil.convertArgumentToType(val.getRuntime().getCurrentContext(), val, this.field.getType());
            this.field.set(javaObject, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + val.getClass().getName());
        }
        return val;
    }

    @JRubyMethod(name={"final?"})
    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    @JRubyMethod
    public JavaObject static_value() {
        try {
            if (!Ruby.isSecurityRestricted()) {
                this.field.setAccessible(true);
            }
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal static value access: " + iae.getMessage());
        }
    }

    @JRubyMethod
    public JavaObject set_static_value(IRubyObject value) {
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        try {
            Object convertedValue = JavaUtil.convertArgument(this.getRuntime(), ((JavaObject)value).getValue(), this.field.getType());
            this.field.set(null, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on setting static variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)value).getValue().getClass().getName());
        }
        return (JavaObject)value;
    }

    @Override
    @JRubyMethod
    public RubyString name() {
        return this.getRuntime().newString(this.field.getName());
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.field;
    }
}

