/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.io;

import java.io.FileDescriptor;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.Factory;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.io.ChannelDescriptor;
import org.jruby.nb.util.io.ChannelStream;
import org.jruby.nb.util.io.InvalidValueException;
import org.jruby.nb.util.io.ModeFlags;

@JRubyClass(name={"JRuby::FFI::FileDescriptorIO"}, parent="IO")
public class FileDescriptorIO
extends RubyIO {
    public static final String CLASS_NAME = "FileDescriptorIO";

    public FileDescriptorIO(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public FileDescriptorIO(Ruby runtime, IRubyObject fd) {
        super(runtime, FFIProvider.getModule(runtime).fastGetClass(CLASS_NAME));
        ModeFlags modes;
        try {
            modes = new ModeFlags(2L);
        }
        catch (InvalidValueException ex) {
            throw new RuntimeException(ex);
        }
        this.openFile.setMainStream(new ChannelStream(this.getRuntime(), new ChannelDescriptor(Factory.getInstance().newByteChannel(RubyNumeric.fix2int(fd)), FileDescriptorIO.getNewFileno(), modes, new FileDescriptor())));
        this.openFile.setPipeStream(this.openFile.getMainStream());
        this.openFile.setMode(modes.getOpenFileFlags());
        this.openFile.getMainStream().setSync(true);
    }

    public static RubyClass createFileDescriptorIOClass(Ruby runtime) {
        RubyModule parent = FFIProvider.getModule(runtime);
        RubyClass result = runtime.defineClassUnder(CLASS_NAME, runtime.fastGetClass("IO"), Allocator.INSTANCE, parent);
        result.defineAnnotatedMethods(FileDescriptorIO.class);
        result.defineAnnotatedConstants(FileDescriptorIO.class);
        return result;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static FileDescriptorIO newInstance(ThreadContext context, IRubyObject recv, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    @JRubyMethod(name={"wrap"}, required=1, meta=true)
    public static RubyIO wrap(ThreadContext context, IRubyObject recv, IRubyObject fd) {
        return new FileDescriptorIO(context.getRuntime(), fd);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        @Override
        public final IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new FileDescriptorIO(runtime, klass);
        }
    }
}

