/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class YieldNode
extends Node {
    private final Node argsNode;
    private final boolean checkState;

    public YieldNode(ISourcePosition position, Node argsNode, boolean checkState) {
        super(position, NodeType.YIELDNODE);
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
        this.checkState = checkState;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitYieldNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    public boolean getCheckState() {
        return this.checkState;
    }

    @Override
    public List<Node> childNodes() {
        return YieldNode.createList(this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = null;
        if (this.argsNode != null) {
            result = this.argsNode.interpret(runtime, context, self, aBlock);
        }
        return context.getCurrentFrame().getBlock().yield(context, result, null, null, this.checkState);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return aBlock.isGiven() ? "yield" : null;
    }
}

