/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.BlockArgNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Arity;

public class ArgsNode
extends Node {
    private final ListNode arguments;
    private final ListNode optArgs;
    private final ArgumentNode restArgNode;
    private final int restArg;
    private final BlockArgNode blockArgNode;
    private final Arity arity;

    public ArgsNode(ISourcePosition position, ListNode arguments, ListNode optionalArguments, int restArguments, ArgumentNode restArgNode, BlockArgNode blockArgNode) {
        super(position, NodeType.ARGSNODE);
        this.arguments = arguments;
        this.optArgs = optionalArguments;
        this.restArg = restArguments;
        this.restArgNode = restArgNode;
        this.blockArgNode = blockArgNode;
        this.arity = this.getRestArg() == -2 ? Arity.optional() : (this.getOptArgs() != null || this.getRestArg() >= 0 ? Arity.required(this.getRequiredArgsCount()) : Arity.createArity(this.getRequiredArgsCount()));
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitArgsNode(this);
    }

    public ListNode getArgs() {
        return this.arguments;
    }

    public Arity getArity() {
        return this.arity;
    }

    public int getRequiredArgsCount() {
        return this.arguments == null ? 0 : this.arguments.size();
    }

    public int getOptionalArgsCount() {
        return this.optArgs == null ? 0 : this.optArgs.size();
    }

    public ListNode getOptArgs() {
        return this.optArgs;
    }

    public int getRestArg() {
        return this.restArg;
    }

    public ArgumentNode getRestArgNode() {
        return this.restArgNode;
    }

    public BlockArgNode getBlockArgNode() {
        return this.blockArgNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.arguments, this.optArgs, this.restArgNode, this.blockArgNode);
    }
}

