/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ObjectMarshal;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.collections.WeakHashSet;

@JRubyClass(name={"Class"}, parent="Module")
public class RubyClass
extends RubyModule {
    public static final int CS_IDX_INITIALIZE = 0;
    public static final String[] CS_NAMES = new String[]{"initialize"};
    private final CallSite[] baseCallSites = new CallSite[CS_NAMES.length];
    private CallSite[] extraCallSites;
    public static final ObjectAllocator CLASS_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyClass clazz = new RubyClass(runtime);
            clazz.allocator = ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR;
            return clazz;
        }
    };
    private final Ruby runtime;
    private ObjectAllocator allocator;
    protected ObjectMarshal marshal;
    private Set<RubyClass> subclasses;
    protected static final ObjectMarshal DEFAULT_OBJECT_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            IRubyObject object = (IRubyObject)obj;
            marshalStream.registerLinkTarget(object);
            marshalStream.dumpVariables(object.getVariableList());
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            IRubyObject result = type.allocate();
            unmarshalStream.registerLinkTarget(result);
            unmarshalStream.defaultVariablesUnmarshal(result);
            return result;
        }
    };

    public static void createClassClass(Ruby runtime, RubyClass classClass) {
        classClass.index = 13;
        classClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type) {
                return obj instanceof RubyClass;
            }
        };
        classClass.undefineMethod("module_function");
        classClass.undefineMethod("append_features");
        classClass.undefineMethod("extend_object");
        classClass.defineAnnotatedMethods(RubyClass.class);
        classClass.addMethod("new", new SpecificArityNew(classClass, Visibility.PUBLIC));
    }

    public ObjectAllocator getAllocator() {
        return this.allocator;
    }

    public void setAllocator(ObjectAllocator allocator) {
        this.allocator = allocator;
    }

    @JRubyMethod(name={"allocate"})
    public IRubyObject allocate() {
        if (this.superClass == null) {
            throw this.runtime.newTypeError("can't instantiate uninitialized class");
        }
        IRubyObject obj = this.allocator.allocate(this.runtime, this);
        if (obj.getMetaClass().getRealClass() != this.getRealClass()) {
            throw this.runtime.newTypeError("wrong instance allocation");
        }
        return obj;
    }

    public CallSite[] getBaseCallSites() {
        return this.baseCallSites;
    }

    public CallSite[] getExtraCallSites() {
        return this.extraCallSites;
    }

    @Override
    public int getNativeTypeIndex() {
        return 13;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public static RubyClass createBootstrapClass(Ruby runtime, String name, RubyClass superClass, ObjectAllocator allocator) {
        RubyClass obj;
        if (superClass == null) {
            obj = new RubyClass(runtime);
            obj.marshal = DEFAULT_OBJECT_MARSHAL;
        } else {
            obj = new RubyClass(runtime, superClass);
        }
        obj.setAllocator(allocator);
        obj.setBaseName(name);
        return obj;
    }

    protected RubyClass(Ruby runtime, RubyClass superClass, boolean objectSpace) {
        super(runtime, runtime.getClassClass(), objectSpace);
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = new CallSite.InlineCachingCallSite(CS_NAMES[i], CallType.FUNCTIONAL);
        }
        this.runtime = runtime;
        this.superClass = superClass;
    }

    protected RubyClass(Ruby runtime) {
        super(runtime, runtime.getClassClass());
        for (int i = 0; i < CS_NAMES.length; ++i) {
            this.baseCallSites[i] = new CallSite.InlineCachingCallSite(CS_NAMES[i], CallType.FUNCTIONAL);
        }
        this.runtime = runtime;
        this.index = 13;
    }

    protected RubyClass(Ruby runtime, RubyClass superClazz) {
        this(runtime);
        this.superClass = superClazz;
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.infectBy(this.superClass);
    }

    protected RubyClass(Ruby runtime, RubyClass superClazz, CallSite[] extraCallSites) {
        this(runtime);
        this.superClass = superClazz;
        this.marshal = superClazz.marshal;
        superClazz.addSubclass(this);
        this.extraCallSites = extraCallSites;
        this.infectBy(this.superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass) {
        if (superClass == runtime.getClassClass()) {
            throw runtime.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime, superClass);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, CallSite[] extraCallSites) {
        if (superClass == runtime.getClassClass()) {
            throw runtime.newTypeError("can't make subclass of Class");
        }
        if (superClass.isSingleton()) {
            throw runtime.newTypeError("can't make subclass of virtual class");
        }
        return new RubyClass(runtime, superClass, extraCallSites);
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, String name, ObjectAllocator allocator, RubyModule parent, boolean setParent) {
        RubyClass clazz = RubyClass.newClass(runtime, superClass);
        clazz.setBaseName(name);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    public static RubyClass newClass(Ruby runtime, RubyClass superClass, String name, ObjectAllocator allocator, RubyModule parent, boolean setParent, CallSite[] extraCallSites) {
        RubyClass clazz = RubyClass.newClass(runtime, superClass, extraCallSites);
        clazz.setBaseName(name);
        clazz.setAllocator(allocator);
        clazz.makeMetaClass(superClass.getMetaClass());
        if (setParent) {
            clazz.setParent(parent);
        }
        parent.setConstant(name, clazz);
        clazz.inherit(superClass);
        return clazz;
    }

    @Override
    public RubyClass makeMetaClass(RubyClass superClass) {
        if (this.isSingleton()) {
            MetaClass klass = new MetaClass(this.getRuntime(), superClass);
            this.setMetaClass(klass);
            klass.setAttached(this);
            klass.setMetaClass(klass);
            klass.setSuperClass(this.getSuperClass().getRealClass().getMetaClass());
            return klass;
        }
        return super.makeMetaClass(superClass);
    }

    @Deprecated
    public IRubyObject invoke(ThreadContext context, IRubyObject self, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        return this.invoke(context, self, name, args, callType, block);
    }

    public boolean notVisibleAndNotMethodMissing(DynamicMethod method, String name, IRubyObject caller, CallType callType) {
        return !method.isCallableFrom(caller, callType) && !name.equals("method_missing");
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, caller, callType, block);
        }
        return method.call(context, self, (RubyModule)this, name, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, Block block) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, self, (RubyModule)this, name, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, CallType callType, Block block) {
        IRubyObject caller;
        assert (args != null);
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, args, caller, callType, block);
        }
        return method.call(context, self, (RubyModule)this, name, args, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, args, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, self, (RubyModule)this, name, args, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg, caller, callType, block);
        }
        return method.call(context, self, (RubyModule)this, name, arg, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg, Block block) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, self, (RubyModule)this, name, arg, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, caller, callType, block);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType, Block block) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, arg2, caller, callType, block);
        }
        return method.call(context, self, this, name, arg0, arg1, arg2, block);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, arg2, context.getFrameSelf(), CallType.FUNCTIONAL, block);
        }
        return method.call(context, self, this, name, arg0, arg1, arg2, block);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, CallType callType) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, caller, callType, Block.NULL_BLOCK);
        }
        return method.call(context, self, this, name);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, this, name);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args, CallType callType) {
        IRubyObject caller;
        assert (args != null);
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, args, caller, callType, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, args);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject[] args) {
        assert (args != null);
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, args, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, args);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg, CallType callType) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg, caller, callType, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, CallType callType) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, caller, callType, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1);
    }

    public IRubyObject invoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, CallType callType) {
        IRubyObject caller;
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method, name, caller = context.getFrameSelf(), callType)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, arg2, caller, callType, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1, arg2);
    }

    public IRubyObject finvoke(ThreadContext context, IRubyObject self, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        DynamicMethod method = this.searchMethod(name);
        if (this.shouldCallMethodMissing(method)) {
            return RuntimeHelpers.callMethodMissing(context, self, method, name, arg0, arg1, arg2, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this, name, arg0, arg1, arg2);
    }

    private boolean shouldCallMethodMissing(DynamicMethod method) {
        return method.isUndefined();
    }

    private boolean shouldCallMethodMissing(DynamicMethod method, String name, IRubyObject caller, CallType callType) {
        return method.isUndefined() || this.notVisibleAndNotMethodMissing(method, name, caller, callType);
    }

    public IRubyObject invokeInherited(ThreadContext context, IRubyObject self, IRubyObject subclass) {
        DynamicMethod method = this.getMetaClass().searchMethod("inherited");
        if (method.isUndefined()) {
            return RuntimeHelpers.callMethodMissing(context, self, method, "inherited", subclass, context.getFrameSelf(), CallType.FUNCTIONAL, Block.NULL_BLOCK);
        }
        return method.call(context, self, (RubyModule)this.getMetaClass(), "inherited", subclass, Block.NULL_BLOCK);
    }

    public IRubyObject newInstance(ThreadContext context, IRubyObject[] args, Block block) {
        IRubyObject obj = this.allocate();
        this.baseCallSites[0].call(context, obj, args, block);
        return obj;
    }

    @JRubyMethod(name={"initialize"}, optional=1, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject superObject;
        if (this.superClass != null) {
            throw this.getRuntime().newTypeError("already initialized class");
        }
        if (args.length == 0) {
            superObject = this.getRuntime().getObject();
        } else {
            superObject = args[0];
            RubyClass.checkInheritable(superObject);
        }
        IRubyObject superClazz = superObject;
        this.superClass = superClazz;
        this.allocator = ((RubyClass)superClazz).allocator;
        this.makeMetaClass(((RubyObject)superClazz).getMetaClass());
        this.marshal = ((RubyClass)superClazz).marshal;
        ((RubyClass)superClazz).addSubclass(this);
        super.initialize(block);
        this.inherit((RubyClass)superClazz);
        return this;
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (this.superClass != null) {
            throw this.runtime.newTypeError("already initialized class");
        }
        if (original instanceof MetaClass) {
            throw this.getRuntime().newTypeError("can't copy singleton class");
        }
        super.initialize_copy(original);
        this.allocator = ((RubyClass)original).allocator;
        return this;
    }

    public IRubyObject subclasses(ThreadContext context, IRubyObject[] args) {
        boolean recursive = false;
        if (args.length == 1) {
            if (args[0] instanceof RubyBoolean) {
                recursive = args[0].isTrue();
            } else {
                context.getRuntime().newTypeError(args[0], context.getRuntime().fastGetClass("Boolean"));
            }
        }
        return RubyArray.newArray(context.getRuntime(), this.subclasses(recursive)).freeze(context);
    }

    public Collection subclasses(boolean includeDescendants) {
        if (this.subclasses != null) {
            ArrayList<RubyClass> mine = new ArrayList<RubyClass>(this.subclasses);
            if (includeDescendants) {
                for (RubyClass i : this.subclasses) {
                    mine.addAll(i.subclasses(includeDescendants));
                }
            }
            return mine;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized void addSubclass(RubyClass subclass) {
        if (this.subclasses == null) {
            this.subclasses = new WeakHashSet<RubyClass>();
        }
        this.subclasses.add(subclass);
    }

    public Ruby getClassRuntime() {
        return this.runtime;
    }

    public RubyClass getRealClass() {
        return this;
    }

    @JRubyMethod(name={"inherited"}, required=1)
    public IRubyObject inherited(ThreadContext context, IRubyObject arg) {
        return context.getRuntime().getNil();
    }

    public void inherit(RubyClass superClazz) {
        if (superClazz == null) {
            superClazz = this.getRuntime().getObject();
        }
        superClazz.invokeInherited(this.getRuntime().getCurrentContext(), superClazz, this);
    }

    @JRubyMethod(name={"superclass"})
    public IRubyObject superclass(ThreadContext context) {
        RubyClass superClazz = this.superClass;
        if (superClazz == null) {
            throw context.getRuntime().newTypeError("uninitialized class");
        }
        if (this.isSingleton()) {
            superClazz = this.metaClass;
        }
        while (superClazz != null && superClazz.isIncluded()) {
            superClazz = superClazz.superClass;
        }
        return superClazz != null ? superClazz : context.getRuntime().getNil();
    }

    public static void checkInheritable(IRubyObject superClass) {
        if (!(superClass instanceof RubyClass)) {
            throw superClass.getRuntime().newTypeError("superclass must be a Class (" + superClass.getMetaClass() + " given)");
        }
        if (((RubyClass)superClass).isSingleton()) {
            throw superClass.getRuntime().newTypeError("can't make subclass of virtual class");
        }
    }

    public final ObjectMarshal getMarshal() {
        return this.marshal;
    }

    public final void setMarshal(ObjectMarshal marshal) {
        this.marshal = marshal;
    }

    public final void marshal(Object obj, MarshalStream marshalStream) throws IOException {
        this.getMarshal().marshalTo(this.getRuntime(), obj, this, marshalStream);
    }

    public final Object unmarshal(UnmarshalStream unmarshalStream) throws IOException {
        return this.getMarshal().unmarshalFrom(this.getRuntime(), this, unmarshalStream);
    }

    public static void marshalTo(RubyClass clazz, MarshalStream output) throws IOException {
        output.registerLinkTarget(clazz);
        output.writeString(MarshalStream.getPathFromClass(clazz));
    }

    public static RubyClass unmarshalFrom(UnmarshalStream input) throws IOException {
        String name = RubyString.byteListToString(input.unmarshalString());
        RubyClass result = UnmarshalStream.getClassFromPath(input.getRuntime(), name);
        input.registerLinkTarget(result);
        return result;
    }

    public static class SpecificArityNew
    extends JavaMethod {
        public SpecificArityNew(RubyModule implClass, Visibility visibility) {
            super(implClass, visibility);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, obj, args, block);
            return obj;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, obj, block);
            return obj;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, obj, arg0, block);
            return obj;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, obj, arg0, arg1, block);
            return obj;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
            RubyClass cls = (RubyClass)self;
            IRubyObject obj = cls.allocate();
            cls.baseCallSites[0].call(context, obj, arg0, arg1, arg2, block);
            return obj;
        }
    }
}

