/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.openide.util.NbPreferences;

public class FileChooser
extends JFileChooser {
    private static File currectChooserFile = null;

    public FileChooser(String titleText, String buttonText, int mode, FileFilter[] filters, String feedFilePath, boolean useParent) {
        this.setFileHidingEnabled(false);
        this.setFileSelectionMode(mode);
        this.setDialogTitle(titleText);
        if (buttonText != null) {
            this.setApproveButtonText(buttonText);
        }
        if (filters != null) {
            for (int i = 0; i < filters.length; ++i) {
                this.addChoosableFileFilter(filters[i]);
            }
            this.setFileFilter(filters[0]);
        }
        File feedFilePathFile = null;
        if (feedFilePath != null && feedFilePath.length() > 0) {
            feedFilePathFile = new File(feedFilePath);
            try {
                feedFilePathFile = feedFilePathFile.getCanonicalFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (feedFilePathFile != null && feedFilePathFile.exists()) {
            FileChooser.setCurrectChooserFile(feedFilePathFile);
        }
        if (FileChooser.getCurrectChooserFile() == null && feedFilePathFile == null) {
            feedFilePathFile = new File(this.getLastPath());
        }
        if (FileChooser.getCurrectChooserFile() == null && feedFilePathFile.getParentFile() != null && feedFilePathFile.getParentFile().exists()) {
            FileChooser.setCurrectChooserFile(feedFilePathFile.getParentFile());
            useParent = false;
        }
        if (FileChooser.getCurrectChooserFile() != null) {
            if (useParent) {
                if (FileChooser.getCurrectChooserFile() != null && FileChooser.getCurrectChooserFile().exists()) {
                    this.setSelectedFile(FileChooser.getCurrectChooserFile());
                }
            } else if (FileChooser.getCurrectChooserFile() != null && FileChooser.getCurrectChooserFile().exists()) {
                this.setCurrentDirectory(FileChooser.getCurrectChooserFile());
            }
        } else {
            File sdFile;
            String sd = System.getProperty("spro.pwd");
            if (sd != null && (sdFile = new File(sd)).exists()) {
                this.setCurrentDirectory(sdFile);
            }
        }
    }

    private String getLastPath() {
        Preferences pref;
        String res;
        File file;
        String feed = System.getProperty("user.home");
        if (feed == null) {
            feed = "";
        }
        if (!(file = new File(res = (pref = NbPreferences.forModule(FileChooser.class)).get("last-file", feed))).exists() && !res.equals(feed)) {
            res = feed;
        }
        return res;
    }

    @Override
    public int showOpenDialog(Component parent) {
        int ret = super.showOpenDialog(parent);
        if (ret != 1 && this.getSelectedFile().exists()) {
            FileChooser.setCurrectChooserFile(this.getSelectedFile());
            Preferences pref = NbPreferences.forModule(FileChooser.class);
            pref.put("last-file", FileChooser.getCurrectChooserFile().getAbsolutePath());
        }
        return ret;
    }

    public static File getCurrectChooserFile() {
        return currectChooserFile;
    }

    private static void setCurrectChooserFile(File aCurrectChooserFile) {
        currectChooserFile = aCurrectChooserFile;
    }
}

