/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.MatcherUtilities;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.modules.java.hints.jackpot.spi.support.OneCheckboxCustomizerProvider;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class ThrowableInitCause {
    public static final String STRICT_KEY = "strict";
    public static final boolean STRICT_DEFAULT = false;

    public static ErrorDescription expression(HintContext hintContext) {
        return ThrowableInitCause.initCause(hintContext, false);
    }

    public static ErrorDescription variable(HintContext hintContext) {
        return ThrowableInitCause.initCause(hintContext, true);
    }

    private static ErrorDescription initCause(HintContext hintContext, boolean bl) {
        Object object;
        String string;
        TypeElement typeElement = hintContext.getInfo().getElements().getTypeElement("java.lang.Throwable");
        if (typeElement == null) {
            return null;
        }
        TreePath treePath = hintContext.getVariables().get("$exc");
        TypeMirror typeMirror = hintContext.getInfo().getTrees().getTypeMirror(treePath);
        Types types = hintContext.getInfo().getTypes();
        if (!types.isSubtype(types.erasure(typeMirror), types.erasure(typeElement.asType()))) {
            return null;
        }
        Element element = types.asElement(typeMirror);
        if (element == null || element.getKind() != ElementKind.CLASS) {
            return null;
        }
        LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
        TreePath treePath2 = hintContext.getVariables().get("$str");
        if (treePath2 != null && (MatcherUtilities.matches(hintContext, treePath2, "$del.toString()") || MatcherUtilities.matches(hintContext, treePath2, "$del.getMessage()") && !hintContext.getPreferences().getBoolean(STRICT_KEY, false) || MatcherUtilities.matches(hintContext, treePath2, "$del.getLocalizedMessage()") && !hintContext.getPreferences().getBoolean(STRICT_KEY, false)) || treePath2 == null && !hintContext.getPreferences().getBoolean(STRICT_KEY, false)) {
            string = "new $exc($del)";
        } else {
            object = hintContext.getInfo().getElements().getTypeElement("java.lang.String");
            if (object == null) {
                return null;
            }
            linkedList.add(object.asType());
            string = treePath2 != null ? "new $exc($str, $del)" : "new $exc(null, $del)";
        }
        if (bl) {
            string = "throw " + string + ";";
        }
        object = hintContext.getVariables().get("$del");
        TypeMirror typeMirror2 = hintContext.getInfo().getTrees().getTypeMirror((TreePath)object);
        linkedList.add(typeMirror2);
        if (!ThrowableInitCause.findConstructor(element, types, linkedList)) {
            return null;
        }
        String string2 = NbBundle.getMessage(ThrowableInitCause.class, (String)"FIX_ThrowableInitCause");
        String string3 = NbBundle.getMessage(ThrowableInitCause.class, (String)"ERR_ThrowableInitCause");
        TreePath treePath3 = hintContext.getVariables().get("$excVar");
        if (treePath3 == null) {
            treePath3 = hintContext.getPath();
        }
        return ErrorDescriptionFactory.forTree(hintContext, treePath3, string3, JavaFix.rewriteFix(hintContext, string2, hintContext.getPath(), string, new String[0]));
    }

    private static boolean findConstructor(Element element, Types types, List<TypeMirror> list) {
        boolean bl = false;
        block0: for (ExecutableElement executableElement : ElementFilter.constructorsIn(element.getEnclosedElements())) {
            if (executableElement.isVarArgs() || executableElement.getParameters().size() != list.size()) continue;
            Iterator<? extends VariableElement> iterator = executableElement.getParameters().iterator();
            Iterator<TypeMirror> iterator2 = list.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                if (types.isAssignable(iterator2.next(), iterator.next().asType())) continue;
                continue block0;
            }
            bl = true;
            break;
        }
        return bl;
    }

    public static final class CustomizerProviderImpl
    extends OneCheckboxCustomizerProvider {
        public CustomizerProviderImpl() {
            super(NbBundle.getMessage(ThrowableInitCause.class, (String)"DN_ThrowableInitCauseStrict"), NbBundle.getMessage(ThrowableInitCause.class, (String)"TP_ThrowableInitCauseStrict"), ThrowableInitCause.STRICT_KEY, false);
        }
    }
}

