/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.openide.filesystems.FileObject;

public class LazyHintComputation
implements CancellableTask<CompilationInfo> {
    private FileObject file;
    private AtomicBoolean cancelled = new AtomicBoolean();
    private CreatorBasedLazyFixList delegate;

    public LazyHintComputation(FileObject fileObject) {
        this.file = fileObject;
    }

    public synchronized void cancel() {
        this.cancelled.set(true);
        if (this.delegate != null) {
            this.delegate.cancel();
        }
    }

    private synchronized void setDelegate(CreatorBasedLazyFixList creatorBasedLazyFixList) {
        this.delegate = creatorBasedLazyFixList;
    }

    private boolean isCancelled() {
        return this.cancelled.get();
    }

    private void resume() {
        this.cancelled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CompilationInfo compilationInfo) {
        this.resume();
        boolean bl = false;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        try {
            linkedList.addAll(LazyHintComputationFactory.getAndClearToCompute(this.file));
            if (this.isCancelled()) {
                bl = true;
                return;
            }
            while (!linkedList.isEmpty()) {
                if (this.isCancelled()) {
                    bl = true;
                    return;
                }
                Iterator iterator = (CreatorBasedLazyFixList)linkedList.remove(0);
                this.setDelegate((CreatorBasedLazyFixList)((Object)iterator));
                ((CreatorBasedLazyFixList)((Object)iterator)).compute(compilationInfo, this.cancelled);
                this.setDelegate(null);
                if (!this.isCancelled()) continue;
                linkedList.add(0, iterator);
                bl = true;
                return;
            }
        }
        finally {
            if (bl && !linkedList.isEmpty()) {
                for (CreatorBasedLazyFixList creatorBasedLazyFixList : linkedList) {
                    LazyHintComputationFactory.addToCompute(this.file, creatorBasedLazyFixList);
                }
            }
        }
    }
}

