/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.infrastructure;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.tools.Diagnostic;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaParserResultTask;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.java.hints.infrastructure.CreatorBasedLazyFixList;
import org.netbeans.modules.java.hints.infrastructure.JavaHintsPositionRefresher;
import org.netbeans.modules.java.hints.infrastructure.LazyHintComputationFactory;
import org.netbeans.modules.java.hints.infrastructure.RulesManager;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.LazyFixList;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.ErrorManager;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

public final class ErrorHintsProvider
extends JavaParserResultTask {
    public static ErrorManager ERR = ErrorManager.getDefault().getInstance("org.netbeans.modules.java.hints");
    public static Logger LOG = Logger.getLogger("org.netbeans.modules.java.hints");
    private static final Map<Diagnostic.Kind, Severity> errorKind2Severity = new EnumMap<Diagnostic.Kind, Severity>(Diagnostic.Kind.class);
    private static final Set<String> INVALID_METHOD_INVOCATION;
    private static final Set<String> CANNOT_RESOLVE;
    private static final Set<String> UNDERLINE_IDENTIFIER;
    private static final Set<JavaTokenId> WHITESPACE;
    private boolean cancel;

    ErrorHintsProvider() {
        super(JavaSource.Phase.RESOLVED);
    }

    List<ErrorDescription> computeErrors(CompilationInfo compilationInfo, Document document, String string) throws IOException {
        return this.computeErrors(compilationInfo, document, null, string);
    }

    List<ErrorDescription> computeErrors(CompilationInfo compilationInfo, Document document, Integer n, String string) throws IOException {
        List list = compilationInfo.getDiagnostics();
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "errors = " + list);
        }
        boolean bl = "text/x-java".equals(string);
        HashMap<Class, ErrorRule.Data> hashMap = new HashMap<Class, ErrorRule.Data>();
        for (Diagnostic diagnostic : list) {
            LazyFixList lazyFixList;
            if (this.isCanceled()) {
                return null;
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "d = " + diagnostic);
            }
            Map<String, List<ErrorRule>> map = RulesManager.getInstance().getErrors(string);
            List<ErrorRule> list2 = map.get(diagnostic.getCode());
            if (ERR.isLoggable(1)) {
                ERR.log(1, "code= " + diagnostic.getCode());
                ERR.log(1, "rules = " + list2);
            }
            if (list2 != null) {
                int n2 = (int)this.getPrefferedPosition(compilationInfo, diagnostic);
                lazyFixList = new CreatorBasedLazyFixList(compilationInfo.getFileObject(), diagnostic.getCode(), n2, list2, hashMap);
            } else {
                lazyFixList = ErrorDescriptionFactory.lazyListForFixes(Collections.emptyList());
            }
            if (ERR.isLoggable(1)) {
                ERR.log(1, "ehm=" + lazyFixList);
            }
            String string2 = diagnostic.getMessage(null);
            Position[] positionArray = this.getLine(compilationInfo, diagnostic, document, (int)diagnostic.getStartPosition(), (int)diagnostic.getEndPosition());
            if (this.isCanceled()) {
                return null;
            }
            if (positionArray[0] == null || positionArray[1] == null) continue;
            if (n != null) {
                try {
                    int n3 = Utilities.getRowStart((BaseDocument)((NbEditorDocument)document), (int)n);
                    int n4 = Utilities.getRowStart((BaseDocument)((NbEditorDocument)document), (int)positionArray[0].getOffset());
                    if (n3 != n4) {
                        continue;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
            arrayList.add(ErrorDescriptionFactory.createErrorDescription((Severity)errorKind2Severity.get((Object)diagnostic.getKind()), (String)string2, (LazyFixList)lazyFixList, (Document)document, (Position)positionArray[0], (Position)positionArray[1]));
        }
        if (this.isCanceled()) {
            return null;
        }
        if (bl) {
            LazyHintComputationFactory.getAndClearToCompute(compilationInfo.getFileObject());
        } else {
            for (ErrorDescription errorDescription : arrayList) {
                errorDescription.getFixes().getFixes();
            }
        }
        return arrayList;
    }

    public static Token findUnresolvedElementToken(CompilationInfo compilationInfo, int n) throws IOException {
        TokenHierarchy tokenHierarchy = compilationInfo.getTokenHierarchy();
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JavaTokenId.language());
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() == JavaTokenId.DOT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            } else if (token.id() == JavaTokenId.LT) {
                tokenSequence.moveNext();
                token = tokenSequence.token();
            } else if (token.id() == JavaTokenId.NEW || token.id() == JavaTokenId.WHITESPACE) {
                boolean bl = tokenSequence.moveNext();
                while (bl && tokenSequence.token().id() == JavaTokenId.WHITESPACE) {
                    bl = tokenSequence.moveNext();
                }
                if (!bl) {
                    return null;
                }
                token = tokenSequence.token();
            }
            if (token.id() == JavaTokenId.IDENTIFIER) {
                return tokenSequence.offsetToken();
            }
        }
        return null;
    }

    private static int[] findUnresolvedElementSpan(CompilationInfo compilationInfo, int n) throws IOException {
        Token token = ErrorHintsProvider.findUnresolvedElementToken(compilationInfo, n);
        if (token != null) {
            return new int[]{token.offset(null), token.offset(null) + token.length()};
        }
        return null;
    }

    public static TreePath findUnresolvedElement(CompilationInfo compilationInfo, int n) throws IOException {
        int[] nArray = ErrorHintsProvider.findUnresolvedElementSpan(compilationInfo, n);
        if (nArray != null) {
            return compilationInfo.getTreeUtilities().pathFor(nArray[0] + 1);
        }
        return null;
    }

    private int[] handlePossibleMethodInvocation(CompilationInfo compilationInfo, Diagnostic diagnostic, Document document, int n, int n2) throws IOException {
        int n3 = (int)this.getPrefferedPosition(compilationInfo, diagnostic);
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n3 + 1);
        if (treePath != null && treePath.getParentPath() != null && treePath.getParentPath().getLeaf() != null && (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION || treePath.getParentPath().getLeaf().getKind() == Tree.Kind.NEW_CLASS)) {
            int[] nArray = new int[1];
            if (org.netbeans.modules.editor.java.Utilities.fuzzyResolveMethodInvocation((CompilationInfo)compilationInfo, (TreePath)(treePath = treePath.getParentPath()), (TypeMirror[])new TypeMirror[1], (int[])nArray) != null) {
                Tree tree;
                ExpressionTree expressionTree;
                if (treePath.getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
                    expressionTree = (MethodInvocationTree)treePath.getLeaf();
                    tree = expressionTree.getArguments().get(nArray[0]);
                } else {
                    expressionTree = (NewClassTree)treePath.getLeaf();
                    tree = expressionTree.getArguments().get(nArray[0]);
                }
                int n4 = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), tree);
                int n5 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), tree);
                return new int[]{n4, n5};
            }
        }
        return null;
    }

    private Position[] getLine(CompilationInfo compilationInfo, Diagnostic diagnostic, final Document document, int n, int n2) throws IOException {
        int n3;
        Token token;
        int n4;
        int[] nArray;
        StyledDocument styledDocument = (StyledDocument)document;
        DataObject dataObject = (DataObject)document.getProperty("stream");
        if (dataObject == null) {
            return new Position[]{null, null};
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        int n5 = compilationInfo.getSnapshot().getOriginalOffset(n);
        int n6 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n5);
        int n7 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n6);
        Line line = lineCookie.getLineSet().getCurrent(n6);
        boolean bl = false;
        if (INVALID_METHOD_INVOCATION.contains(diagnostic.getCode()) && (nArray = this.translatePositions(compilationInfo, this.handlePossibleMethodInvocation(compilationInfo, diagnostic, document, n, n2))) != null) {
            n = nArray[0];
            n2 = nArray[1];
            bl = true;
        }
        if (CANNOT_RESOLVE.contains(diagnostic.getCode()) && !bl && (nArray = this.translatePositions(compilationInfo, ErrorHintsProvider.findUnresolvedElementSpan(compilationInfo, (int)this.getPrefferedPosition(compilationInfo, diagnostic)))) != null) {
            n = nArray[0];
            n2 = nArray[1];
            bl = true;
        }
        if (UNDERLINE_IDENTIFIER.contains(diagnostic.getCode())) {
            int n8 = (int)this.getPrefferedPosition(compilationInfo, diagnostic);
            TokenSequence tokenSequence = compilationInfo.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            n4 = tokenSequence.move(n8);
            if (tokenSequence.moveNext() && n4 >= 0 && n4 < tokenSequence.token().length()) {
                int[] nArray2;
                token = tokenSequence.token();
                if (token.id() == JavaTokenId.DOT) {
                    while (tokenSequence.moveNext() && WHITESPACE.contains(tokenSequence.token().id())) {
                    }
                    token = tokenSequence.token();
                }
                if (token.id() == JavaTokenId.NEW) {
                    while (tokenSequence.moveNext() && WHITESPACE.contains(tokenSequence.token().id())) {
                    }
                    token = tokenSequence.token();
                }
                if (token.id() == JavaTokenId.CLASS) {
                    while (tokenSequence.moveNext() && WHITESPACE.contains(tokenSequence.token().id())) {
                    }
                    token = tokenSequence.token();
                }
                if (token.id() == JavaTokenId.IDENTIFIER && (nArray2 = this.translatePositions(compilationInfo, new int[]{tokenSequence.offset(), tokenSequence.offset() + token.length()})) != null) {
                    n = nArray2[0];
                    n2 = nArray2[1];
                    bl = true;
                }
            }
        }
        String string = null;
        if (!bl && (string = line.getText()) == null) {
            this.cancel();
            return null;
        }
        if (!bl && diagnostic.getCode().endsWith("proc.messager") && (n3 = compilationInfo.getSnapshot().getOriginalOffset(n2)) <= n7 + string.length()) {
            n = n5;
            n2 = n3;
            bl = true;
        }
        if (!bl) {
            int n9;
            n4 = string.length();
            for (n9 = 0; n9 < string.length() && Character.isWhitespace(string.charAt(n9)); ++n9) {
            }
            while (n4 > 0 && Character.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            n = n4 == 0 ? n7 : n7 + n9;
            n2 = n7 + n4;
        }
        if (ERR.isLoggable(1)) {
            ERR.log(1, "startOffset = " + n);
            ERR.log(1, "endOffset = " + n2);
        }
        final int n10 = n;
        n4 = n2;
        token = new Position[2];
        document.render(new Runnable((Position[])token){
            final /* synthetic */ Position[] val$result;
            {
                this.val$result = positionArray;
            }

            @Override
            public void run() {
                if (ErrorHintsProvider.this.isCanceled()) {
                    return;
                }
                int n = document.getLength();
                if (n10 >= n || n4 > n) {
                    if (!ErrorHintsProvider.this.isCanceled() && ERR.isLoggable(16)) {
                        ERR.log(16, "document changed, but not canceled?");
                        ERR.log(16, "len = " + n);
                        ERR.log(16, "startOffset = " + n10);
                        ERR.log(16, "endOffset = " + n4);
                    }
                    ErrorHintsProvider.this.cancel();
                    return;
                }
                try {
                    this.val$result[0] = NbDocument.createPosition((Document)document, (int)n10, (Position.Bias)Position.Bias.Forward);
                    this.val$result[1] = NbDocument.createPosition((Document)document, (int)n4, (Position.Bias)Position.Bias.Backward);
                }
                catch (BadLocationException badLocationException) {
                    ERR.notify(65536, (Throwable)badLocationException);
                }
            }
        });
        return token;
    }

    synchronized boolean isCanceled() {
        return this.cancel;
    }

    public synchronized void cancel() {
        this.cancel = true;
    }

    synchronized void resume() {
        this.cancel = false;
    }

    public void run(Parser.Result result, SchedulerEvent schedulerEvent) {
        this.resume();
        CompilationInfo compilationInfo = CompilationInfo.get((Parser.Result)result);
        if (compilationInfo == null) {
            return;
        }
        Document document = result.getSnapshot().getSource().getDocument(false);
        if (document == null) {
            Logger.getLogger(ErrorHintsProvider.class.getName()).log(Level.FINE, "SemanticHighlighter: Cannot get document!");
            return;
        }
        long l = DocumentUtilities.getDocumentVersion((Document)document);
        String string = result.getSnapshot().getSource().getMimeType();
        long l2 = System.currentTimeMillis();
        try {
            List<ErrorDescription> list = this.computeErrors(compilationInfo, document, string);
            if (list == null) {
                return;
            }
            HintsController.setErrors((Document)document, (String)ErrorHintsProvider.class.getName(), list);
            JavaHintsPositionRefresher.errorsUpdated(document, l, list);
            long l3 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Java Hints", new Object[]{compilationInfo.getFileObject(), l3 - l2});
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    private int[] translatePositions(CompilationInfo compilationInfo, int[] nArray) {
        if (nArray == null || nArray[0] == -1 || nArray[1] == -1) {
            return null;
        }
        int n = compilationInfo.getSnapshot().getOriginalOffset(nArray[0]);
        int n2 = compilationInfo.getSnapshot().getOriginalOffset(nArray[1]);
        if (n == -1 || n2 == -1) {
            return null;
        }
        return new int[]{n, n2};
    }

    private long getPrefferedPosition(CompilationInfo compilationInfo, Diagnostic diagnostic) throws IOException {
        if ("compiler.err.doesnt.exist".equals(diagnostic.getCode())) {
            return diagnostic.getStartPosition();
        }
        if ("compiler.err.cant.resolve.location".equals(diagnostic.getCode()) || "compiler.err.cant.resolve.location.args".equals(diagnostic.getCode())) {
            int[] nArray = ErrorHintsProvider.findUnresolvedElementSpan(compilationInfo, (int)diagnostic.getPosition());
            if (nArray != null) {
                return nArray[0];
            }
            return diagnostic.getPosition();
        }
        if ("compiler.err.not.stmt".equals(diagnostic.getCode())) {
            Element element;
            TreePath treePath = ErrorHintsProvider.findUnresolvedElement(compilationInfo, (int)diagnostic.getStartPosition() - 1);
            Element element2 = element = treePath != null ? compilationInfo.getTrees().getElement(treePath) : null;
            if (element == null || element.asType().getKind() == TypeKind.ERROR) {
                return diagnostic.getStartPosition() - 1L;
            }
            if (element.asType().getKind() == TypeKind.PACKAGE) {
                String string = ((PackageElement)element).getQualifiedName().toString();
                if (compilationInfo.getElements().getPackageElement(string) == null) {
                    return diagnostic.getStartPosition() - 1L;
                }
            }
            return diagnostic.getStartPosition();
        }
        return diagnostic.getPosition();
    }

    static {
        errorKind2Severity.put(Diagnostic.Kind.ERROR, Severity.ERROR);
        errorKind2Severity.put(Diagnostic.Kind.MANDATORY_WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.WARNING, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.NOTE, Severity.WARNING);
        errorKind2Severity.put(Diagnostic.Kind.OTHER, Severity.WARNING);
        INVALID_METHOD_INVOCATION = new HashSet<String>(Arrays.asList("compiler.err.prob.found.req", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve.location.args"));
        CANNOT_RESOLVE = new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.doesnt.exist"));
        UNDERLINE_IDENTIFIER = new HashSet<String>(Arrays.asList("compiler.err.local.var.accessed.from.icls.needs.final", "compiler.err.var.might.not.have.been.initialized", "compiler.err.report.access", "compiler.err.does.not.override.abstract", "compiler.err.abstract.cant.be.instantiated"));
        WHITESPACE = EnumSet.of(JavaTokenId.BLOCK_COMMENT, JavaTokenId.JAVADOC_COMMENT, JavaTokenId.LINE_COMMENT, JavaTokenId.WHITESPACE);
    }
}

