/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jackpot.spi.HintContext;
import org.netbeans.modules.java.hints.jackpot.spi.JavaFix;
import org.netbeans.modules.java.hints.jackpot.spi.support.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class Tiny {
    private static final Set<String> METHOD_NAME = new HashSet<String>(Arrays.asList("getString", "getBoolean", "getByte", "getShort", "getInt", "getLong", "getFloat", "getDouble", "getBigDecimal", "getBytes", "getDate", "getTime", "getTimestamp", "getAsciiStream", "getUnicodeStream", "getBinaryStream", "getObject", "getCharacterStream", "getBigDecimal", "updateNull", "updateBoolean", "updateByte", "updateShort", "updateInt", "updateLong", "updateFloat", "updateDouble", "updateBigDecimal", "updateString", "updateBytes", "updateDate", "updateTime", "updateTimestamp", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateObject", "updateObject", "getObject", "getRef", "getBlob", "getClob", "getArray", "getDate", "getTime", "getTimestamp", "getURL", "updateRef", "updateBlob", "updateClob", "updateArray", "getRowId", "updateRowId", "updateNString", "updateNClob", "getNClob", "getSQLXML", "updateSQLXML", "getNString", "getNCharacterStream", "updateNCharacterStream", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateBlob", "updateClob", "updateNClob", "updateNCharacterStream", "updateAsciiStream", "updateBinaryStream", "updateCharacterStream", "updateBlob", "updateClob", "updateNClob"));

    public static ErrorDescription stringReplaceAllDot(HintContext hintContext) {
        Tree tree = ((MethodInvocationTree)hintContext.getPath().getLeaf()).getArguments().get(0);
        TreePath treePath = new TreePath(hintContext.getPath(), tree);
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_string-replace-all-dot");
        Fix fix = JavaFix.rewriteFix(hintContext, string, treePath, "\"\\\\.\"", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_string-replace-all-dot");
        return ErrorDescriptionFactory.forTree(hintContext, tree, string2, fix);
    }

    public static ErrorDescription newObject(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"ERR_newObject");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string, new Fix[0]);
    }

    public static List<ErrorDescription> systemArrayCopy(HintContext hintContext) {
        String string;
        String string2;
        Object object;
        TreePath treePath;
        LinkedList<ErrorDescription> linkedList = new LinkedList<ErrorDescription>();
        for (String string3 : Arrays.asList("$src", "$dest")) {
            treePath = hintContext.getVariables().get(string3);
            object = hintContext.getInfo().getTrees().getTypeMirror(treePath);
            if (object == null || object.getKind() == TypeKind.ERROR || object.getKind() == TypeKind.ARRAY) continue;
            string2 = Utilities.shortDisplayName(hintContext.getInfo(), (ExpressionTree)treePath.getLeaf());
            string = NbBundle.getMessage(Tiny.class, (String)"ERR_system_arraycopy_notarray", (Object)string2);
            linkedList.add(ErrorDescriptionFactory.forTree(hintContext, treePath, string, new Fix[0]));
        }
        for (String string3 : Arrays.asList("$srcPos", "$destPos", "$length")) {
            treePath = hintContext.getVariables().get(string3);
            object = ArithmeticUtilities.compute(hintContext.getInfo(), treePath, true);
            if (object == null || ((Number)object).intValue() >= 0) continue;
            string2 = Utilities.shortDisplayName(hintContext.getInfo(), (ExpressionTree)treePath.getLeaf());
            string = NbBundle.getMessage(Tiny.class, (String)"ERR_system_arraycopy_negative", (Object)string2);
            linkedList.add(ErrorDescriptionFactory.forTree(hintContext, treePath, string, new Fix[0]));
        }
        return linkedList;
    }

    public static ErrorDescription equalsNull(HintContext hintContext) {
        String string = NbBundle.getMessage(Tiny.class, (String)"FIX_equalsNull");
        Fix fix = JavaFix.rewriteFix(hintContext, string, hintContext.getPath(), "$obj == null", new String[0]);
        String string2 = NbBundle.getMessage(Tiny.class, (String)"ERR_equalsNull");
        return ErrorDescriptionFactory.forTree(hintContext, hintContext.getPath(), string2, fix);
    }

    public static ErrorDescription resultSet(HintContext hintContext) {
        TypeElement typeElement = hintContext.getInfo().getElements().getTypeElement("java.sql.ResultSet");
        String string = hintContext.getVariableNames().get("$method");
        if (!METHOD_NAME.contains(string)) {
            return null;
        }
        TreePath treePath = hintContext.getVariables().get("$columnIndex");
        Number number = ArithmeticUtilities.compute(hintContext.getInfo(), treePath, true);
        if (number == null) {
            return null;
        }
        int n = number.intValue();
        if (n > 0) {
            return null;
        }
        Element element = hintContext.getInfo().getTrees().getElement(hintContext.getPath());
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        boolean bl = false;
        for (ExecutableElement object2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (object2.equals(element)) {
                bl = true;
                break;
            }
            if (!hintContext.getInfo().getElements().overrides(executableElement, object2, (TypeElement)executableElement.getEnclosingElement())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        String string2 = n == 0 ? "ERR_ResultSetZero" : "ERR_ResultSetNegative";
        String string3 = NbBundle.getMessage(Tiny.class, (String)string2);
        return ErrorDescriptionFactory.forName(hintContext, treePath, string3, new Fix[0]);
    }
}

