/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class IllegalInstanceOf
extends AbstractHint {
    private static Map<String, String> packagesToCheck = new HashMap<String, String>();

    public IllegalInstanceOf() {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.INSTANCE_OF);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (treePath.getLeaf().getKind() != Tree.Kind.INSTANCE_OF) {
            return null;
        }
        InstanceOfTree instanceOfTree = (InstanceOfTree)treePath.getLeaf();
        TypeMirror typeMirror = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, instanceOfTree.getExpression()));
        Element element = compilationInfo.getTrees().getElement(new TreePath(treePath, instanceOfTree.getType()));
        if (typeMirror == null || typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element element2 = ((DeclaredType)typeMirror).asElement();
        if (element2 == null || element == null || !element2.getKind().isInterface() || !element.getKind().isInterface()) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element2;
        TypeElement typeElement2 = (TypeElement)element;
        if (typeElement.getEnclosingElement().getKind() != ElementKind.PACKAGE || typeElement2.getEnclosingElement().getKind() != ElementKind.PACKAGE) {
            return null;
        }
        PackageElement packageElement = (PackageElement)typeElement.getEnclosingElement();
        PackageElement packageElement2 = (PackageElement)typeElement2.getEnclosingElement();
        String string = packageElement.getQualifiedName().toString();
        String string2 = packageElement2.getQualifiedName().toString();
        if (packagesToCheck.containsKey(string) && string.equals(string2)) {
            String string3 = packagesToCheck.get(string);
            TypeElement typeElement3 = compilationInfo.getElements().getTypeElement(string3);
            if (!compilationInfo.getTypes().isSubtype(typeElement.asType(), typeElement3.asType())) {
                return null;
            }
            if (!compilationInfo.getTypes().isSubtype(typeElement2.asType(), typeElement3.asType())) {
                return null;
            }
            int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), instanceOfTree);
            int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), instanceOfTree);
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(IllegalInstanceOf.class, (String)"MSG_IllegalInstanceOf"), (FileObject)compilationInfo.getFileObject(), (int)n, (int)n2));
        }
        return null;
    }

    @Override
    public String getId() {
        return IllegalInstanceOf.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(IllegalInstanceOf.class, (String)"LBL_IllegalInstanceOf");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(IllegalInstanceOf.class, (String)"DSC_IllegalInstanceOf");
    }

    @Override
    public void cancel() {
    }

    static {
        packagesToCheck.put("javax.lang.model.element", "javax.lang.model.element.Element");
        packagesToCheck.put("javax.lang.model.type", "javax.lang.model.type.TypeMirror");
        packagesToCheck.put("com.sun.source.tree", "com.sun.source.tree.Tree");
    }
}

