/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.java.hints.spi.support.FixFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EqualsMethodHint
extends AbstractHint {
    private static final String SUPPRESS_KEY = "EqualsWhichDoesntCheckParameterClass";

    public EqualsMethodHint() {
        super(true, false, AbstractHint.HintSeverity.WARNING, SUPPRESS_KEY);
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EqualsMethodHint.class, (String)"DSC_EqualsMethod");
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (!this.getTreeKinds().contains((Object)treePath.getLeaf().getKind())) {
            return null;
        }
        if (compilationInfo.getTreeUtilities().isSynthetic(treePath)) {
            return null;
        }
        MethodTree methodTree = (MethodTree)treePath.getLeaf();
        if (!methodTree.getName().contentEquals("equals")) {
            return null;
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null || element.getKind() != ElementKind.METHOD) {
            return null;
        }
        ExecutableElement executableElement = (ExecutableElement)element;
        ExecutableElement executableElement2 = null;
        TypeElement typeElement = compilationInfo.getElements().getTypeElement("java.lang.Object");
        if (typeElement != null) {
            for (ExecutableElement object2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (!object2.getSimpleName().contentEquals("equals")) continue;
                executableElement2 = object2;
                break;
            }
        }
        if (executableElement2 == null || !compilationInfo.getElements().overrides(executableElement, executableElement2, (TypeElement)executableElement.getEnclosingElement())) {
            return null;
        }
        Element element2 = compilationInfo.getTrees().getElement(new TreePath(treePath, methodTree.getParameters().get(0)));
        if (element2 == null || element2.getKind() != ElementKind.PARAMETER) {
            return null;
        }
        if (methodTree.getBody() == null) {
            return null;
        }
        try {
            new VisitorImpl(compilationInfo, element2).scan(new TreePath(treePath, methodTree.getBody()), null);
        }
        catch (Found found) {
            return null;
        }
        int[] nArray = compilationInfo.getTreeUtilities().findNameSpan(methodTree);
        if (nArray == null) {
            return null;
        }
        ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(EqualsMethodHint.class, (String)"ERR_EQUALS_NOT_CHECKING_TYPE"), FixFactory.createSuppressWarnings(compilationInfo, treePath, SUPPRESS_KEY), (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
        return Collections.singletonList(errorDescription);
    }

    @Override
    public String getId() {
        return EqualsMethodHint.class.getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(EqualsMethodHint.class, (String)"DN_EqualsMethod");
    }

    @Override
    public void cancel() {
    }

    private static final class Found
    extends RuntimeException {
        private Found() {
        }
    }

    private static final class VisitorImpl
    extends TreePathScanner<Void, Void> {
        private CompilationInfo info;
        private Element parameter;

        public VisitorImpl(CompilationInfo compilationInfo, Element element) {
            this.info = compilationInfo;
            this.parameter = element;
        }

        @Override
        public Void visitInstanceOf(InstanceOfTree instanceOfTree, Void void_) {
            Element element = this.info.getTrees().getElement(new TreePath(this.getCurrentPath(), instanceOfTree.getExpression()));
            if (((Object)this.parameter).equals(element)) {
                throw new Found();
            }
            return (Void)super.visitInstanceOf(instanceOfTree, void_);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void void_) {
            if (methodInvocationTree.getArguments().isEmpty() && methodInvocationTree.getMethodSelect().getKind() == Tree.Kind.MEMBER_SELECT) {
                MemberSelectTree memberSelectTree = (MemberSelectTree)methodInvocationTree.getMethodSelect();
                Element element = this.info.getTrees().getElement(new TreePath(new TreePath(this.getCurrentPath(), memberSelectTree), memberSelectTree.getExpression()));
                if (((Object)this.parameter).equals(element) && memberSelectTree.getIdentifier().contentEquals("getClass")) {
                    throw new Found();
                }
            }
            return (Void)super.visitMethodInvocation(methodInvocationTree, void_);
        }
    }
}

