/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Utilities;

public final class ToolUtils {
    private static String cygwinBase;
    private static final Map<ToolchainManager.ToolchainDescriptor, String> commandsFolders;
    private static final WeakHashMap<String, String> commandCache;

    private ToolUtils() {
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            String cygwinBin;
            ToolchainManager.ToolchainDescriptor td = ToolchainManagerImpl.getImpl().getToolchain("Cygwin", 3);
            if (td != null && (cygwinBin = ToolUtils.getBaseFolder(td, 3)) != null) {
                cygwinBase = cygwinBin.substring(0, cygwinBin.length() - 4).replace("\\", "/");
            }
            if (cygwinBase == null) {
                for (String dir : Path.getPath()) {
                    if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("cygwin")) continue;
                    if (dir.endsWith("/")) {
                        dir = dir.substring(0, dir.length() - 1);
                    }
                    if (dir.toLowerCase().endsWith("/usr/bin")) {
                        cygwinBase = dir.substring(0, dir.length() - 8);
                        break;
                    }
                    if (!dir.toLowerCase().endsWith("/bin")) continue;
                    cygwinBase = dir.substring(0, dir.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getCommandFolder(ToolchainManager.ToolchainDescriptor descriptor) {
        if (!Utilities.isWindows()) {
            return null;
        }
        String res = ToolUtils.getCommandDir(descriptor);
        if (res != null) {
            return res;
        }
        ToolchainManagerImpl tcm = ToolchainManagerImpl.getImpl();
        for (ToolchainManager.ToolchainDescriptor td : tcm.getToolchains(3)) {
            if (td == null || (res = ToolUtils.getCommandDir(td)) == null) continue;
            return res;
        }
        for (String dir : Path.getPath()) {
            if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("/msys/1.0") || !dir.contains("/bin")) continue;
            return dir;
        }
        return null;
    }

    private static String getCommandDir(ToolchainManager.ToolchainDescriptor td) {
        if (td != null) {
            String dir = commandsFolders.get(td);
            if (dir == null) {
                String msysBin = ToolUtils.getCommandFolder(td, 3);
                dir = msysBin != null ? msysBin.replace("\\", "/") : "";
                commandsFolders.put(td, dir);
            }
            if (dir.length() > 0) {
                return dir;
            }
        }
        return null;
    }

    public static String getPlatformName(int platform) {
        switch (platform) {
            case 2: {
                return "linux";
            }
            case 0: {
                return "sun_sparc";
            }
            case 1: {
                return "sun_intel";
            }
            case 3: {
                return "windows";
            }
            case 4: {
                return "mac";
            }
        }
        return "none";
    }

    public static boolean isPlatforSupported(int platform, ToolchainManager.ToolchainDescriptor d) {
        switch (platform) {
            case 0: {
                for (String p : d.getPlatforms()) {
                    if (!"sun_sparc".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 1: {
                for (String p : d.getPlatforms()) {
                    if (!"sun_intel".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 2: {
                for (String p : d.getPlatforms()) {
                    if (!"linux".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 3: {
                for (String p : d.getPlatforms()) {
                    if (!"windows".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                for (String p : d.getPlatforms()) {
                    if (!"mac".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 5: {
                for (String p : d.getPlatforms()) {
                    if (!"unix".equals(p)) continue;
                    return true;
                }
                break;
            }
            case 6: {
                for (String p : d.getPlatforms()) {
                    if (!"none".equals(p)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static int computeLocalPlatform() {
        String os = System.getProperty("os.name");
        if (os.equals("SunOS")) {
            return System.getProperty("os.arch").equals("x86") ? 1 : 0;
        }
        if (os.startsWith("Windows ")) {
            return 3;
        }
        if (os.toLowerCase().contains("linux")) {
            return 2;
        }
        if (os.toLowerCase().contains("mac") || os.startsWith("Darwin")) {
            return 4;
        }
        return 5;
    }

    public static String findCommand(String name) {
        String dir;
        String path = Path.findCommand((String)name);
        if (path == null && (dir = ToolUtils.getCommandFolder(null)) != null) {
            path = ToolUtils.findCommand(name, dir);
        }
        return path;
    }

    public static String findCommand(String cmd, String dir) {
        String cmd2 = null;
        if (cmd.length() > 0) {
            File file2;
            File file;
            if (Utilities.isWindows() && !cmd.endsWith(".exe")) {
                cmd2 = cmd + ".exe";
            }
            if ((file = new File(dir, cmd)).exists()) {
                return file.getAbsolutePath();
            }
            if (Utilities.isWindows() && cmd.endsWith(".exe") && (file2 = new File(dir, cmd + ".lnk")).exists()) {
                return file.getAbsolutePath();
            }
            if (cmd2 != null) {
                file = new File(dir, cmd2);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                file2 = new File(dir, cmd2 + ".lnk");
                if (file2.exists()) {
                    return file.getAbsolutePath();
                }
            }
        }
        return null;
    }

    public static String getBaseName(String path) {
        int sep = path.lastIndexOf(47);
        if (sep == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(sep + 1);
        }
        return path;
    }

    public static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) > 0;
    }

    public static String replaceOddCharacters(String s, char replaceChar) {
        int n = s.length();
        StringBuilder ret = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t' || c == ':' || c == '\'' || c == '*' || c == '\"' || c == '[' || c == ']' || c == '(' || c == ')') {
                ret.append(replaceChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getDirName(String path) {
        int sep = path.lastIndexOf(47);
        if (sep == -1) {
            sep = path.lastIndexOf(92);
        }
        if (sep != -1) {
            return path.substring(0, sep);
        }
        return null;
    }

    public String getPathName(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment.isLocal() && Utilities.isWindows()) {
            HostInfoProvider.getEnv((ExecutionEnvironment)executionEnvironment);
            for (String key : HostInfoProvider.getEnv((ExecutionEnvironment)executionEnvironment).keySet()) {
                if (!key.toLowerCase().equals("path")) continue;
                return key.substring(0, 4);
            }
        }
        return "PATH";
    }

    public static boolean isMyFolder(String path, ToolchainManager.ToolchainDescriptor d, int platform, boolean known) {
        boolean res = ToolUtils.isMyFolderImpl(path, d, platform, known);
        if (ToolchainManagerImpl.TRACE && res) {
            System.err.println("Path [" + path + "] belongs to tool chain " + d.getName());
        }
        return res;
    }

    private static boolean isMyFolderImpl(String path, ToolchainManager.ToolchainDescriptor d, int platform, boolean known) {
        File file;
        ToolchainManager.CompilerDescriptor c = d.getC();
        if (c == null || c.getNames().length == 0) {
            return false;
        }
        Pattern pattern = null;
        if (!known) {
            if (c.getPathPattern() != null) {
                pattern = platform == 3 ? Pattern.compile(c.getPathPattern(), 2) : Pattern.compile(c.getPathPattern());
            }
            if (pattern != null && !pattern.matcher(path).find()) {
                String f = c.getExistFolder();
                if (f == null) {
                    return false;
                }
                File folder = new File(path + "/" + f);
                if (!folder.exists() || !folder.isDirectory()) {
                    return false;
                }
            }
        }
        if (!((file = new File(path + "/" + c.getNames()[0])).exists() || (file = new File(path + "/" + c.getNames()[0] + ".exe")).exists() || (file = new File(path + "/" + c.getNames()[0] + ".exe.lnk")).exists())) {
            return false;
        }
        String flag = c.getVersionFlags();
        if (flag == null) {
            return true;
        }
        if (c.getVersionPattern() == null) {
            return true;
        }
        pattern = Pattern.compile(c.getVersionPattern());
        String command = LinkSupport.resolveWindowsLink((String)file.getAbsolutePath());
        String s = ToolUtils.getCommandOutput(path, command, flag);
        boolean res = pattern.matcher(s).find();
        if (ToolchainManagerImpl.TRACE && !res) {
            System.err.println("No match for pattern [" + c.getVersionPattern() + "]:");
            System.err.println("Run " + path + "/" + c.getNames()[0] + " " + flag + "\n" + s);
        }
        return res;
    }

    public static String getBaseFolder(ToolchainManager.ToolchainDescriptor d, int platform) {
        if (platform != 3) {
            return null;
        }
        List<ToolchainManager.BaseFolder> list = d.getBaseFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ToolchainManager.BaseFolder folder : list) {
            String base;
            String pattern = folder.getFolderPattern();
            String key = folder.getFolderKey();
            if (key == null || pattern == null || (base = ToolUtils.readRegistry(key, pattern)) == null) continue;
            if (folder.getFolderSuffix() != null) {
                base = base + "/" + folder.getFolderSuffix();
            }
            return base;
        }
        return null;
    }

    public static String getCommandFolder(ToolchainManager.ToolchainDescriptor d, int platform) {
        String pattern;
        if (platform != 3) {
            return null;
        }
        List<ToolchainManager.BaseFolder> list = d.getCommandFolders();
        if (list == null || list.isEmpty()) {
            return null;
        }
        String base = null;
        for (ToolchainManager.BaseFolder folder : list) {
            pattern = folder.getFolderPattern();
            String key = folder.getFolderKey();
            if (key == null || pattern == null) continue;
            base = ToolUtils.readRegistry(key, pattern);
            if (base != null && folder.getFolderSuffix() != null) {
                base = base + "\\" + folder.getFolderSuffix();
            }
            if (base == null) continue;
            return base;
        }
        for (ToolchainManager.BaseFolder folder : list) {
            pattern = folder.getFolderPathPattern();
            if (pattern == null || pattern.length() <= 0) continue;
            Pattern p = Pattern.compile(pattern);
            for (String dir : Path.getPath()) {
                if (!p.matcher(dir).find()) continue;
                return dir;
            }
        }
        return null;
    }

    private static String readRegistry(String key, String pattern) {
        if (ToolchainManagerImpl.TRACE) {
            System.err.println("Read registry " + key);
        }
        String base = null;
        String res = ToolUtils.getRegistry(key);
        if (res != null) {
            Pattern p = Pattern.compile(pattern);
            StringTokenizer st = new StringTokenizer(res, "\n");
            while (st.hasMoreTokens()) {
                Matcher m;
                String line = st.nextToken().trim();
                if (ToolchainManagerImpl.TRACE) {
                    System.err.println("\t" + line);
                }
                if (!(m = p.matcher(line)).find() || m.groupCount() != 1) continue;
                base = m.group(1).trim();
                if (!ToolchainManagerImpl.TRACE) continue;
                System.err.println("\tFound " + base);
            }
        }
        if (base == null && key.toLowerCase().startsWith("hklm\\")) {
            base = ToolUtils.readRegistry("hkcu\\" + key.substring(5), pattern);
        }
        return base;
    }

    private static String getCommandOutput(String path, String command, String flags) {
        String res = commandCache.get(command + " " + flags);
        if (res != null) {
            return res;
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(flags, " ");
        while (st.hasMoreTokens()) {
            args.add(st.nextToken());
        }
        if (path == null) {
            path = "";
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)path, (ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)command, (String[])args.toArray(new String[args.size()]));
        StringBuilder buf = new StringBuilder();
        if (status.output != null) {
            buf.append(status.output);
        }
        buf.append('\n');
        if (status.error != null) {
            buf.append(status.error);
        }
        commandCache.put(command + " " + flags, buf.toString());
        return buf.toString();
    }

    private static String getRegistry(String key) {
        String res = commandCache.get("reg " + key);
        if (res != null) {
            return res;
        }
        String reg_exe = "reg.exe";
        try {
            String windir = System.getenv("WINDIR");
            if (windir != null) {
                File sys32 = new File(windir, "System32");
                reg_exe = new File(sys32, "reg.exe").getPath();
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeWithoutMacroExpansion(null, (ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)reg_exe, (String[])new String[]{"query", key, "/s"});
        res = status.output != null ? status.output.toString() : "";
        commandCache.put("reg " + key, res);
        return res;
    }

    static {
        commandsFolders = new HashMap<ToolchainManager.ToolchainDescriptor, String>(8);
        commandCache = new WeakHashMap();
    }
}

