/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.compilerset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;

public final class CompilerFlavorImpl
extends CompilerFlavor {
    private static final List<CompilerFlavorImpl> flavors = new ArrayList<CompilerFlavorImpl>();
    private static final Map<Integer, CompilerFlavorImpl> unknown = new HashMap<Integer, CompilerFlavorImpl>();
    private String sval;
    private ToolchainManager.ToolchainDescriptor descriptor;

    CompilerFlavorImpl(String sval, ToolchainManager.ToolchainDescriptor descriptor) {
        this.sval = sval;
        this.descriptor = descriptor;
    }

    @Override
    public ToolchainManager.ToolchainDescriptor getToolchainDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isGnuCompiler() {
        ToolchainManager.ToolchainDescriptor d = this.getToolchainDescriptor();
        if (d != null) {
            for (String f : d.getFamily()) {
                if (!"GNU".equals(f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSunStudioCompiler() {
        ToolchainManager.ToolchainDescriptor d = this.getToolchainDescriptor();
        if (d != null) {
            for (String f : d.getFamily()) {
                if (!"SunStudio".equals(f)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isMinGWCompiler() {
        return "MinGW".equals(this.sval);
    }

    @Override
    public boolean isCygwinCompiler() {
        return "Cygwin".equals(this.sval) || "Cygwin_4.x".equals(this.sval);
    }

    @Override
    public String getCommandFolder(int platform) {
        ToolchainManager.ToolchainDescriptor d = this.getToolchainDescriptor();
        if (d != null) {
            return ToolUtils.getCommandFolder(d, platform);
        }
        return null;
    }

    public static CompilerFlavor getUnknown(int platform) {
        CompilerFlavor unknownFlavor = unknown.get(platform);
        if (unknownFlavor == null) {
            unknownFlavor = CompilerFlavorImpl._getUnknown(platform);
        }
        return unknownFlavor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerFlavor _getUnknown(int platform) {
        CompilerFlavorImpl unknownFlavor = null;
        Map<Integer, CompilerFlavorImpl> map = unknown;
        synchronized (map) {
            unknownFlavor = unknown.get(platform);
            if (unknownFlavor == null) {
                List<ToolchainManager.ToolchainDescriptor> list;
                ToolchainManager.ToolchainDescriptor d = ToolchainManagerImpl.getImpl().getToolchain("GNU", platform);
                if (d == null && (list = ToolchainManagerImpl.getImpl().getToolchains(platform)).size() > 0) {
                    d = list.get(0);
                }
                if (d == null) {
                    d = new CompilerSetImpl.UnknownToolchainDescriptor();
                }
                unknownFlavor = new CompilerFlavorImpl("Unknown", d);
                unknown.put(platform, unknownFlavor);
            }
        }
        return unknownFlavor;
    }

    public static CompilerFlavor toFlavor(String name, int platform) {
        if ("Unknown".equals(name)) {
            return CompilerFlavorImpl.getUnknown(platform);
        }
        for (CompilerFlavorImpl flavor : flavors) {
            if (!name.equals(flavor.sval) || !ToolUtils.isPlatforSupported(platform, flavor.getToolchainDescriptor())) continue;
            return flavor;
        }
        return null;
    }

    public static String mapOldToNew(String flavor, int version) {
        if (version <= 43) {
            if (flavor.equals("Sun")) {
                return "SunStudio";
            }
            if (flavor.equals("SunExpress")) {
                return "SunStudioExpress";
            }
            if (flavor.equals("Sun12")) {
                return "SunStudio_12";
            }
            if (flavor.equals("Sun11")) {
                return "SunStudio_11";
            }
            if (flavor.equals("Sun10")) {
                return "SunStudio_10";
            }
            if (flavor.equals("Sun9")) {
                return "SunStudio_9";
            }
            if (flavor.equals("Sun8")) {
                return "SunStudio_8";
            }
            if (flavor.equals("DJGPP")) {
                return "GNU";
            }
            if (flavor.equals("Interix")) {
                return "GNU";
            }
            if (flavor.equals("Unknown")) {
                return "GNU";
            }
        }
        return flavor;
    }

    private static boolean isPlatforSupported(CompilerFlavor flavor, int platform) {
        ToolchainManager.ToolchainDescriptor d = flavor.getToolchainDescriptor();
        if (d != null) {
            return ToolUtils.isPlatforSupported(platform, d);
        }
        return true;
    }

    public static List<CompilerFlavor> getFlavors(int platform) {
        ArrayList<CompilerFlavor> list = new ArrayList<CompilerFlavor>();
        for (CompilerFlavorImpl flavor : flavors) {
            if (!CompilerFlavorImpl.isPlatforSupported(flavor, platform)) continue;
            list.add(flavor);
        }
        return list;
    }

    public String toString() {
        return this.sval;
    }

    static {
        for (ToolchainManager.ToolchainDescriptor descriptor : ToolchainManagerImpl.getImpl().getAllToolchains()) {
            flavors.add(new CompilerFlavorImpl(descriptor.getName(), descriptor));
        }
    }
}

