/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolchainManagerImpl;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.openide.util.Utilities;

public final class CompilerSetUtils {
    private static String cygwinBase;
    private static Map<ToolchainManager.ToolchainDescriptor, String> commandsFolders;

    private CompilerSetUtils() {
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            String cygwinBin;
            ToolchainManagerImpl tcm = ToolchainManagerImpl.getImpl();
            ToolchainManager.ToolchainDescriptor td = tcm.getToolchain("Cygwin", 3);
            if (td != null && (cygwinBin = ToolUtils.getBaseFolder(td, 3)) != null) {
                cygwinBase = cygwinBin.substring(0, cygwinBin.length() - 4).replace("\\", "/");
            }
            if (cygwinBase == null) {
                for (String dir : Path.getPath()) {
                    if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("cygwin")) continue;
                    if (dir.endsWith("/")) {
                        dir = dir.substring(0, dir.length() - 1);
                    }
                    if (dir.toLowerCase().endsWith("/usr/bin")) {
                        cygwinBase = dir.substring(0, dir.length() - 8);
                        break;
                    }
                    if (!dir.toLowerCase().endsWith("/bin")) continue;
                    cygwinBase = dir.substring(0, dir.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getCommandFolder(ToolchainManager.ToolchainDescriptor descriptor) {
        if (!Utilities.isWindows()) {
            return null;
        }
        String res = CompilerSetUtils.getCommandDir(descriptor);
        if (res != null) {
            return res;
        }
        ToolchainManagerImpl tcm = ToolchainManagerImpl.getImpl();
        for (ToolchainManager.ToolchainDescriptor td : tcm.getToolchains(3)) {
            if (td == null || (res = CompilerSetUtils.getCommandDir(td)) == null) continue;
            return res;
        }
        for (String dir : Path.getPath()) {
            if (!(dir = dir.toLowerCase().replace("\\", "/")).contains("/msys/1.0") || !dir.contains("/bin")) continue;
            return dir;
        }
        return null;
    }

    private static String getCommandDir(ToolchainManager.ToolchainDescriptor td) {
        if (td != null) {
            String dir = commandsFolders.get(td);
            if (dir == null) {
                String msysBin = ToolUtils.getCommandFolder(td, 3);
                dir = msysBin != null ? msysBin.replace("\\", "/") : "";
                commandsFolders.put(td, dir);
            }
            if (dir.length() > 0) {
                return dir;
            }
        }
        return null;
    }

    static {
        commandsFolders = new HashMap<ToolchainManager.ToolchainDescriptor, String>(8);
    }
}

