/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.clientproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.j2ee.common.FileSearchUtility;
import org.netbeans.modules.java.api.common.project.ui.wizards.FolderList;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PanelSourceFolders
extends SettingsPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private final Panel firer;
    private WizardDescriptor wizardDescriptor;
    private File oldProjectLocation;
    private final DocumentListener configFilesDocumentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.configFilesChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.configFilesChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            PanelSourceFolders.this.configFilesChanged();
        }
    };
    private JButton jButtonConfigFilesLocation;
    private JButton jButtonLibraries;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextFieldConfigFiles;
    private JTextField jTextFieldLibraries;
    private JPanel sourcePanel;
    private JPanel testsPanel;

    public PanelSourceFolders(Panel panel) {
        this.firer = panel;
        this.initComponents();
        this.setName(NbBundle.getMessage(PanelSourceFolders.class, (String)"LAB_ConfigureSourceRoots"));
        this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_ImportAppClientModule"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"AN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_PanelSourceFolders"));
        this.sourcePanel.addPropertyChangeListener(this);
        this.testsPanel.addPropertyChangeListener(this);
        ((FolderList)this.sourcePanel).setRelatedFolderList((FolderList)this.testsPanel, FolderList.testRootsFilter());
        ((FolderList)this.testsPanel).setRelatedFolderList((FolderList)this.sourcePanel);
        this.jTextFieldConfigFiles.getDocument().addDocumentListener(this.configFilesDocumentListener);
    }

    public void initValues(FileObject fileObject) {
        Object object;
        ((FolderList)this.sourcePanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        ((FolderList)this.testsPanel).setLastUsedDir(FileUtil.toFile((FileObject)fileObject));
        FileObject fileObject2 = FileSearchUtility.guessConfigFilesPath((FileObject)fileObject, (String)"application-client.xml");
        if (fileObject2 != null) {
            object = FileUtil.toFile((FileObject)fileObject2).getAbsolutePath();
            this.jTextFieldConfigFiles.setText((String)object);
        }
        object = FileSearchUtility.guessLibrariesFolder((FileObject)fileObject);
        if (object != null) {
            String string = FileUtil.toFile((FileObject)object).getAbsolutePath();
            this.jTextFieldLibraries.setText(string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("files".equals(propertyChangeEvent.getPropertyName())) {
            this.dataChanged();
        } else if ("lastUsedDir".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getSource() == this.sourcePanel) {
                ((FolderList)this.testsPanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getSource() == this.testsPanel) {
                ((FolderList)this.sourcePanel).setLastUsedDir((File)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void dataChanged() {
        this.firer.fireChangeEvent();
    }

    @Override
    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        File file = (File)wizardDescriptor.getProperty("sourceRoot");
        ((FolderList)this.sourcePanel).setProjectFolder(file);
        ((FolderList)this.testsPanel).setProjectFolder(file);
        if (!file.equals(this.oldProjectLocation)) {
            File[] fileArray;
            File[] fileArray2 = (File[])wizardDescriptor.getProperty("javaRoot");
            if (fileArray2 != null) {
                ((FolderList)this.sourcePanel).setFiles(fileArray2);
            }
            if ((fileArray = (File[])wizardDescriptor.getProperty("testRoot")) != null) {
                ((FolderList)this.testsPanel).setFiles(fileArray);
            }
            this.initValues(FileUtil.toFileObject((File)file));
            this.oldProjectLocation = file;
        }
    }

    @Override
    void store(WizardDescriptor wizardDescriptor) {
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        wizardDescriptor.putProperty("javaRoot", (Object)fileArray);
        wizardDescriptor.putProperty("testRoot", (Object)fileArray2);
        String string = this.jTextFieldConfigFiles.getText().trim();
        if (string.length() > 0) {
            wizardDescriptor.putProperty("configFilesFolder", (Object)new File(string));
        } else {
            wizardDescriptor.putProperty("configFilesFolder", null);
        }
        String string2 = this.jTextFieldLibraries.getText().trim();
        if (string2 != null && !string2.equals("")) {
            wizardDescriptor.putProperty("libFolder", (Object)new File(string2));
        }
    }

    @Override
    boolean valid(WizardDescriptor wizardDescriptor) {
        File file = (File)wizardDescriptor.getProperty("projdir");
        String string = this.jTextFieldConfigFiles.getText().trim();
        if (string.length() == 0) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_BlankConfigurationFilesFolder"));
            return false;
        }
        File[] fileArray = ((FolderList)this.sourcePanel).getFiles();
        File[] fileArray2 = ((FolderList)this.testsPanel).getFiles();
        String string2 = PanelSourceFolders.checkValidity(file, this.getConfigFiles(), fileArray, fileArray2);
        if (string2 == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
            return true;
        }
        this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)string2);
        return false;
    }

    static String checkValidity(File file, File file2, File[] fileArray, File[] fileArray2) {
        String string;
        int n;
        FileObject fileObject;
        String string2 = file.getAbsolutePath();
        if (!(file2 == null || (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file2))) != null && fileObject.isFolder())) {
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalConfigurationFilesFolder");
        }
        if (fileArray.length == 0) {
            return " ";
        }
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory() || !fileArray[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalSources"), fileArray[n].getAbsolutePath());
            }
            string = fileArray[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        for (n = 0; n < fileArray2.length; ++n) {
            if (!fileArray2[n].isDirectory() || !fileArray2[n].canRead()) {
                return MessageFormat.format(NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalTests"), fileArray[n].getAbsolutePath());
            }
            string = fileArray2[n].getAbsolutePath();
            if (!string2.equals(string) && !string2.startsWith(string + File.separatorChar)) continue;
            return NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_IllegalProjectFolder");
        }
        return null;
    }

    @Override
    void validate(WizardDescriptor wizardDescriptor) throws WizardValidationException {
        this.searchClassFiles(((FolderList)this.sourcePanel).getFiles());
    }

    private void searchClassFiles(File[] fileArray) throws WizardValidationException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        for (int i = 0; i < fileArray.length; ++i) {
            object4 = FileUtil.toFileObject((File)fileArray[i]);
            if (object4 == null) continue;
            object3 = object4.getData(true);
            while (!bl && object3.hasMoreElements()) {
                object2 = object3.nextElement();
                assert (object2 instanceof FileObject) : "Instance of FileObject: " + object2;
                object = (FileObject)object2;
                bl = "class".equals(object.getExt());
            }
        }
        if (bl) {
            String string = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_DeleteOption");
            object4 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_KeepOption");
            object3 = NbBundle.getMessage(PanelSourceFolders.class, (String)"TXT_CancelOption");
            object2 = new NotifyDescriptor((Object)NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MSG_FoundClassFiles_Title"), 1, 3, new Object[]{string, object4, object3}, null);
            object = DialogDisplayer.getDefault().notify(object2);
            if (string.equals(object)) {
                this.deleteClassFiles(fileArray);
            } else if (!object4.equals(object)) {
                throw new WizardValidationException((JComponent)this.sourcePanel, "", "");
            }
        }
    }

    private void deleteClassFiles(File[] fileArray) {
        for (int i = 0; i < fileArray.length; ++i) {
            FileObject fileObject = FileUtil.toFileObject((File)fileArray[i]);
            Enumeration enumeration = fileObject.getData(true);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                assert (e instanceof FileObject) : "Instance of FileObject: " + e;
                FileObject fileObject2 = (FileObject)e;
                try {
                    if (!"class".equals(fileObject2.getExt())) continue;
                    fileObject2.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private void initComponents() {
        this.jLabel3 = new JLabel();
        this.sourcePanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_SourceRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_SourceRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddSourceRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddSourceFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveSourceFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveSourceFolder"));
        this.testsPanel = new FolderList(NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_TestRoots").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_TestRoots"), NbBundle.getMessage(PanelSourceFolders.class, (String)"CTL_AddTestRoot"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_AddTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_AddTestFolder"), NbBundle.getMessage(PanelSourceFolders.class, (String)"MNE_RemoveTestFolder").charAt(0), NbBundle.getMessage(PanelSourceFolders.class, (String)"AD_RemoveTestFolder"));
        this.jLabel1 = new JLabel();
        this.jTextFieldConfigFiles = new JTextField();
        this.jButtonConfigFilesLocation = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldLibraries = new JTextField();
        this.jButtonLibraries = new JButton();
        this.jLabel4 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(PanelSourceFolders.class, (String)"LBL_SourceDirectoriesLabel"));
        this.jLabel1.setLabelFor(this.jTextFieldConfigFiles);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/clientproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)resourceBundle.getString("LBL_IW_ConfigFilesFolder_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonConfigFilesLocation, (String)resourceBundle.getString("LBL_NWP1_BrowseLocation_Button_w"));
        this.jButtonConfigFilesLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonConfigFilesLocationActionPerformed(actionEvent);
            }
        });
        this.jLabel2.setLabelFor(this.jTextFieldLibraries);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)resourceBundle.getString("LBL_IW_LibrariesLocation_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonLibraries, (String)resourceBundle.getString("LBL_NWP1_BrowseLocation_Button"));
        this.jButtonLibraries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelSourceFolders.this.jButtonLibrariesActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)resourceBundle.getString("LBL_IW_DragAndDrop"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jTextFieldLibraries, -1, 242, Short.MAX_VALUE).add(2, (Component)this.jTextFieldConfigFiles, -1, 242, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.jButtonConfigFilesLocation).add(2, (Component)this.jButtonLibraries))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.sourcePanel, -1, 482, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.testsPanel, -1, 482, Short.MAX_VALUE).addContainerGap()).add((Component)this.jLabel3, -1, 494, Short.MAX_VALUE).add((Component)this.jLabel4, -1, 494, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldConfigFiles, -2, -1, -2).add((Component)this.jButtonConfigFilesLocation)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jTextFieldLibraries, -2, -1, -2).add((Component)this.jButtonLibraries)).addPreferredGap(1).add((Component)this.sourcePanel, -1, 92, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.testsPanel, -1, 93, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel4, -2, -1, -2)));
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSN_jLabel3"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelSourceFolders.class).getString("ACSD_jLabel3"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSN_PanelSourceFolders"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelSourceFolders.class, (String)"ACSD_PanelSourceFolders"));
    }

    private void jButtonLibrariesActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldLibraries.getText().length() > 0 && this.getLibraries().exists()) {
            jFileChooser.setSelectedFile(this.getLibraries());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldLibraries.setText(file.getAbsolutePath());
        }
    }

    private void jButtonConfigFilesLocationActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(1);
        if (this.jTextFieldConfigFiles.getText().length() > 0 && this.getConfigFiles().exists()) {
            jFileChooser.setSelectedFile(this.getConfigFiles());
        } else {
            jFileChooser.setCurrentDirectory((File)this.wizardDescriptor.getProperty("projdir"));
        }
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.jTextFieldConfigFiles.setText(file.getAbsolutePath());
        }
    }

    private File getAsFile(String string) {
        return FileUtil.normalizeFile((File)new File(string));
    }

    public File getConfigFiles() {
        return this.getAsFile(this.jTextFieldConfigFiles.getText());
    }

    public File getLibraries() {
        return this.getAsFile(this.jTextFieldLibraries.getText());
    }

    private void configFilesChanged() {
        this.dataChanged();
    }

    static class Panel
    implements WizardDescriptor.ValidatingPanel {
        private ArrayList<ChangeListener> listeners;
        private PanelSourceFolders component;
        private WizardDescriptor settings;

        Panel() {
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public void readSettings(Object object) {
            this.settings = (WizardDescriptor)object;
            this.component.read(this.settings);
            Object object2 = this.component.getClientProperty("NewProjectWizard_Title");
            if (object2 != null) {
                this.settings.putProperty("NewProjectWizard_Title", object2);
            }
        }

        public void storeSettings(Object object) {
            this.component.store(this.settings);
        }

        public void validate() throws WizardValidationException {
            this.component.validate(this.settings);
        }

        public boolean isValid() {
            return this.component.valid(this.settings);
        }

        public synchronized Component getComponent() {
            if (this.component == null) {
                this.component = new PanelSourceFolders(this);
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return new HelpCtx(PanelSourceFolders.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChangeEvent() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }
    }
}

