/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.css.visual.model.MarginPaddingModel;
import org.netbeans.modules.css.visual.model.PropertyWithUnitData;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class MarginWidthField
extends JPanel {
    PropertyWithUnitData borderMarginData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private JComboBox borderMarginCombo;
    private JComboBox borderMarginUnitCombo;

    public MarginWidthField() {
        this.initComponents();
        this.borderMarginCombo.setModel(this.marginPaddingModel.getMarginList());
        this.borderMarginUnitCombo.setModel(this.marginPaddingModel.getMarginUnitList());
        final JTextField borderMarginComboEditor = (JTextField)this.borderMarginCombo.getEditor().getEditorComponent();
        borderMarginComboEditor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MarginWidthField.this.borderMarginUnitCombo.setEnabled(Utils.isInteger(borderMarginComboEditor.getText()));
                    }
                });
            }
        });
    }

    public void setMarginString(String marginStr) {
        if (marginStr != null && !marginStr.equals("")) {
            if (Utils.isInteger(marginStr)) {
                this.setMarginValue(marginStr);
            } else {
                String unit = this.getUnit(marginStr);
                this.setMarginUnit(unit);
                this.setMarginValue(marginStr.replaceAll(unit, "").trim());
            }
        } else {
            this.setMarginValue(null);
            this.setMarginUnit(null);
        }
    }

    public String getMarginString() {
        return this.borderMarginData.toString();
    }

    private String getUnit(String positionStr) {
        DefaultComboBoxModel unitList = this.marginPaddingModel.getMarginUnitList();
        for (int i = 0; i < unitList.getSize(); ++i) {
            String unit = (String)unitList.getElementAt(i);
            if (!positionStr.trim().endsWith(unit)) continue;
            return unit;
        }
        return "";
    }

    public void setMarginValue(String value) {
        if (value == null || value.equals("")) {
            this.borderMarginCombo.setSelectedIndex(0);
        } else {
            this.borderMarginCombo.setSelectedItem(value);
            this.borderMarginData.setValue(value);
        }
    }

    public void setMarginUnit(String value) {
        if (value == null || value.equals("")) {
            this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(value) != -1) {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf(value));
            } else {
                this.borderMarginUnitCombo.setSelectedIndex(this.marginPaddingModel.getMarginUnitList().getIndexOf("px"));
            }
            this.borderMarginData.setUnit(value);
        }
    }

    private void initComponents() {
        this.borderMarginCombo = new JComboBox();
        this.borderMarginUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(3, 0));
        this.borderMarginCombo.setEditable(true);
        this.borderMarginCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarginWidthField.this.borderMarginComboActionPerformed(evt);
            }
        });
        this.borderMarginCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MarginWidthField.this.borderMarginComboFocusLost(evt);
            }
        });
        this.borderMarginCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MarginWidthField.this.borderMarginComboItemStateChanged(evt);
            }
        });
        this.add((Component)this.borderMarginCombo, "Center");
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_FIELD_ACCESS_NAME"));
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_FIELD_ACCESS_DESC"));
        this.borderMarginUnitCombo.setEnabled(false);
        this.borderMarginUnitCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                MarginWidthField.this.borderMarginUnitComboItemStateChanged(evt);
            }
        });
        this.borderMarginUnitCombo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                MarginWidthField.this.borderMarginUnitComboFocusLost(evt);
            }
        });
        this.add((Component)this.borderMarginUnitCombo, "East");
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_UNIT_ACCESS_NAME"));
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MarginWidthField.class, (String)"MARGIN_WIDTH_UNIT_ACCESS_DESC"));
    }

    private void borderMarginUnitComboFocusLost(FocusEvent evt) {
        this.setBorderMargin();
    }

    private void borderMarginUnitComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.setBorderMargin();
        }
    }

    public void setAccessibleName(String comboName, String unitName) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleName(comboName);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleName(unitName);
    }

    public void setAccessibleDescription(String comboDesc, String unitDesc) {
        this.borderMarginCombo.getAccessibleContext().setAccessibleDescription(comboDesc);
        this.borderMarginUnitCombo.getAccessibleContext().setAccessibleDescription(unitDesc);
    }

    private void borderMarginComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() != 2) {
            this.borderMarginUnitCombo.setEnabled(Utils.isInteger(this.borderMarginCombo.getSelectedItem().toString()));
            this.setBorderMargin();
        }
    }

    private void borderMarginComboFocusLost(FocusEvent evt) {
        this.setBorderMargin();
    }

    private void borderMarginComboActionPerformed(ActionEvent evt) {
        this.setBorderMargin();
    }

    private void setBorderMargin() {
        String oldValue = this.borderMarginData.toString();
        this.borderMarginData.setUnit(this.borderMarginUnitCombo.getSelectedItem().toString());
        this.borderMarginData.setValue(this.borderMarginCombo.getSelectedItem().toString());
        this.firePropertyChange("margin-width", oldValue, this.borderMarginData.toString());
    }
}

