/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.text.ParseException;
import java.util.Date;
import org.apache.tomcat.util.Ascii;
import org.apache.tomcat.util.DateTool;
import org.apache.tomcat.util.MessageBytes;
import org.apache.tomcat.util.MessageChars;
import org.apache.tomcat.util.MessageString;
import org.apache.tomcat.util.StringManager;

public class MimeHeaderField {
    public static final byte[] charval = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.util");
    protected final MessageBytes nameB = new MessageBytes();
    protected final MessageChars nameC = new MessageChars();
    protected final MessageString name = new MessageString();
    protected final MessageBytes valueB = new MessageBytes();
    protected final MessageChars valueC = new MessageChars();
    protected final MessageString value = new MessageString();
    protected int intValue;
    protected Date dateValue = null;
    protected int type = 0;
    protected int nameType = 0;
    protected static final int T_NULL = 0;
    protected static final int T_STR = 1;
    protected static final int T_INT = 2;
    protected static final int T_DATE = 3;
    protected static final int T_BYTES = 4;
    protected static final int T_CHARS = 5;

    String formatDate(Date value) {
        return DateTool.rfc1123Format.format(value);
    }

    public long getDateValue() throws IllegalArgumentException {
        switch (this.type) {
            case 3: {
                if (this.dateValue == null) break;
                return this.dateValue.getTime();
            }
            case 1: {
                return this.parseDate(this.value);
            }
            case 5: {
                return this.parseDate(this.value.toString());
            }
            case 4: {
                return this.parseDate(this.valueB.toString());
            }
        }
        String msg = sm.getString("mimeHeaderField.date.iae");
        throw new IllegalArgumentException(msg);
    }

    public int getIntValue() throws NumberFormatException {
        switch (this.type) {
            case 2: {
                return this.intValue;
            }
            case 1: {
                return this.value.toInteger();
            }
            case 5: {
                return this.valueC.toInteger();
            }
            case 4: {
                return this.valueB.toInteger();
            }
        }
        String msg = sm.getString("mimeHeaderField.int.nfe");
        throw new NumberFormatException(msg);
    }

    public String getName() {
        switch (this.nameType) {
            case 1: {
                return this.name.toString();
            }
            case 5: {
                return this.nameC.toString();
            }
            case 4: {
                return this.nameB.toString();
            }
        }
        return null;
    }

    public MessageBytes getNameBytes() {
        return this.nameB;
    }

    public MessageChars getNameChars() {
        return this.nameC;
    }

    public int getNameType() {
        return this.nameType;
    }

    public String getValue() {
        switch (this.type) {
            case 1: {
                return this.value.toString();
            }
            case 2: {
                return String.valueOf(this.intValue);
            }
            case 3: {
                return this.formatDate(this.dateValue);
            }
            case 5: {
                return this.valueC.toString();
            }
            case 4: {
                return this.valueB.toString();
            }
        }
        return null;
    }

    public MessageBytes getValueBytes() {
        return this.valueB;
    }

    public MessageChars getValueChars() {
        return this.valueC;
    }

    public int getValueType() {
        return this.type;
    }

    public boolean nameEquals(String s) {
        switch (this.nameType) {
            case 1: {
                return this.name.equalsIgnoreCase(s);
            }
            case 5: {
                return this.nameC.equalsIgnoreCase(s);
            }
            case 4: {
                return Ascii.equalsIgnoreCase(s, this.nameB);
            }
        }
        return false;
    }

    long parseDate(String s) {
        this.value.setString(s);
        return this.parseDate(this.value);
    }

    long parseDate(MessageString value) {
        String dateString = value.toString();
        Date date = null;
        try {
            date = DateTool.rfc1123Format.parse(dateString);
            return date.getTime();
        }
        catch (ParseException parseException) {
            try {
                date = DateTool.rfc1036Format.parse(dateString);
                return date.getTime();
            }
            catch (ParseException parseException2) {
                try {
                    date = DateTool.asctimeFormat.parse(dateString);
                    return date.getTime();
                }
                catch (ParseException parseException3) {
                    String msg = sm.getString("httpDate.pe", dateString);
                    throw new IllegalArgumentException(msg);
                }
            }
        }
    }

    public void reset() {
        this.name.reset();
        this.value.reset();
        this.nameB.reset();
        this.valueB.reset();
        this.nameC.reset();
        this.valueC.reset();
        this.type = 0;
        this.nameType = 0;
    }

    public void setDateValue(long t) {
        if (this.dateValue == null) {
            this.dateValue = new Date(t);
        } else {
            this.dateValue.setTime(t);
        }
        this.type = 3;
    }

    public void setIntValue(int i) {
        this.intValue = i;
        this.type = 2;
    }

    public void setName(String s) {
        this.nameType = 1;
        this.name.setString(s);
    }

    public void setName(byte[] b, int off, int len) {
        this.nameType = 4;
        this.nameB.setBytes(b, off, len);
    }

    public void setName(char[] c, int off, int len) {
        this.nameType = 5;
        this.nameC.setChars(c, off, len);
    }

    public void setValue(String s) {
        this.value.setString(s);
        this.type = 1;
    }

    public void setValue(byte[] b, int off, int len) {
        this.valueB.setBytes(b, off, len);
        this.type = 4;
    }

    public void setValue(char[] b, int off, int len) {
        this.valueC.setChars(b, off, len);
        this.type = 5;
    }
}

