/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import org.apache.tomcat.logging.LogDaemon;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.util.Queue;

public class TomcatLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;

    public TomcatLogger() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            logDaemon = new LogDaemon(logQueue);
            logDaemon.start();
        }
    }

    public void flush() {
        logDaemon.flush();
    }

    protected void realLog(String message) {
        logQueue.put(new LogEntry(message, null));
    }

    protected void realLog(String message, Throwable t) {
        logQueue.put(new LogEntry(message, t));
    }

    public static String throwableToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        if (t != null) {
            Throwable cause;
            t.printStackTrace(w);
            if (t instanceof ServletException && (cause = ((ServletException)t).getRootCause()) != null) {
                String rootmsg = "Root cause:";
                w.println(rootmsg);
                cause.printStackTrace(w);
            }
        }
        w.flush();
        return sw.toString();
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String message, Throwable t) {
            if (TomcatLogger.this.timestamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = message;
            this.t = t;
        }

        Writer getWriter() {
            return TomcatLogger.this.sink;
        }

        public String toString() {
            StringBuffer val = new StringBuffer();
            if (!TomcatLogger.this.custom) {
                val.append("<");
                val.append(TomcatLogger.this.getName());
                val.append("> ");
            }
            if (TomcatLogger.this.timestamp) {
                TomcatLogger.this.formatTimestamp(this.date, val);
                val.append(" - ");
            }
            if (this.message != null) {
                val.append(this.message);
            }
            if (this.t != null) {
                val.append(" - ");
                val.append(TomcatLogger.throwableToString(this.t));
            }
            if (!TomcatLogger.this.custom) {
                val.append("</");
                val.append(TomcatLogger.this.getName());
                val.append("> ");
            }
            return val.toString();
        }
    }
}

