/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.gsf.codecoverage.api.CoverageActionFactory;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.php.spi.actions.RunCommandAction;
import org.netbeans.modules.php.spi.phpmodule.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.phpmodule.PhpModuleActionsExtender;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.actions.FindAction;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class PhpLogicalViewProvider
implements LogicalViewProvider {
    private static final Logger LOGGER = Logger.getLogger(PhpLogicalViewProvider.class.getName());
    final PhpProject project;

    public PhpLogicalViewProvider(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public Node createLogicalView() {
        return new PhpLogicalViewRootNode(this.project);
    }

    public Node findPath(Node root, Object target) {
        Node[] children;
        Project p = (Project)root.getLookup().lookup(Project.class);
        if (p == null) {
            return null;
        }
        for (Node node : children = root.getChildren().getNodes(true)) {
            DataObject d;
            if (!(target instanceof DataObject) && !(target instanceof FileObject) || (d = (DataObject)node.getLookup().lookup(DataObject.class)) == null) continue;
            FileObject kidFO = d.getPrimaryFile();
            FileObject targetFO = null;
            targetFO = target instanceof DataObject ? ((DataObject)target).getPrimaryFile() : (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)targetFO);
            if (!p.equals(owner)) {
                return null;
            }
            if (kidFO == targetFO) {
                return node;
            }
            if (!FileUtil.isParentOf((FileObject)kidFO, (FileObject)targetFO)) continue;
            String relPath = FileUtil.getRelativePath((FileObject)kidFO, (FileObject)targetFO);
            String[] path = relPath.split("/");
            path[path.length - 1] = targetFO.getName();
            Node found = this.findNode(node, path);
            if (found == null) {
                path[path.length - 1] = targetFO.getNameExt();
                found = this.findNode(node, path);
            }
            if (found == null) continue;
            if (this.hasObject(found, target)) {
                return found;
            }
            Node parent = found.getParentNode();
            Children kids = parent.getChildren();
            for (Node child : children = kids.getNodes()) {
                if (!this.hasObject(child, target)) continue;
                return child;
            }
        }
        return null;
    }

    private Node findNode(Node start, String[] path) {
        Node found = null;
        try {
            found = NodeOp.findPath((Node)start, (String[])path);
        }
        catch (NodeNotFoundException ex) {
            // empty catch block
        }
        return found;
    }

    private boolean hasObject(Node node, Object obj) {
        if (obj == null) {
            return false;
        }
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        if (dataObject == null) {
            return false;
        }
        if (obj instanceof DataObject) {
            if (dataObject.equals(obj)) {
                return true;
            }
            FileObject fileObject = ((DataObject)obj).getPrimaryFile();
            return this.hasObject(node, fileObject);
        }
        if (obj instanceof FileObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            return obj.equals(fileObject);
        }
        return false;
    }

    static final class CustomizeProjectAction
    extends AbstractAction {
        private static final long serialVersionUID = 423217315757925129L;
        private final PhpProject project;
        private final String category;

        CustomizeProjectAction(PhpProject project, String category) {
            super(NbBundle.getMessage(PhpLogicalViewProvider.class, (String)"LBL_Customize"));
            assert (project != null);
            assert (category != null);
            this.project = project;
            this.category = category;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((CustomizerProviderImpl)this.project.getLookup().lookup(CustomizerProviderImpl.class)).showCustomizer(this.category);
        }
    }

    private static class PhpLogicalViewRootNode
    extends AbstractNode {
        PhpProject project;

        public String getShortDescription() {
            String prjDirDispName = FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory());
            return NbBundle.getMessage(PhpLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }

        public Action[] getActions(boolean context) {
            PhpActionProvider provider = (PhpActionProvider)this.project.getLookup().lookup(PhpActionProvider.class);
            assert (provider != null);
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(CommonProjectActions.newFileAction());
            actions.add(null);
            actions.add(provider.getAction("run"));
            actions.add(provider.getAction("debug"));
            actions.add(provider.getAction("test"));
            actions.add(null);
            if (PhpUnit.hasValidVersion(CommandUtils.getPhpUnit(false))) {
                actions.add(CoverageActionFactory.createCollectorAction(null, null));
                actions.add(null);
            }
            actions.add(CommonProjectActions.setProjectConfigurationAction());
            actions.add(null);
            actions.add(CommonProjectActions.setAsMainProjectAction());
            actions.add(CommonProjectActions.closeProjectAction());
            actions.add(null);
            actions.add(CommonProjectActions.renameProjectAction());
            actions.add(CommonProjectActions.moveProjectAction());
            actions.add(CommonProjectActions.copyProjectAction());
            actions.add(CommonProjectActions.deleteProjectAction());
            actions.add(null);
            actions.add((Action)SystemAction.get(FindAction.class));
            PhpModule phpModule = this.project.getPhpModule();
            for (PhpFrameworkProvider frameworkProvider : this.project.getFrameworks()) {
                PhpModuleActionsExtender actionsExtender = frameworkProvider.getActionsExtender(phpModule);
                if (actionsExtender == null) continue;
                RunCommandAction runCommandAction = actionsExtender.getRunCommandAction();
                List frameworkActions = actionsExtender.getActions();
                if (runCommandAction == null && frameworkActions.isEmpty()) continue;
                ArrayList<RunCommandAction> allActions = new ArrayList<RunCommandAction>(frameworkActions.size() + 2);
                if (runCommandAction != null) {
                    allActions.add(runCommandAction);
                    if (!frameworkActions.isEmpty()) {
                        allActions.add(null);
                    }
                }
                allActions.addAll(frameworkActions);
                actions.add(new FrameworkMenu(actionsExtender.getMenuName(), allActions));
            }
            actions.add(null);
            actions.addAll(Utilities.actionsForPath((String)"Projects/Actions"));
            actions.add(null);
            actions.add(CommonProjectActions.customizeProjectAction());
            return actions.toArray(new Action[actions.size()]);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(PhpLogicalViewProvider.class);
        }

        public PhpLogicalViewRootNode(PhpProject project) {
            super(PhpLogicalViewRootNode.createChildren(project), Lookups.singleton((Object)project));
            this.project = project;
            this.setIconBaseWithExtension("org/netbeans/modules/php/project/ui/resources/phpProject.png");
            this.setName(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }

        private static Children createChildren(PhpProject project) {
            return NodeFactorySupport.createCompositeChildren((Project)project, (String)"Projects/org-netbeans-modules-php-project/Nodes");
        }

        private static class FrameworkSubMenu
        extends JMenu {
            private static final long serialVersionUID = 9043114612433517414L;

            public FrameworkSubMenu(String name, List<? extends Action> frameworkActions) {
                super(name);
                assert (name != null);
                assert (frameworkActions != null);
                for (Action action : frameworkActions) {
                    if (action != null) {
                        this.add(FrameworkSubMenu.toMenuItem(action));
                        continue;
                    }
                    this.addSeparator();
                }
            }

            private static JMenuItem toMenuItem(Action action) {
                JMenuItem item;
                if (action instanceof Presenter.Menu) {
                    item = ((Presenter.Menu)action).getMenuPresenter();
                } else {
                    item = new JMenuItem();
                    Actions.connect((JMenuItem)item, (Action)action, (boolean)false);
                }
                return item;
            }
        }

        private static class FrameworkMenu
        extends AbstractAction
        implements Presenter.Popup {
            private static final long serialVersionUID = -238674120253122435L;
            private final String name;
            private final List<? extends Action> frameworkActions;

            public FrameworkMenu(String name, List<? extends Action> frameworkActions) {
                super(name, null);
                assert (name != null);
                assert (frameworkActions != null);
                this.name = name;
                this.frameworkActions = frameworkActions;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                assert (false);
            }

            public JMenuItem getPopupPresenter() {
                return new FrameworkSubMenu(this.name, this.frameworkActions);
            }
        }
    }
}

