/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions;

import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.ConfigAction;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public abstract class Command {
    private final PhpProject project;

    public Command(PhpProject project) {
        assert (project != null);
        this.project = project;
    }

    public abstract String getCommandId();

    public abstract void invokeAction(Lookup var1);

    public abstract boolean isActionEnabled(Lookup var1);

    public boolean asyncCallRequired() {
        return true;
    }

    public boolean saveRequired() {
        return true;
    }

    public boolean isFileSensitive() {
        return false;
    }

    public final PhpProject getProject() {
        return this.project;
    }

    protected boolean isScriptSelected() {
        PhpProjectProperties.RunAsType runAs = ProjectPropertiesSupport.getRunAs(this.project);
        return PhpProjectProperties.RunAsType.SCRIPT.equals((Object)runAs);
    }

    protected ConfigAction getConfigAction() {
        return ConfigAction.get(ConfigAction.convert(ProjectPropertiesSupport.getRunAs(this.project)), this.project);
    }

    protected boolean isTestFile(FileObject fileObj) {
        if (fileObj == null) {
            return false;
        }
        return CommandUtils.isUnderTests(this.project, fileObj, false);
    }

    protected boolean isSeleniumFile(FileObject fileObj) {
        if (fileObj == null) {
            return false;
        }
        return CommandUtils.isUnderSelenium(this.project, fileObj, false);
    }
}

