/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.IOException;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Element;

public final class UpdateHelper {
    private final UpdateImplementation updateProject;
    private final AntProjectHelper helper;

    public UpdateHelper(UpdateImplementation update, AntProjectHelper helper) {
        assert (update != null);
        assert (helper != null);
        this.updateProject = update;
        this.helper = helper;
    }

    public EditableProperties getProperties(final String path) {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(path)) {
                    return UpdateHelper.this.updateProject.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(path);
            }
        });
    }

    public void putProperties(final String path, final EditableProperties props) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(path)) {
                    UpdateHelper.this.helper.putProperties(path, props);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(props);
                        UpdateHelper.this.helper.putProperties(path, props);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean shared) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(shared);
                }
                return UpdateHelper.this.updateProject.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean shared) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (!shared || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, shared);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            }
        });
    }

    public boolean requestUpdate() throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    if (UpdateHelper.this.isCurrent()) {
                        return true;
                    }
                    if (!UpdateHelper.this.updateProject.canUpdate()) {
                        return false;
                    }
                    UpdateHelper.this.updateProject.saveUpdate(null);
                    return true;
                }
            });
        }
        catch (MutexException ex) {
            Exception inner = ex.getException();
            if (inner instanceof IOException) {
                throw (IOException)inner;
            }
            throw (RuntimeException)inner;
        }
    }

    public boolean isCurrent() {
        return this.updateProject.isCurrent();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }
}

