/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.bindings.properties;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.openide.ErrorManager;

public abstract class AbstractTokenList
implements TokenList {
    protected BaseDocument doc;
    private CharSequence currentWord;
    private int currentStartOffset;
    private int nextSearchOffset;
    private int ignoreBefore;

    AbstractTokenList(BaseDocument doc) {
        this.doc = doc;
    }

    public void setStartOffset(int offset) {
        this.currentWord = null;
        this.currentStartOffset = -1;
        this.ignoreBefore = offset;
        try {
            this.nextSearchOffset = Utilities.getRowStart((BaseDocument)this.doc, (int)offset);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AbstractTokenList.class.getName()).log(Level.FINE, null, ex);
            this.nextSearchOffset = offset;
        }
    }

    public int getCurrentWordStartOffset() {
        return this.currentStartOffset;
    }

    public CharSequence getCurrentWordText() {
        return this.currentWord;
    }

    private int[] findNextSpellSpan() throws BadLocationException {
        return this.findNextSpellSpan(this.doc.getSyntaxSupport(), this.nextSearchOffset);
    }

    protected abstract int[] findNextSpellSpan(SyntaxSupport var1, int var2) throws BadLocationException;

    public boolean nextWord() {
        boolean next = this.nextWordImpl();
        while (next && this.currentStartOffset + this.currentWord.length() < this.ignoreBefore) {
            next = this.nextWordImpl();
        }
        return next;
    }

    private boolean nextWordImpl() {
        try {
            int[] span = this.findNextSpellSpan();
            while (span[0] != -1) {
                int offset;
                int length = span[1];
                boolean searching = true;
                for (offset = span[0] < this.nextSearchOffset ? this.nextSearchOffset : span[0]; offset < length; ++offset) {
                    String t = this.doc.getText(offset, 1);
                    char c = t.charAt(0);
                    if (searching) {
                        if (!Character.isLetter(c)) continue;
                        searching = false;
                        this.currentStartOffset = offset;
                        continue;
                    }
                    if (Character.isLetter(c)) continue;
                    this.nextSearchOffset = offset;
                    this.currentWord = this.doc.getText(this.currentStartOffset, offset - this.currentStartOffset);
                    return true;
                }
                this.nextSearchOffset = offset;
                if (!searching) {
                    this.currentWord = this.doc.getText(this.currentStartOffset, offset - this.currentStartOffset);
                    return true;
                }
                span = this.findNextSpellSpan();
            }
            return false;
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return false;
        }
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

