/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Module;
import com.sun.javacard.validator.ModuleJCRD;
import com.sun.javacard.validator.ValidValues;
import java.io.File;

public class WebModuleJCRD
extends ModuleJCRD {
    private String webContextPath = null;
    private int webSecurePortNumber = -1;
    private boolean webClientAuthRequired = false;
    private boolean webSecureAccessOnly = false;

    public WebModuleJCRD(Module module, File file) {
        super(module, file);
    }

    public String getWebContextPath() {
        return this.webContextPath;
    }

    public void setWebContextPath(String string) {
        this.webContextPath = string;
    }

    public int getWebSecurePortNumber() {
        return this.webSecurePortNumber;
    }

    public void setWebSecurePortNumber(int n) {
        this.webSecurePortNumber = n;
    }

    public boolean isWebClientAuthRequired() {
        return this.webClientAuthRequired;
    }

    public void setWebClientAuthRequired(boolean bl) {
        this.webClientAuthRequired = bl;
    }

    public boolean isWebSecureAccessOnly() {
        return this.webSecureAccessOnly;
    }

    public void setWebSecureAccessOnly(boolean bl) {
        this.webSecureAccessOnly = bl;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isOk()) {
            return;
        }
        if (!this.applicationType.equals("web")) {
            this.addError(ErrorKey.InvliadAttributeApplicationTypeInJCRD, this.applicationType, "web application", "web");
        }
        this.webContextPath = this.getAttributeValue("Web-Context-Path");
        if (this.webContextPath == null) {
            this.addError(ErrorKey.MissingAttribute, "Web-Context-Path");
        } else if (this.webContextPath.equals("/platform") || this.webContextPath.equals("/standard") || this.webContextPath.equals("/default") || this.webContextPath.equals("/cardmanager") || this.webContextPath.startsWith("/platform/") || this.webContextPath.startsWith("/standard/") || this.webContextPath.startsWith("/default/") || this.webContextPath.startsWith("/cardmanager/")) {
            this.addWarning(ErrorKey.CanNotUseReservedNameForWebContextPath, this.webContextPath);
        }
        String string = null;
        string = this.getAttributeValue("Web-Secure-Port-Number", false);
        if (string != null) {
            try {
                this.webSecurePortNumber = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.addError(ErrorKey.InvalidAttributeValue, string, "Web-Secure-Port-Number");
            }
        }
        if ((string = this.getAttributeValue("Web-Secure-Access-Only")) != null) {
            if (ValidValues.isValidBoolean(string)) {
                this.webSecureAccessOnly = "true".equals(string);
            } else {
                this.addError(ErrorKey.InvalidAttributeValue, string, "Web-Secure-Access-Only");
            }
        }
        if ((string = this.getAttributeValue("Web-Client-Auth-Required")) != null) {
            if (ValidValues.isValidBoolean(string)) {
                this.webClientAuthRequired = "true".equals(string);
            } else {
                this.addError(ErrorKey.InvalidAttributeValue, string, "Web-Client-Auth-Required");
            }
        }
        if (this.getAttributeValue("Classic-Package-AID", true) != null) {
            this.addError(ErrorKey.MustNotPresent, "Classic-Package-AID", "Web");
        }
    }

    @Override
    public void processInternal() {
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
    }
}

