/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.tools.util;

import com.sun.javacard.tools.util.ConsoleFilter;
import com.sun.javacard.tools.util.JCConsoleHandler;
import com.sun.javacard.tools.util.JCToolsFormatter;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.Format;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class JCToolsLogger {
    private static Logger toolsLogger = null;
    private boolean printCurrentClassAndMethod;

    public static void main(String[] stringArray) {
        JCToolsLogger jCToolsLogger = new JCToolsLogger("test", "com.sun.javacard.tools.util.message");
        jCToolsLogger.info("msg1", new Object[0]);
    }

    JCToolsLogger(String string, String string2) {
        block6: {
            this.printCurrentClassAndMethod = false;
            try {
                toolsLogger = Logger.getLogger(string, string2);
                LogManager logManager = LogManager.getLogManager();
                String string3 = System.getProperty("jc.home");
                if (string3 == null) break block6;
                try {
                    FileInputStream fileInputStream;
                    if (System.getProperty("netbeans.home") == null && (fileInputStream = new FileInputStream(string3 + "/lib/logging.properties")) != null) {
                        logManager.readConfiguration(fileInputStream);
                        if (logManager.getProperty("printCurrentClassAndMethod").equalsIgnoreCase("true")) {
                            this.printCurrentClassAndMethod = true;
                        }
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    JCToolsLogger(String string) {
        block6: {
            this.printCurrentClassAndMethod = false;
            try {
                toolsLogger = Logger.getLogger(string);
                LogManager logManager = LogManager.getLogManager();
                String string2 = System.getProperty("jc.home");
                if (string2 == null) break block6;
                try {
                    FileInputStream fileInputStream;
                    if (System.getProperty("netbeans.home") == null && (fileInputStream = new FileInputStream(string2 + "/lib/logging.properties")) != null) {
                        logManager.readConfiguration(fileInputStream);
                        if (logManager.getProperty("printCurrentClassAndMethod").equalsIgnoreCase("true")) {
                            this.printCurrentClassAndMethod = true;
                        }
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addHandlers() {
        boolean bl = false;
        try {
            toolsLogger.setUseParentHandlers(false);
            toolsLogger.setFilter(new JCFilter());
            JCConsoleHandler jCConsoleHandler = new JCConsoleHandler();
            jCConsoleHandler.setFormatter(new JCToolsFormatter());
            jCConsoleHandler.setFilter(new ConsoleFilter());
            for (Handler handler : toolsLogger.getHandlers()) {
                if (!handler.getClass().getName().equals(JCConsoleHandler.class.getName())) continue;
                bl = true;
                break;
            }
            FileHandler fileHandler = new FileHandler("%h/java_tools%u.log", 100000, 1, true);
            fileHandler.setFormatter(new SimpleFormatter());
            toolsLogger.addHandler(fileHandler);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static JCToolsLogger getLogger(String string, String string2) {
        return new JCToolsLogger(string, string2);
    }

    public static JCToolsLogger getLogger(String string) {
        return new JCToolsLogger(string);
    }

    public void info(String string, Object ... objectArray) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.INFO, stackTraceElementArray[1].getClassName(), stackTraceElementArray[1].getMethodName(), string, objectArray);
        } else {
            toolsLogger.logp(Level.INFO, "", "", string, objectArray);
        }
    }

    public void severe(String string, Object ... objectArray) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.SEVERE, stackTraceElementArray[1].getClassName(), stackTraceElementArray[1].getMethodName(), string, objectArray);
        } else {
            toolsLogger.logp(Level.SEVERE, "", "", string, objectArray);
        }
        this.sendToSystemErr(string, objectArray);
    }

    public void warning(String string, Object ... objectArray) {
        if (this.printCurrentClassAndMethod) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            toolsLogger.logp(Level.WARNING, stackTraceElementArray[1].getClassName(), stackTraceElementArray[1].getMethodName(), string, objectArray);
        } else {
            toolsLogger.logp(Level.WARNING, "", "", string, objectArray);
        }
    }

    public void log(Level level, String string) {
        toolsLogger.log(level, string);
    }

    public void setLevel(Level level) {
        toolsLogger.setLevel(level);
    }

    public ResourceBundle getResourceBundle() {
        return toolsLogger.getResourceBundle();
    }

    private void sendToSystemErr(String string, Object ... objectArray) {
        try {
            Object object;
            if (string != null) {
                try {
                    object = toolsLogger.getResourceBundleName();
                    if (object != null) {
                        string = ResourceBundle.getBundle((String)object).getString(string);
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            object = new MessageFormat(string);
            System.err.println(((Format)object).format(objectArray));
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException.getMessage());
            nullPointerException.printStackTrace();
        }
    }

    class JCFilter
    implements Filter {
        String msg = null;

        JCFilter() {
        }

        @Override
        public boolean isLoggable(LogRecord logRecord) {
            String string = logRecord.getMessage();
            if (this.msg != null && this.msg.equals(string)) {
                return false;
            }
            this.msg = string;
            return true;
        }
    }
}

