/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm;

import com.sun.javacard.jcasm.Info;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.PackageIdentifier;

public class SuperMethodRefInfo
extends Info {
    protected JCClass theClass;
    protected int superMethodToken;

    SuperMethodRefInfo(PackageIdentifier packageIdentifier, String string) {
        super(4, packageIdentifier, string, string.substring(string.lastIndexOf(40)));
    }

    public void resolve(JCClass jCClass, int n) {
        this.theClass = jCClass;
        this.superMethodToken = n;
    }

    @Override
    public byte[] toByteArray(JCPackage jCPackage) {
        byte[] byArray = super.toByteArray(jCPackage);
        JCMethod jCMethod = (JCMethod)this.resolvedTo;
        if (jCMethod != null) {
            int n = jCMethod.getParentClass().getRelocAddr();
            byArray[1] = (byte)(n >> 8);
            byArray[2] = (byte)n;
            byArray[3] = (byte)jCMethod.getMethodIdentifier().getMethodToken();
        } else {
            int n = this.theClass.getRelocAddr();
            byArray[1] = (byte)(n >> 8);
            byArray[2] = (byte)n;
            byArray[3] = (byte)this.superMethodToken;
        }
        return byArray;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

