/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import com.sun.javacard.exportfile.ExportFileManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfClass
extends ClassDefinition {
    public static final short ACC_SHAREABLE = 2048;
    public static final short ACC_REMOTE = 4096;
    private int name_index;
    private int[] super_class_indexes;
    private String[] super_class_names;
    private int[] interface_indexes;
    private String[] interface_names;
    private EfField[] fields;
    private EfMethod[] methods;
    private EfConstantPool constant_pool;

    public EfClass(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfClass(ClassDefinition classDefinition, boolean bl, String[] stringArray, String[] stringArray2, EfConstantPool efConstantPool, EfField[] efFieldArray, EfMethod[] efMethodArray) {
        super(classDefinition);
        int n;
        this.access_flags &= 0xFFFFFFDF;
        if (bl) {
            this.access_flags |= 0x800;
        }
        if (classDefinition.isRemote()) {
            this.access_flags |= 0x1000;
        }
        if (Modifier.isInterface(this.access_flags)) {
            this.access_flags |= 0x400;
        }
        this.constant_pool = efConstantPool;
        this.name_index = efConstantPool.addConstantClassRef(this.class_name);
        this.super_class_names = stringArray;
        this.super_class_indexes = new int[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            this.super_class_indexes[n] = efConstantPool.addConstantClassRef(stringArray[n]);
        }
        this.interface_names = stringArray2;
        this.interface_indexes = new int[stringArray2.length];
        for (n = 0; n < stringArray2.length; ++n) {
            this.interface_indexes[n] = efConstantPool.addConstantClassRef(stringArray2[n]);
        }
        this.fields = efFieldArray;
        this.methods = efMethodArray;
    }

    public boolean isShareableType() {
        return (this.access_flags & 0x800) != 0;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        int n;
        this.token = dataInputStream.readUnsignedByte();
        this.access_flags = dataInputStream.readShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.super_class_indexes = new int[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.super_class_indexes.length; ++n) {
            this.super_class_indexes[n] = dataInputStream.readUnsignedShort();
        }
        this.interface_indexes = new int[dataInputStream.readUnsignedByte()];
        for (n = 0; n < this.interface_indexes.length; ++n) {
            this.interface_indexes[n] = dataInputStream.readUnsignedShort();
        }
        this.fields = new EfField[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.fields.length; ++n) {
            this.fields[n] = new EfField(this.constant_pool);
            this.fields[n].parse(dataInputStream);
        }
        this.methods = new EfMethod[dataInputStream.readUnsignedShort()];
        for (n = 0; n < this.methods.length; ++n) {
            this.methods[n] = new EfMethod(this.constant_pool);
            this.methods[n].parse(dataInputStream);
        }
    }

    public void resolve() {
        int n;
        this.class_name = this.constant_pool.getConstantClassRef(this.name_index).getClassName();
        this.super_class_names = new String[this.super_class_indexes.length];
        for (n = 0; n < this.super_class_indexes.length; ++n) {
            this.super_class_names[n] = this.constant_pool.getConstantClassRef(this.super_class_indexes[n]).getClassName();
        }
        this.interface_names = new String[this.interface_indexes.length];
        for (n = 0; n < this.interface_indexes.length; ++n) {
            this.interface_names[n] = this.constant_pool.getConstantClassRef(this.interface_indexes[n]).getClassName();
        }
        for (EfField object : this.fields) {
            object.resolve();
        }
        for (EfMethod efMethod : this.methods) {
            efMethod.resolve();
        }
        if (this.isInterfaceType() && !this.isAbstract()) {
            Object[] objectArray = new Object[]{this.getClassName().replace('/', '.')};
            Notifier.warning("flags.1", objectArray);
            this.setAbstract(true);
        }
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\t");
        }
        String string = stringBuffer.toString();
        printWriter.println(string + "class_info {" + "\t\t// " + this.class_name);
        printWriter.println(string + "\ttoken\t" + this.token);
        boolean bl = (this.access_flags & 0x800) != 0;
        boolean bl2 = (this.access_flags & 0x1000) != 0;
        int n3 = this.access_flags & 0xFFFFF7FF & 0xFFFFEFFF;
        printWriter.print(string + "\taccess_flags\t" + Modifier.toString(n3));
        if (bl) {
            printWriter.print(" shareable");
        }
        if (bl2) {
            printWriter.println(" remote");
        } else {
            printWriter.println();
        }
        printWriter.println(string + "\tname_index\t" + this.name_index + "\t\t// " + this.class_name);
        printWriter.println(string + "\texport_supers_count\t" + this.super_class_indexes.length);
        printWriter.println(string + "\tsupers {");
        for (n2 = 0; n2 < this.super_class_indexes.length; ++n2) {
            printWriter.println(string + "\t\tconstant_pool_index\t" + this.super_class_indexes[n2] + "\t\t// " + this.super_class_names[n2]);
        }
        printWriter.println(string + "\t}");
        printWriter.println(string + "\texport_interfaces_count\t" + this.interface_indexes.length);
        printWriter.println(string + "\tinterfaces {");
        for (n2 = 0; n2 < this.interface_indexes.length; ++n2) {
            printWriter.println(string + "\t\tconstant_pool_index\t" + this.interface_indexes[n2] + "\t\t// " + this.interface_names[n2]);
        }
        printWriter.println(string + "\t}");
        printWriter.println(string + "\texport_fields_count\t" + this.fields.length);
        printWriter.println(string + "\tfields {");
        for (EfField object : this.fields) {
            object.toText(printWriter, n + 1);
        }
        printWriter.println(string + "\t}");
        printWriter.println(string + "\texport_methods_count\t" + this.methods.length);
        printWriter.println(string + "\tmethods {");
        for (EfMethod efMethod : this.methods) {
            efMethod.toText(printWriter, n + 2);
        }
        printWriter.println(string + "\t}");
        printWriter.println(string + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.token);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.super_class_indexes.length);
        for (int n : this.super_class_indexes) {
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeByte(this.interface_indexes.length);
        for (int n : this.interface_indexes) {
            dataOutputStream.writeShort(n);
        }
        dataOutputStream.writeShort(this.fields.length);
        for (EfField efField : this.fields) {
            efField.toBinary(dataOutputStream);
        }
        dataOutputStream.writeShort(this.methods.length);
        for (EfMethod efMethod : this.methods) {
            efMethod.toBinary(dataOutputStream);
        }
        dataOutputStream.flush();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int[] getSuperClasses() {
        return this.super_class_indexes;
    }

    public String[] getSuperClassNames() {
        return this.super_class_names;
    }

    public int[] getInterfaces() {
        return this.interface_indexes;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public EfMethod getMethod(String string, String string2) {
        for (EfMethod efMethod : this.methods) {
            if (!efMethod.getMethodName().equals(string) || !efMethod.getMethodDescriptor().equals(string2)) continue;
            return efMethod;
        }
        return null;
    }

    public EfMethod getMethod(int n) {
        for (EfMethod efMethod : this.methods) {
            if (efMethod.getMethodToken() != n) continue;
            return efMethod;
        }
        return null;
    }

    public EfMethod[] getMethods() {
        return this.methods;
    }

    public EfField getField(String string, String string2) {
        for (EfField efField : this.fields) {
            if (!efField.getFieldName().equals(string) || !efField.getFieldDescriptor().equals(string2)) continue;
            return efField;
        }
        return null;
    }

    public EfField[] getFields() {
        return this.fields;
    }

    public boolean hasReferenceAPIField() {
        if (this.getFields().length == 0) {
            return false;
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            EfField efField = this.getFields()[i];
            if (!efField.isReferenceType()) continue;
            return true;
        }
        return false;
    }

    public void printFields() {
        System.out.println("\n Fields of " + this.getClassName() + " (in exp file)");
        for (int i = 0; i < this.fields.length; ++i) {
            EfField efField = this.fields[i];
            String string = "" + i + " " + efField.getFieldToken() + " " + (efField.isPublic() ? "public" : "") + " " + (efField.isProtected() ? "protected" : "") + " " + (efField.isStatic() ? "static" : "") + " " + (efField.isFinal() ? "final" : "") + " " + efField.getFieldDescriptor() + " " + efField.getFieldName();
            System.out.println(string);
        }
    }

    public void printMethods() {
        System.out.println("\n Methods of " + this.getClassName() + " (in exp file)");
        for (int i = 0; i < this.methods.length; ++i) {
            EfMethod efMethod = this.methods[i];
            String string = "" + i + " " + efMethod.getMethodToken() + " " + (efMethod.isPublic() ? "public" : "") + " " + (efMethod.isProtected() ? "protected" : "") + " " + (efMethod.isStatic() ? "static" : "") + " " + (efMethod.isFinal() ? "final" : "") + " " + (efMethod.isAbstract() ? "abstract" : "") + " " + efMethod.getMethodDescriptor() + " " + efMethod.getMethodName();
            System.out.println(string);
        }
    }

    @Override
    public boolean isRemote() {
        return (this.access_flags & 0x1000) != 0;
    }

    public String getSuperClassName(ExportFileManager exportFileManager) throws Exception {
        String string = super.getSuperClassName();
        if (string != null) {
            return string;
        }
        if (this.super_class_names.length == 1) {
            super.setSuperClassName(this.super_class_names[0]);
            return this.super_class_names[0];
        }
        int[] nArray = new int[this.super_class_names.length];
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = exportFileManager.getClass(this.super_class_names[i]).getSuperClasses().length;
            if (n3 <= n2) continue;
            n3 = n2;
            n = i;
        }
        if (n >= 0) {
            super.setSuperClassName(this.super_class_names[n]);
            return this.super_class_names[n];
        }
        return null;
    }
}

