/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.JClassFile;
import com.sun.javacard.classfile.JPackage;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.converters.BaseClassInterfaceConverter;
import com.sun.javacard.converter.converters.ClassConverter;
import com.sun.javacard.converter.converters.InterfaceConverter;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.EfClass;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class PackageConverter {
    private JPackage java_package;
    private ExportFileManager export_file_manager;
    private JcPackage jc_package;
    private boolean int_support = false;
    private boolean this_exp_provided = false;
    private boolean convert_bc = false;
    private JcConstantPool jc_cp;
    private ConversionProfile conversion_profile;

    public PackageConverter(JPackage jPackage, ConversionProfile conversionProfile, ExportFileManager exportFileManager) throws Exception {
        this.java_package = jPackage;
        this.jc_package = new JcPackage(jPackage);
        this.jc_cp = new JcConstantPool();
        this.jc_package.setConstantPool(this.jc_cp);
        this.jc_package.setAID(conversionProfile.package_profile.aid);
        this.jc_package.setPackageMajorVersion(conversionProfile.package_profile.major_version);
        this.jc_package.setPackageMinorVersion(conversionProfile.package_profile.minor_version);
        this.conversion_profile = conversionProfile;
        this.export_file_manager = exportFileManager;
        this.int_support = conversionProfile.int_supported;
        this.this_exp_provided = conversionProfile.this_exp_provided;
        this.convert_bc = conversionProfile.output != 2;
        if (this.this_exp_provided) {
            this.jc_package.setEfExportFile(exportFileManager.getExportFile(jPackage.getPackageName()));
        } else {
            this.jc_package.setEfExportFile(null);
        }
    }

    public JPackage getJavaPackage() {
        return this.java_package;
    }

    public JcPackage getJcPackage() {
        return this.jc_package;
    }

    public JcConstantPool getJcConstantPool() {
        return this.jc_cp;
    }

    public ExportFileManager getExportFileManager() {
        return this.export_file_manager;
    }

    public boolean isIntSupported() {
        return this.int_support;
    }

    public boolean isThisExpProvided() {
        return this.this_exp_provided;
    }

    public boolean convertByteCode() {
        return this.convert_bc;
    }

    public void setIntFlag(boolean bl) {
        this.jc_package.setIntFlag(bl);
    }

    public JcPackage convert() throws Exception {
        if (this.isThisExpProvided()) {
            this.checkAID();
        }
        JcAppletInfo[] jcAppletInfoArray = this.constructAppletInfos();
        this.jc_package.setAppletInfos(jcAppletInfoArray);
        if (jcAppletInfoArray.length > 0) {
            this.getJcPackage().setAppletFlag(true);
        }
        JClassFile[] jClassFileArray = this.java_package.getClasses();
        this.sortClasses(jClassFileArray);
        JcClass[] jcClassArray = new JcClass[jClassFileArray.length];
        this.jc_package.setClasses(jcClassArray);
        for (int i = 0; i < jClassFileArray.length; ++i) {
            BaseClassInterfaceConverter baseClassInterfaceConverter;
            JClassFile jClassFile = jClassFileArray[i];
            Notifier.progress("progress.2", jClassFile.getClassName().replace('/', '.'));
            if (!Names.getPackageName(jClassFile.getClassName()).equals(this.java_package.getPackageName())) {
                Object[] objectArray = new Object[]{Names.getClassName(jClassFile.getClassName(), 47), this.java_package.getPackageName().replace('/', '.')};
                Notifier.error("conversion.1", objectArray);
                throw new ConverterException();
            }
            int n = jClassFile.getAccessFlags();
            if (Modifier.isInterface(n)) {
                baseClassInterfaceConverter = new InterfaceConverter(jClassFile, this);
                jcClassArray[i] = ((InterfaceConverter)baseClassInterfaceConverter).convert();
                continue;
            }
            baseClassInterfaceConverter = new ClassConverter(jClassFile, this);
            jcClassArray[i] = ((ClassConverter)baseClassInterfaceConverter).convert();
        }
        if (this.jc_package.getIntFlag()) {
            Notifier.warning("warning.0");
        }
        if (this.this_exp_provided) {
            this.detectRemovedAPIClasses();
            this.detectAddedAPIClasses();
            this.checkClassFlags();
        }
        this.assignClassTokens(jcClassArray);
        this.checkForMultiSelectableApplets();
        this.jc_cp.setIndex();
        return this.jc_package;
    }

    private void detectAddedAPIClasses() throws Exception {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        EfClass[] efClassArray = this.jc_package.getEfExportFile().getClasses();
        for (int i = 0; i < jcClassArray.length; ++i) {
            JcClass jcClass = jcClassArray[i];
            if (!jcClass.isAPIElement(this.jc_package)) continue;
            if (this.conversion_profile.debug) {
                // empty if block
            }
            EfClass efClass = jcClass.getEfClass();
            if (!this.conversion_profile.debug || efClass == null) {
                // empty if block
            }
            if (!this.conversion_profile.packageUpgrade && efClass == null) {
                Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.')};
                Notifier.error("binary.40", objectArray);
                throw new ConversionException();
            }
            if (this.conversion_profile.packageUpgrade || efClass == null) continue;
            if (efClass.isFinal() && !jcClass.isFinal()) {
                Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.')};
                Notifier.error("binary.41", objectArray);
                throw new ConversionException();
            }
            if (!efClass.isAbstract() || jcClass.isAbstract()) continue;
            Object[] objectArray = new Object[]{jcClass.getClassName().replace('/', '.')};
            Notifier.error("binary.42", objectArray);
            throw new ConversionException();
        }
    }

    private void detectRemovedAPIClasses() throws Exception {
        if (this.conversion_profile.debug) {
            // empty if block
        }
        JcClass[] jcClassArray = this.jc_package.getClasses();
        EfClass[] efClassArray = this.jc_package.getEfExportFile().getClasses();
        for (int i = 0; i < efClassArray.length; ++i) {
            EfClass efClass = efClassArray[i];
            if (this.conversion_profile.debug) {
                // empty if block
            }
            JcClass jcClass = this.jc_package.getClass(efClass.getClassName());
            if (!this.conversion_profile.debug || jcClass == null) {
                // empty if block
            }
            if (jcClass == null) {
                Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.43", objectArray);
                throw new ConversionException();
            }
            if (jcClass.isAPIElement(this.jc_package)) continue;
            Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
            Notifier.error("binary.44", objectArray);
            throw new ConversionException();
        }
    }

    private void checkForMultiSelectableApplets() throws Exception {
        if (this.conversion_profile.applets_profile == null) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.conversion_profile.applets_profile.length; ++i) {
            JcClass jcClass = this.getJcClass(this.conversion_profile.applets_profile[i].install_class);
            if (jcClass == null) continue;
            if (jcClass.isMultiSelectable()) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            Notifier.error("subset.58");
            throw new ConversionException();
        }
    }

    private void checkClassFlags() throws Exception {
        if (this.conversion_profile.debug) {
            // empty if block
        }
        JcClass[] jcClassArray = this.jc_package.getClasses();
        for (int i = 0; i < jcClassArray.length; ++i) {
            if (jcClassArray[i].getEfClass() == null) continue;
            JcClass jcClass = jcClassArray[i];
            EfClass efClass = jcClass.getEfClass();
            if (!efClass.isFinal() && jcClass.isFinal()) {
                Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.45", objectArray);
                throw new ConversionException();
            }
            if (!efClass.isAbstract() && jcClass.isAbstract()) {
                Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.46", objectArray);
                throw new ConversionException();
            }
            if (!efClass.isInterfaceType() && jcClass.isInterfaceType()) {
                Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
                Notifier.error("binary.47", objectArray);
                throw new ConversionException();
            }
            if (!efClass.isInterfaceType() || jcClass.isInterfaceType()) continue;
            Object[] objectArray = new Object[]{efClass.getClassName().replace('/', '.')};
            Notifier.error("binary.48", objectArray);
            throw new ConversionException();
        }
    }

    private JcAppletInfo[] constructAppletInfos() {
        AppletProfile[] appletProfileArray = this.conversion_profile.applets_profile;
        JcAppletInfo[] jcAppletInfoArray = new JcAppletInfo[appletProfileArray.length];
        for (int i = 0; i < appletProfileArray.length; ++i) {
            jcAppletInfoArray[i] = new JcAppletInfo(appletProfileArray[i].install_class, appletProfileArray[i].aid);
        }
        return jcAppletInfoArray;
    }

    private void assignClassTokens(JcClass[] jcClassArray) {
        JcClass jcClass;
        int n;
        int n2 = 0;
        for (n = 0; n < jcClassArray.length; ++n) {
            jcClass = jcClassArray[n];
            jcClass.setClassToken(255);
            if (!jcClass.isAPIElement(this.jc_package) || jcClass.getEfClass() == null) continue;
            int n3 = jcClass.getEfClass().getClassToken();
            jcClass.setClassToken(n3);
            if (n3 < n2) continue;
            n2 = n3 + 1;
        }
        for (n = 0; n < jcClassArray.length; ++n) {
            jcClass = jcClassArray[n];
            if (jcClass.getClassToken() != 255 || !jcClass.isAPIElement(this.jc_package)) continue;
            jcClass.setClassToken(n2++);
        }
        for (n = 0; n < jcClassArray.length; ++n) {
            jcClass = jcClassArray[n];
            if (jcClass.getClassToken() != 255 || !jcClass.isPublic()) continue;
            jcClass.setClassToken(n2++);
        }
    }

    private void sortClasses(JClassFile[] jClassFileArray) {
        int n;
        JClassFile jClassFile;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < jClassFileArray.length; ++n2) {
            jClassFile = jClassFileArray[n2];
            n = jClassFile.getAccessFlags();
            if (!Modifier.isInterface(n)) continue;
            if (n2 > n3) {
                jClassFileArray[n2] = jClassFileArray[n3];
                jClassFileArray[n3] = jClassFile;
            }
            ++n3;
        }
        block1: for (n2 = 0; n2 < jClassFileArray.length; ++n2) {
            Object object;
            jClassFile = jClassFileArray[n2];
            n = jClassFile.getAccessFlags();
            if (Modifier.isInterface(n)) {
                for (String string : object = jClassFile.getInterfaceNames()) {
                    if (!this.swapClass(n2, string)) continue;
                    --n2;
                    continue block1;
                }
                continue;
            }
            object = jClassFile.getSuperClassName();
            if (object == null || !this.swapClass(n2, (String)object)) continue;
            --n2;
        }
    }

    private boolean swapClass(int n, String string) {
        JClassFile[] jClassFileArray = this.java_package.getClasses();
        for (int i = n + 1; i < jClassFileArray.length; ++i) {
            JClassFile jClassFile = jClassFileArray[i];
            if (!jClassFile.getClassName().equals(string)) continue;
            jClassFileArray[i] = jClassFileArray[n];
            jClassFileArray[n] = jClassFile;
            return true;
        }
        return false;
    }

    public JcClass getJcClass(String string) {
        if (this.jc_package == null) {
            return null;
        }
        JcClass[] jcClassArray = this.jc_package.getClasses();
        if (jcClassArray == null) {
            return null;
        }
        for (JcClass jcClass : jcClassArray) {
            String string2;
            if (jcClass == null || (string2 = jcClass.getClassName()) == null || !string2.equals(string)) continue;
            return jcClass;
        }
        return null;
    }

    public ConversionProfile getConversionProfile() {
        return this.conversion_profile;
    }

    private void checkAID() throws Exception {
        byte[] byArray = this.getConversionProfile().package_profile.aid;
        byte[] byArray2 = this.getJcPackage().getEfExportFile().getAID();
        if (Arrays.equals(byArray, byArray2)) {
            return;
        }
        Object[] objectArray = new Object[]{Strings.toHexString(byArray2, ":"), Strings.toHexString(byArray, ":")};
        Notifier.error("binary.49", objectArray);
        throw new ConversionException();
    }
}

