/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.AttributeInfo;
import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.ExnHandlerInfo;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import java.io.ByteArrayOutputStream;
import java.util.Vector;

public class ExceptionsAttribute
extends AttributeInfo {
    private ClassConstantPool constantPool;
    private static final String attributeName = "Exceptions";
    private short attributeNameIndex = (short)-1;
    private MethodDescriptor md;
    Vector<Short> exceptionIndexTable;

    public ExceptionsAttribute(ClassConstantPool classConstantPool, MethodDescriptor methodDescriptor) {
        this.constantPool = classConstantPool;
        this.md = methodDescriptor;
        this.exceptionIndexTable = new Vector();
        this.attributeNameIndex = (short)this.constantPool.addConstantUtf8Info(attributeName);
        this.setNameIndex(this.attributeNameIndex);
        this.createtExceptionsList();
    }

    private void createtExceptionsList() {
        int n = this.md.methodOffset();
        int n2 = this.md.bytecodeCount();
        int n3 = n + this.md.bytecodeCount();
        int n4 = Cap.Method.handlerCount();
        for (int i = 0; i < n4; ++i) {
            ExnHandlerInfo exnHandlerInfo = Cap.Method.exceptionHandler(i);
            int n5 = exnHandlerInfo.startOffset();
            int n6 = exnHandlerInfo.endOffset();
            if (n5 < n || n5 >= n3 || n6 >= n3) continue;
            String string = null;
            int n7 = exnHandlerInfo.catchType();
            ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n7);
            int n8 = constantPoolEntry.classRef();
            string = CAPUtil.getRefName(n8);
            short s = this.constantPool.getClassRefIndex(string);
            this.exceptionIndexTable.add(new Short(s));
            this.length += 2;
        }
    }

    public int getExceptionsCount() {
        return this.exceptionIndexTable.size();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ExceptionsAttribute)) {
            return false;
        }
        if (this.length != ((ExceptionsAttribute)object).length) {
            return false;
        }
        return this.exceptionIndexTable.equals(((ExceptionsAttribute)object).exceptionIndexTable);
    }

    @Override
    void write(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = Util.getShortBytes(this.attributeNameIndex);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        byteArrayOutputStream.write(byArray2, 0, 4);
        int n = this.exceptionIndexTable.size();
        byte[] byArray3 = Util.getShortBytes((short)n);
        byteArrayOutputStream.write(byArray3, 0, 2);
        for (int i = 0; i < n; ++i) {
            Short s = this.exceptionIndexTable.elementAt(i);
            byte[] byArray4 = Util.getShortBytes(s);
            byteArrayOutputStream.write(byArray4, 0, 2);
        }
    }

    @Override
    public void print(String string) {
        byte[] byArray = Util.getShortBytes(this.nameIndex);
        Util.printArray(string + "\tAttribute name index: ", byArray, byArray.length);
        byte[] byArray2 = Util.getIntBytes(this.length);
        Util.printArray(string + "\tAttribute Length (" + this.length + "): ", byArray2, 4);
        int n = this.exceptionIndexTable.size();
        byte[] byArray3 = Util.getShortBytes((short)n);
        Util.printArray(string + "\tNumber of exceptions: ", byArray3, byArray3.length);
        System.out.println(string + "\tException Ref List");
        for (int i = 0; i < n; ++i) {
            Short s = this.exceptionIndexTable.elementAt(i);
            byte[] byArray4 = Util.getShortBytes(s);
            Util.printArray(string + "\t", byArray4, 2);
        }
    }
}

