/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.ClassConstantPool;
import com.sun.javacard.components.caputils.Util;
import com.sun.javacard.components.caputils.instructions.Instruction;
import com.sun.javacard.components.caputils.instructions.JCArithmeticInstr;
import com.sun.javacard.components.caputils.instructions.JCConstInstr;
import com.sun.javacard.components.caputils.instructions.JCControlInstr;
import com.sun.javacard.components.caputils.instructions.JCFieldAccessInstr;
import com.sun.javacard.components.caputils.instructions.JCInvokeInstr;
import com.sun.javacard.components.caputils.instructions.JCLoadInstr;
import com.sun.javacard.components.caputils.instructions.JCObjectInstr;
import com.sun.javacard.components.caputils.instructions.JCPushInstr;
import com.sun.javacard.components.caputils.instructions.JCStackInstr;
import com.sun.javacard.components.caputils.instructions.JCStoreInstr;
import com.sun.javacard.components.caputils.instructions.JavaInstruction;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.Instr;
import com.sun.javacard.offcardverifier.InstrLookupSwitch;
import com.sun.javacard.offcardverifier.InstrTableSwitch;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import java.util.Vector;

public class BCConverter {
    public static Vector<Instruction> convert(MethodDescriptor methodDescriptor, boolean bl, ClassConstantPool classConstantPool) {
        MethodInfo methodInfo = Cap.Method.methodInfo(methodDescriptor.methodOffset());
        Safeptr safeptr = bl ? methodInfo.bytecodeExtended() : methodInfo.bytecodeCompact();
        Instr[] instrArray = Instr.instrsBetween(safeptr, methodDescriptor.bytecodeCount());
        Vector<Instruction> vector = new Vector<Instruction>();
        for (int i = 0; i < instrArray.length; i += instrArray[i].length()) {
            Instruction instruction = null;
            switch (instrArray[i].opcode) {
                case 0: {
                    instruction = new Instruction(instrArray[i], new JavaInstruction(0));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    instruction = new JCConstInstr(instrArray[i]);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    instruction = new JCPushInstr(instrArray[i], classConstantPool);
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    instruction = new JCLoadInstr(instrArray[i]);
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    instruction = new JCStoreInstr(instrArray[i]);
                    break;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: {
                    instruction = new JCStackInstr(instrArray[i]);
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 150: 
                case 151: {
                    instruction = new JCArithmeticInstr(instrArray[i]);
                    break;
                }
                case 95: {
                    vector.add(new JCControlInstr(instrArray[i], vector));
                    int n = i + instrArray[i].length();
                    instruction = new JCControlInstr(instrArray[i], instrArray[n]);
                    i = n;
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 147: 
                case 152: 
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    instruction = new JCControlInstr(instrArray[i], vector);
                    break;
                }
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    instruction = new JCFieldAccessInstr(instrArray[i], classConstantPool);
                    break;
                }
                case 139: 
                case 140: 
                case 141: 
                case 142: {
                    instruction = new JCInvokeInstr(instrArray[i], classConstantPool);
                    break;
                }
                case 143: 
                case 144: 
                case 145: 
                case 146: 
                case 148: 
                case 149: {
                    instruction = new JCObjectInstr(instrArray[i], classConstantPool);
                }
            }
            vector.add(instruction);
        }
        return vector;
    }

    public static void fixOffsets(Vector<Instruction> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Instruction instruction = vector.elementAt(i);
            Instr instr = instruction.getJCInstruction();
            if (instr.opcode == 117 || instr.opcode == 118) {
                BCConverter.fixLookupSwitchOffsets(instruction, i, vector);
            }
            if (instr.opcode == 115 || instr.opcode == 116) {
                BCConverter.fixTableSwitchOffsets(instruction, i, vector);
            }
            if (!BCConverter.isBranchInstruction(instr.opcode)) continue;
            int n = instr.arg;
            int n2 = 0;
            if (n > 0) {
                n2 = BCConverter.getForwardBranchOffset(vector, i, n);
            } else if (n < 0) {
                n2 = BCConverter.getBackwardBranchOffset(vector, i, n);
            }
            instruction.getJavaInstructions().elementAt(0).fixJumpOffsetArgument(n2);
        }
    }

    private static void fixLookupSwitchOffsets(Instruction instruction, int n, Vector<Instruction> vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        InstrLookupSwitch instrLookupSwitch = (InstrLookupSwitch)instruction.getJCInstruction();
        int n3 = JCControlInstr.getNumPadBytes(vector, n);
        for (n2 = 0; n2 < n3; ++n2) {
            vector2.add(new Integer(0));
        }
        if (instrLookupSwitch.dfl >= 0) {
            BCConverter.addIntegerArgument(vector2, BCConverter.getForwardBranchOffset(vector, n, instrLookupSwitch.dfl));
        } else {
            BCConverter.addIntegerArgument(vector2, BCConverter.getBackwardBranchOffset(vector, n, instrLookupSwitch.dfl));
        }
        BCConverter.addIntegerArgument(vector2, instrLookupSwitch.ncases);
        for (n2 = 0; n2 < instrLookupSwitch.ncases; ++n2) {
            BCConverter.addIntegerArgument(vector2, instrLookupSwitch.keys[n2]);
            if (instrLookupSwitch.offsets[n2] >= 0) {
                BCConverter.addIntegerArgument(vector2, BCConverter.getForwardBranchOffset(vector, n, instrLookupSwitch.offsets[n2]));
                continue;
            }
            BCConverter.addIntegerArgument(vector2, BCConverter.getBackwardBranchOffset(vector, n, instrLookupSwitch.offsets[n2]));
        }
        instruction.getJavaInstructions().elementAt(0).fixSwitchOffsetArguments(vector2);
    }

    private static void fixTableSwitchOffsets(Instruction instruction, int n, Vector<Instruction> vector) {
        int n2;
        Vector<Integer> vector2 = new Vector<Integer>();
        InstrTableSwitch instrTableSwitch = (InstrTableSwitch)instruction.getJCInstruction();
        int n3 = JCControlInstr.getNumPadBytes(vector, n);
        for (n2 = 0; n2 < n3; ++n2) {
            vector2.add(new Integer(0));
        }
        if (instrTableSwitch.dfl >= 0) {
            BCConverter.addIntegerArgument(vector2, BCConverter.getForwardBranchOffset(vector, n, instrTableSwitch.dfl));
        } else {
            BCConverter.addIntegerArgument(vector2, BCConverter.getBackwardBranchOffset(vector, n, instrTableSwitch.dfl));
        }
        BCConverter.addIntegerArgument(vector2, instrTableSwitch.low);
        BCConverter.addIntegerArgument(vector2, instrTableSwitch.high);
        for (n2 = 0; n2 < instrTableSwitch.offsets.length; ++n2) {
            if (instrTableSwitch.offsets[n2] >= 0) {
                BCConverter.addIntegerArgument(vector2, BCConverter.getForwardBranchOffset(vector, n, instrTableSwitch.offsets[n2]));
                continue;
            }
            BCConverter.addIntegerArgument(vector2, BCConverter.getBackwardBranchOffset(vector, n, instrTableSwitch.offsets[n2]));
        }
        instruction.getJavaInstructions().elementAt(0).fixSwitchOffsetArguments(vector2);
    }

    private static int getForwardBranchOffset(Vector<Instruction> vector, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n3 != n2) {
            Instruction instruction = vector.elementAt(n5);
            n3 += instruction.getJCInstruction().length();
            Vector<JavaInstruction> vector2 = instruction.getJavaInstructions();
            for (int i = 0; i < vector2.size(); ++i) {
                n4 += vector2.elementAt(i).getSize();
            }
            ++n5;
        }
        return n4;
    }

    public static short translateOffset(Vector<Instruction> vector, short n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < n) {
            Instruction instruction = vector.elementAt(n4);
            n2 += instruction.getJCInstruction().length();
            Vector<JavaInstruction> vector2 = instruction.getJavaInstructions();
            for (int i = 0; i < vector2.size(); ++i) {
                n3 += vector2.elementAt(i).getSize();
            }
            ++n4;
        }
        return (short)n3;
    }

    private static int getBackwardBranchOffset(Vector<Instruction> vector, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n3 != n2) {
            Instruction instruction = vector.elementAt(--n5);
            n3 -= instruction.getJCInstruction().length();
            Vector<JavaInstruction> vector2 = instruction.getJavaInstructions();
            for (int i = 0; i < vector2.size(); ++i) {
                n4 -= vector2.elementAt(i).getSize();
            }
        }
        return n4;
    }

    private static boolean isBranchInstruction(int n) {
        switch (n) {
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: {
                return true;
            }
        }
        return false;
    }

    private static void addIntegerArgument(Vector<Integer> vector, int n) {
        byte[] byArray = Util.getIntBytes(n);
        for (int i = 0; i < 4; ++i) {
            vector.add(new Integer(byArray[i]));
        }
    }
}

